/**
 * @file ViewController.h
 * @brief TEPRA-Print SDK ViewController Class definition
 * @par Copyright:
 * (C) 2013-2019 KING JIM CO.,LTD.<BR>
 */

#import <UIKit/UIKit.h>

#import "TepraPrint.h"
#import "TepraPrintDiscoverPrinter.h"
#import "DiscoverTableViewController.h"
#import "FormSelectTableViewController.h"
#import "PrintSettingsViewController.h"

@interface ViewController : UIViewController
<TepraPrintDelegate,
TepraPrintDiscoverPrinterDelegate,
DiscoverTableViewControllerDelegate,
FormSelectTableViewControllerDelegate,
PrintSettingsViewControllerDelegate
>

@property (nonatomic, weak) IBOutlet UILabel *tepraStatusLabel;
@property (nonatomic, weak) IBOutlet UILabel *tapeLabel;
@property (nonatomic, weak) IBOutlet UIActivityIndicatorView *statusIndicator;
@property (nonatomic, weak) IBOutlet UILabel *printPhase;
@property (nonatomic, weak) IBOutlet UILabel *printingPage;
@property (nonatomic, weak) IBOutlet UIActivityIndicatorView *feedIndicator;
@property (nonatomic, weak) IBOutlet UIButton *printButton;
@property (nonatomic, weak) IBOutlet UIButton *tapeFeedBUtton;
@property (nonatomic, weak) IBOutlet UIButton *tapeCutButton;
@property (nonatomic, weak) IBOutlet UIButton *cancelButton;
@property (nonatomic, weak) IBOutlet UIButton *discoverButton;
@property (nonatomic, weak) IBOutlet UIButton *formSelectButton;
@property (nonatomic, weak) IBOutlet UIButton *printSettingsButton;
@property (nonatomic, weak) IBOutlet UIProgressView *progressView;
@property (nonatomic) BOOL processing;

- (IBAction)doPrint:(id)sender;
- (IBAction)fetchStatus:(id)sender;
- (IBAction)tapeFeed:(id)sender;
- (IBAction)tapeCut:(id)sender;
- (IBAction)doCancel:(id)sender;

- (void)saveCurrentData;

@end

