/**
 * @file SampleDataProvider.m
 * @brief TEPRA-Print SDK SampleDataProvider Class definition
 * @par Copyright:
 * (C) 2013-2019 KING JIM CO.,LTD.<BR>
 */

#import "SampleDataProvider.h"
@interface SampleDataProvider ()
{
    __strong NSDictionary *_formData;
    __strong NSArray *_contentsData;
}
@end

@implementation SampleDataProvider

- (instancetype)initWithFormName:(NSString *)formName
{
    self = [super init];
    if(self != nil) {
        // Form data
        NSString* formPath = [[NSBundle mainBundle] pathForResource:formName ofType:@"plist"];
        _formData = [[NSDictionary alloc] initWithContentsOfFile:formPath];
        
        // Contents data
        NSString* contentsPath = [[NSBundle mainBundle] pathForResource:[formName stringByAppendingString:@"_CONTENTS"] ofType:@"plist"];
        _contentsData = [[NSArray alloc] initWithContentsOfFile:contentsPath];
    }
    return self;
}

- (void)startOfPrint
{
}

- (void)endOfPrint
{
}

- (void)startPage
{
}

- (void)endPage
{
}

- (NSInteger)numberOfPages
{
    return [_contentsData count];
}
- (NSDictionary *)formDataForPage:(NSInteger)pageIndex
{
    return _formData;
}

- (id)contentData:(NSString *)contentName forPage:(NSInteger)pageIndex
{
    NSInteger index = pageIndex - 1;
    //index = 2;
    
    NSDictionary *pageDictionary = _contentsData[index];
    NSString *content = pageDictionary[contentName];
    if([contentName rangeOfString:@"Image"].location != NSNotFound) {
        return [UIImage imageNamed:content];
    } else {
        return content;
    }
}

@end
