/**
 * @file PrintSettingsViewController.h
 * @brief TEPRA-Print SDK Class PrintSettingsViewController definition
 * @par Copyright:
 * (C) 2013-2019 KING JIM CO.,LTD.<BR>
 */

#import <UIKit/UIKit.h>

@protocol PrintSettingsViewControllerDelegate;

@interface PrintSettingsViewController : UITableViewController <UITextFieldDelegate>

@property(weak, nonatomic) id<PrintSettingsViewControllerDelegate> delegate;

@property (nonatomic,weak) NSDictionary *settings;
@property (nonatomic,weak) NSDictionary *printerInfo;

- (IBAction)doneButton:(id)sender;

@end

@protocol PrintSettingsViewControllerDelegate <NSObject>
@optional

- (void)printSettingsView:(PrintSettingsViewController *)printSettingsView didEndSettings:(NSDictionary *)settings;

@end
