/**
 * @file FormSelectTableViewController.m
 * @brief TEPRA-Print SDK FormSelectTableViewController Class
 * @par Copyright:
 * (C) 2013-2019 KING JIM CO.,LTD.<BR>
 */

#import "FormSelectTableViewController.h"

@interface FormSelectTableViewController ()
{
    __strong NSMutableArray *_formList;
    BOOL _isAllSelect;
}
@end

@implementation FormSelectTableViewController

- (id)initWithStyle:(UITableViewStyle)style
{
    self = [super initWithStyle:style];
    if (self) {
        // Custom initialization
    }
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    _formList = [NSMutableArray array];
    for(NSString *form in _formDataList) {
        BOOL isHit = NO;
        for(NSString *select in _selectForms) {
            if([form isEqualToString:select] == YES) {
                isHit = YES;
                break;
            }
        }
        if(isHit == YES) {
            [_formList addObject:[NSArray arrayWithObjects:form, [NSNumber numberWithBool:YES], nil]];
        } else {
            [_formList addObject:[NSArray arrayWithObjects:form, [NSNumber numberWithBool:NO], nil]];
        }
    }
    if([_formList count] == [_selectForms count]) {
        _isAllSelect = YES;
    } else {
        _isAllSelect = NO;
    }
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
}

#pragma mark - Table view data source

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 1;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return [_formList count];
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    static NSString *CellIdentifier = @"FormCell";
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellIdentifier];
    }
    
    NSArray *formData = [_formList objectAtIndex:indexPath.row];
    cell.textLabel.text = formData[0];
    if([formData[1] boolValue]) {
        cell.accessoryType = UITableViewCellAccessoryCheckmark;
    } else {
        cell.accessoryType = UITableViewCellAccessoryNone;
    }
    
    return cell;
}

#pragma mark - Table view delegate

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    
    NSArray *formData = [_formList objectAtIndex:indexPath.row];
    UITableViewCell *cell = [tableView cellForRowAtIndexPath:indexPath];
    BOOL check;
    if([formData[1] boolValue]) {
        cell.accessoryType = UITableViewCellAccessoryNone;
        check = NO;
    } else {
        cell.accessoryType = UITableViewCellAccessoryCheckmark;
        check = YES;
    }
    [_formList replaceObjectAtIndex:indexPath.row withObject:@[formData[0], [NSNumber numberWithBool:check]]];

}

#pragma mark - IBAction

- (IBAction)doneButton:(id)sender
{
    NSMutableArray *list = [NSMutableArray array];
    for(NSArray *formData in _formList) {
        if([formData[1] boolValue] == YES) {
            [list addObject:[formData objectAtIndex:0]];
        }
    }
    if([list count] == 0) {
        if(_formList && [_formList count] != 0) {
            [list addObject:[[_formList objectAtIndex:0] objectAtIndex:0]];
        } else {
            list = nil;
        }
    }
    if ( [self.delegate respondsToSelector:@selector(formSelectView:didSelectForm:)] ) {
        [self.delegate formSelectView:self didSelectForm:list];
    }

    [self dismissViewControllerAnimated:YES completion:nil];
}

- (IBAction)allButton:(id)sender
{
    
    _isAllSelect = !_isAllSelect;
    
    NSArray *array = [NSArray arrayWithArray:_formList];
    NSInteger i = 0;
    for(NSArray *form in array) {
        [_formList replaceObjectAtIndex:i++ withObject:[NSArray arrayWithObjects:[form objectAtIndex:0], [NSNumber numberWithBool:_isAllSelect], nil]];
    }
    
    [self.tableView reloadData];
    
}
@end

