/**
 * @file FormSelectTableViewController.h
 * @brief TEPRA-Print SDK Class FormSelectTableViewController definition
 * @par Copyright:
 * (C) 2013-2019 KING JIM CO.,LTD.<BR>
 */

#import <UIKit/UIKit.h>

@protocol FormSelectTableViewControllerDelegate;

@interface FormSelectTableViewController : UITableViewController

@property(weak, nonatomic) id<FormSelectTableViewControllerDelegate> delegate;

@property (nonatomic,strong) NSArray *formDataList;
@property (nonatomic,weak) NSArray *selectForms;

- (IBAction)doneButton:(id)sender;
- (IBAction)allButton:(id)sender;

@end

@protocol FormSelectTableViewControllerDelegate <NSObject>
@optional

- (void)formSelectView:(FormSelectTableViewController *)formSelectView didSelectForm:(NSArray *)formNames;

@end
