/**
 * @file DiscoverTableViewController.m
 * @brief TEPRA-Print SDK DiscoverTableViewController Class
 * @par Copyright:
 * (C) 2013-2019 KING JIM CO.,LTD.<BR>
 */

#import "DiscoverTableViewController.h"

#import "ViewController.h"

@interface DiscoverTableViewController ()
{
    __strong TepraPrintDiscoverPrinter *_discover;
    __strong NSMutableArray *_printers;
}
@end

@implementation DiscoverTableViewController

- (id)initWithStyle:(UITableViewStyle)style
{
    self = [super initWithStyle:style];
    if (self) {
        // Custom initialization
    }
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    if(_printers == nil) {
        _printers = [NSMutableArray array];
    }
    
    if(_discover == nil)
    {
        _discover = [[TepraPrintDiscoverPrinter alloc] initWithModels:nil connectionType:ConnectionTypeAll];
        _discover.delegate = self;
    }
    [_discover startDiscover];

    
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
}

#pragma mark - Table view data source

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 1;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return [_printers count];
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    static NSString *CellIdentifier = @"DiscoverPrinteCell";

    UITableViewCell *cell;
    NSDictionary *printer = [_printers objectAtIndex:indexPath.row];
    cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellIdentifier];
    }
    cell.detailTextLabel.text = [printer objectForKey:TepraPrintPrinterInfoType];
    cell.textLabel.text = printer[TepraPrintPrinterInfoBonjourName];
    
    return cell;
}


#pragma mark - Table view delegate

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    NSDictionary *printerInfo = [_printers objectAtIndex:indexPath.row];
    if ( [self.delegate respondsToSelector:@selector(discoverView:didSelectPrinter:)] ) {
        [self.delegate discoverView:self didSelectPrinter:printerInfo];
    }
    [_discover stopDiscover];
    [self dismissViewControllerAnimated:YES completion:nil];
}

#pragma mark - TepraPrintDiscoverPrinterDelegate

- (void)discoverPrinter:(TepraPrintDiscoverPrinter *)discoverPrinter didFindPrinter:(NSDictionary *)printerInformation;
{    
    [_printers addObject:printerInformation];
    [self.tableView reloadData];
}

// DiscoverPrinter Dlelgate
- (void)discoverPrinter:(TepraPrintDiscoverPrinter *)discoverPrinter didRemovePrinter:(NSDictionary *)printerInformation;
{
    [_printers removeObject:printerInformation];
    [self.tableView reloadData];
}

#pragma mark - done

- (IBAction)doneButton:(id)sender
{
    [_discover stopDiscover];
    [self dismissViewControllerAnimated:YES completion:nil];
}

@end
