/**
 * @file DiscoverTableViewController.h
 * @brief TEPRA-Print SDK DiscoverTableViewController Class definition
 * @par Copyright:
 * (C) 2013-2019 KING JIM CO.,LTD.<BR>
 */

#import <UIKit/UIKit.h>

#import "TepraPrintDiscoverPrinter.h"

@protocol DiscoverTableViewControllerDelegate;

@interface DiscoverTableViewController : UITableViewController  <TepraPrintDiscoverPrinterDelegate>

@property(weak, nonatomic) id<DiscoverTableViewControllerDelegate> delegate;

- (IBAction)doneButton:(id)sender;

@end

@protocol DiscoverTableViewControllerDelegate <NSObject>
@optional

- (void)discoverView:(DiscoverTableViewController *)discoverView didSelectPrinter:(NSDictionary *)printerInfo;

@end
