/**
 * @file AppDelegate.mm
 * @brief TEPRA-Print SDK AppDelegate Class
 * @par Copyright:
 * (C) 2013-2019 KING JIM CO.,LTD.<BR>
 */

#import "AppDelegate.h"
#import "ViewController.h"

@interface AppDelegate ()
{
}

@end


@implementation AppDelegate

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions
{
/*== ADD 2014.08.25 Support Xcode5, 64bit, iOS SDK 7.1 */
    size_t integerSize = sizeof(NSInteger);
    if ( integerSize >= 8 )
    {
        NSLog(@"Running by 64bit.");
    }
    else
    {
        NSLog(@"Running by 32bit.");
    }
/*== ADD End */

    _bgTask = UIBackgroundTaskInvalid;
    
    UNUserNotificationCenter *center = [UNUserNotificationCenter currentNotificationCenter];
    [center requestAuthorizationWithOptions:UNAuthorizationOptionSound | UNAuthorizationOptionAlert completionHandler:^(BOOL granted, NSError * _Nullable error) {
        if (granted) {
            center.delegate = self;
        }
    }];
    
    return YES;
}
							
- (void)applicationWillResignActive:(UIApplication *)application
{
}

- (void)applicationDidEnterBackground:(UIApplication *)application
{
        
    ViewController *viewController = (ViewController *)self.window.rootViewController;
    [viewController saveCurrentData];

    if(viewController.processing == NO) {
        return;
    }
    
    UIApplication*	app = [UIApplication sharedApplication];
	NSAssert(_bgTask == UIBackgroundTaskInvalid, nil);
	
	_bgTask = [app beginBackgroundTaskWithExpirationHandler:^{
		dispatch_async(dispatch_get_main_queue(), ^{
			if (self->_bgTask != UIBackgroundTaskInvalid) {
				[app endBackgroundTask:self->_bgTask];
				self->_bgTask = UIBackgroundTaskInvalid;
			}
		});
	}];
	
	dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
		
		while(viewController.processing == YES && self->_bgTask != UIBackgroundTaskInvalid) {
			[NSThread sleepForTimeInterval:2.];
		}
        
		dispatch_async(dispatch_get_main_queue(), ^{
			if (self->_bgTask != UIBackgroundTaskInvalid) {
				[app endBackgroundTask:self->_bgTask];
				self->_bgTask = UIBackgroundTaskInvalid;
				
			}
		});
	});
}

- (void)applicationWillEnterForeground:(UIApplication *)application
{    
    UIApplication*	app = [UIApplication sharedApplication];
	if (_bgTask != UIBackgroundTaskInvalid) {
		[app endBackgroundTask:_bgTask];
		_bgTask = UIBackgroundTaskInvalid;
	}
}

- (void)applicationDidBecomeActive:(UIApplication *)application
{
}

- (void)applicationWillTerminate:(UIApplication *)application
{
    ViewController *viewController = (ViewController *)self.window.rootViewController;
    [viewController saveCurrentData];
}

-(void) userNotificationCenter:(UNUserNotificationCenter *)center willPresentNotification:(UNNotification *)notification withCompletionHandler:(void (^)(UNNotificationPresentationOptions))completionHandler {
    completionHandler(UNAuthorizationOptionSound | UNAuthorizationOptionAlert);
}

@end
