/*
 * PrintSettingsActivity.java
 *
 * Project: TEPRA-Print SDK
 *
 * Contains: PrintSettingsActivity class
 *
 * (C) 2016-2019 KING JIM CO.,LTD.
 */
package jp.co.kingjim.tepraprint.sdk.demo;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.View.OnKeyListener;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.TextView;
import android.widget.ToggleButton;
import jp.co.kingjim.tepraprint.sdk.TepraPrint;
import jp.co.kingjim.tepraprint.sdk.TepraPrintParameterKey;
import jp.co.kingjim.tepraprint.sdk.TepraPrintPrintSpeed;
import jp.co.kingjim.tepraprint.sdk.TepraPrintTapeCut;

public class PrintSettingsActivity extends Activity implements OnClickListener,
		RadioGroup.OnCheckedChangeListener {

	private EditText _editCopies;
	private RadioGroup _radioTapeCut;
	private ToggleButton _toggleHalfCut;
	private RadioGroup _radioPrintSpeed;
	private EditText _editDensity;
	private TextView _sdkVersion;
	private ToggleButton _togglePriorityPrint;
	private ToggleButton _toggleHalfCutContinuous;

	private int mTapeCutMode = TepraPrintTapeCut.EachLabel;
	private int mPrintSpeed = TepraPrintPrintSpeed.PrintSpeedHigh;

	private int _copies;
	private int _density;

	android.os.Handler handler = new android.os.Handler();

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_print_settings);

		Button buttonDone = (Button) findViewById(R.id.print_settings_ok_button);
		buttonDone.setOnClickListener(this);

		_editCopies = (EditText) findViewById(R.id.copies_edit_text);
		_editCopies.setOnKeyListener(new OnKeyListener() {
			@Override
			public boolean onKey(View v, int keyCode, KeyEvent event) {
				// determine EnterKey are pressed
				if (event.getAction() == KeyEvent.ACTION_DOWN
						&& keyCode == KeyEvent.KEYCODE_ENTER) {
					// close the soft keyboard
					InputMethodManager inputMethodManager = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
					inputMethodManager.hideSoftInputFromWindow(v.getWindowToken(), 0);
					// input check
					if (checkInputCopies() == false) {
						showCopiesAlertDialog("Error", "The range of a copy is to 1 to 99.");
					}
					return true;
				}
				return false;
			}
		});
		_radioTapeCut = (RadioGroup) findViewById(R.id.tape_cut_radio_group);
		_radioTapeCut.setOnCheckedChangeListener(this);
		_toggleHalfCut = (ToggleButton) findViewById(R.id.half_cut_toggle_button);
		_radioPrintSpeed = (RadioGroup) findViewById(R.id.print_speed_radio_group);
		_radioPrintSpeed.setOnCheckedChangeListener(this);
		_editDensity = (EditText) findViewById(R.id.density_edit_text);
		_sdkVersion = (TextView) findViewById(R.id.sdk_version);
		_togglePriorityPrint = (ToggleButton) findViewById(R.id.priority_print_toggle_button);
		_toggleHalfCutContinuous = (ToggleButton) findViewById(R.id.half_cut_continuous_toggle_button);

		_editDensity.setOnKeyListener(new OnKeyListener() {
			@Override
			public boolean onKey(View v, int keyCode, KeyEvent event) {
				// determine EnterKey are pressed
				if (event.getAction() == KeyEvent.ACTION_DOWN
						&& keyCode == KeyEvent.KEYCODE_ENTER) {
					// close the soft keyboard
					InputMethodManager inputMethodManager = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
					inputMethodManager.hideSoftInputFromWindow(v.getWindowToken(), 0);
					// input check
					if (checkInputDensity() == false) {
						showDensityAlertDialog("Error", "The range of a density is to -5 to 5.");
					}
					return true;
				}
				return false;
			}
		});


		getValues();
	}

	private boolean checkInputCopies() {
		boolean result = true;

		// input check
		boolean bError = false;
		try {
			int value = Integer.parseInt(_editCopies.getText().toString());
			if (value < 1 || value >= 100) {
				// error
				bError = true;
			}
		} catch (Exception e) {
			// error
			bError = true;
		}
		if (bError) {
			result = false;
		}

		return result;
	}

	private boolean checkInputDensity() {
		boolean result = true;

		// input check
		boolean bError = false;
		try {
			int value = Integer.parseInt(_editDensity.getText().toString());
			if (value < -5 || value > 5) {
				// error
				bError = true;
			}
		} catch (Exception e) {
			// error
			bError = true;
		}
		if (bError) {
			result = false;
		}

		return result;
	}

	private void showCopiesAlertDialog(final String title, final String message) {
		handler.postDelayed(new Runnable() {
			public void run() {
				AlertDialog.Builder alert = new AlertDialog.Builder(
						PrintSettingsActivity.this);
				alert.setTitle(title);
				alert.setMessage(message);
				alert.setPositiveButton("OK",
						new DialogInterface.OnClickListener() {
							@Override
							public void onClick(DialogInterface dialog,
									int which) {
								_editCopies.setText(String.valueOf(_copies));
							}
						});
				alert.create().show();
			}
		}, 1);
	}

	private void showDensityAlertDialog(final String title, final String message) {
		handler.postDelayed(new Runnable() {
			public void run() {
				AlertDialog.Builder alert = new AlertDialog.Builder(
						PrintSettingsActivity.this);
				alert.setTitle(title);
				alert.setMessage(message);
				alert.setPositiveButton("OK",
						new DialogInterface.OnClickListener() {
							@Override
							public void onClick(DialogInterface dialog,
									int which) {
								_editDensity.setText(String.valueOf(_density));
							}
						});
				alert.create().show();
			}
		}, 1);
	}

	private void getValues() {
		SharedPreferences pref = getSharedPreferences(
				TepraPrintSampleUtils.PREFERENCE_FILE_NAME, MODE_PRIVATE);

		_copies = pref.getInt(TepraPrintParameterKey.Copies,
				TepraPrintSampleUtils.DEFAULT_COPIES_SETTING);

		int tapeCutMode = pref.getInt(TepraPrintParameterKey.TapeCut,
				TepraPrintSampleUtils.DEFAULT_TAPE_CUT_SETTING);
		mTapeCutMode = tapeCutMode;

		boolean halfCutSetting = pref.getBoolean(TepraPrintParameterKey.HalfCut,
				getIntent().getBooleanExtra("SupportHalfcut", false));

		int printSpeed = pref.getInt(TepraPrintParameterKey.PrintSpeed,
				TepraPrintSampleUtils.DEFAULT_PRINT_SPEED_SETTING);
		mPrintSpeed = printSpeed;

		_density = pref.getInt(TepraPrintParameterKey.Density,
				TepraPrintSampleUtils.DEFAULT_DENSITY_SETTING);

		boolean printPriorigySetting = pref.getBoolean(TepraPrintParameterKey.PriorityPrintSetting,
				TepraPrintSampleUtils.DEFAULT_PRINT_PRIORITY_SETTING);

		boolean halfCutContinuous = pref.getBoolean(TepraPrintParameterKey.HalfCutContinuous,
				TepraPrintSampleUtils.DEFAULT_HALF_CUT_COUNINUOUS_SETTING);

		_editCopies.setText(String.valueOf(_copies));
		RadioButton radioTapeCut = null;
		switch (mTapeCutMode) {
			case 0:
				radioTapeCut = (RadioButton) findViewById(R.id.each_radio);
				break;
			case 1:
				radioTapeCut = (RadioButton) findViewById(R.id.after_radio);
				break;
			case 2:
				radioTapeCut = (RadioButton) findViewById(R.id.none_radio);
				break;
			default:
				radioTapeCut = (RadioButton) findViewById(R.id.each_radio);
				break;
		}
		radioTapeCut.setChecked(true);
		_toggleHalfCut.setChecked(halfCutSetting);
		RadioButton radioPrintSpeed = null;
		switch (mPrintSpeed) {
			case TepraPrintPrintSpeed.PrintSpeedHigh:
				radioPrintSpeed = (RadioButton) findViewById(R.id.high_radio);
				break;
			case TepraPrintPrintSpeed.PrintSpeedMiddle:
				radioPrintSpeed = (RadioButton) findViewById(R.id.middle_radio);
				break;
			case TepraPrintPrintSpeed.PrintSpeedLow:
				radioPrintSpeed = (RadioButton) findViewById(R.id.low_radio);
				break;
			default:
				radioPrintSpeed = (RadioButton) findViewById(R.id.high_radio);
				break;
		}
		radioPrintSpeed.setChecked(true);
		_editDensity.setText(String.valueOf(_density));
		_sdkVersion.setText(TepraPrint.getVersion());
		if (getIntent().getBooleanExtra("SupportPriorityPrint", false)) {
			_togglePriorityPrint.setChecked(printPriorigySetting);
		} else {
			_togglePriorityPrint.setChecked(false);
			_togglePriorityPrint.setEnabled(false);
		}
		if (getIntent().getBooleanExtra("SupportHalfCutContinuous", false)) {
			_toggleHalfCutContinuous.setChecked(halfCutContinuous);
		} else {
			_toggleHalfCutContinuous.setChecked(false);
			_toggleHalfCutContinuous.setEnabled(false);
		}
	}

	private void setValues() {
		SharedPreferences pref = getSharedPreferences(
				TepraPrintSampleUtils.PREFERENCE_FILE_NAME, MODE_PRIVATE);
		SharedPreferences.Editor editor = pref.edit();

		int copies = TepraPrintSampleUtils.DEFAULT_COPIES_SETTING;
		try {
			copies = Integer.parseInt(_editCopies.getText().toString());
		} catch (NumberFormatException e) {
		}
		editor.putInt(TepraPrintParameterKey.Copies, copies);
		editor.putInt(TepraPrintParameterKey.TapeCut, mTapeCutMode);
		editor.putBoolean(TepraPrintParameterKey.HalfCut,
				_toggleHalfCut.isChecked());
		editor.putInt(TepraPrintParameterKey.PrintSpeed, mPrintSpeed);
		int density = TepraPrintSampleUtils.DEFAULT_DENSITY_SETTING;
		try {
			density = Integer.parseInt(_editDensity.getText().toString());
		} catch (NumberFormatException e) {
		}
		editor.putInt(TepraPrintParameterKey.Density, density);
		editor.putBoolean(TepraPrintParameterKey.PriorityPrintSetting,
				_togglePriorityPrint.isChecked());
		editor.putBoolean(TepraPrintParameterKey.HalfCutContinuous,
				_toggleHalfCutContinuous.isChecked());

		editor.commit();
	}

	@Override
	public void onClick(View v) {
		if (v.getId() == R.id.print_settings_ok_button) {
			if (checkInputCopies() == false) {
				showCopiesAlertDialog("Error", "The range of a copy is to 1 to 99.");
				return;
			}
			if (checkInputDensity() == false) {
				showDensityAlertDialog("Error", "The range of a density is to -5 to 5.");
				return;
			}

			setValues();
			Intent intent = getIntent();
			int copies = TepraPrintSampleUtils.DEFAULT_COPIES_SETTING;
			try {
				copies = Integer.parseInt(_editCopies.getText().toString());
			} catch (NumberFormatException e) {
			}
			intent.putExtra(TepraPrintParameterKey.Copies, copies);
			intent.putExtra(TepraPrintParameterKey.TapeCut, mTapeCutMode);
			intent.putExtra(TepraPrintParameterKey.HalfCut,
					_toggleHalfCut.isChecked());
			intent.putExtra(TepraPrintParameterKey.PrintSpeed, mPrintSpeed);
			int density = TepraPrintSampleUtils.DEFAULT_DENSITY_SETTING;
			try {
				density = Integer.parseInt(_editDensity.getText().toString());
			} catch (NumberFormatException e) {
			}
			intent.putExtra(TepraPrintParameterKey.Density, density);
			setResult(RESULT_OK, intent);
			intent.putExtra(TepraPrintParameterKey.PriorityPrintSetting,
					_togglePriorityPrint.isChecked());
			intent.putExtra(TepraPrintParameterKey.HalfCutContinuous,
					_toggleHalfCutContinuous.isChecked());
			setResult(RESULT_OK, intent);
			finish();
		}
	}

	@Override
	public void onCheckedChanged(RadioGroup arg0, int arg1) {
		if (arg0 == _radioTapeCut) {
			if (arg1 == R.id.each_radio) {
				mTapeCutMode = TepraPrintTapeCut.EachLabel;
			} else if (arg1 == R.id.after_radio) {
				mTapeCutMode = TepraPrintTapeCut.AfterJob;
			} else if (arg1 == R.id.none_radio) {
				mTapeCutMode = TepraPrintTapeCut.CutNotCut;
			}
		} else if (arg0 == _radioPrintSpeed) {
			if (arg1 == R.id.high_radio) {
				mPrintSpeed = TepraPrintPrintSpeed.PrintSpeedHigh;
			} else if (arg1 == R.id.middle_radio) {
				mPrintSpeed = TepraPrintPrintSpeed.PrintSpeedMiddle;
			} else if (arg1 == R.id.low_radio) {
				mPrintSpeed = TepraPrintPrintSpeed.PrintSpeedLow;
			}
		}
	}

}
