/*
 * PreviewActivity.java
 *
 * Project: TEPRA-Print SDK
 *
 * Contains: PreviewActivity class
 *
 * (C) 2016-2019 KING JIM CO.,LTD.
 */
package jp.co.kingjim.tepraprint.sdk.simpledemo;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;

public class PreviewActivity extends Activity implements View.OnClickListener {

    ImageView mImageView;

    private Button buttonBack;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_preview);

        buttonBack = (Button) findViewById(R.id.button_back);
        buttonBack.setOnClickListener(this);

        mImageView = (ImageView) findViewById(R.id.preview);

        Intent intent = getIntent();
        if (intent != null) {
            Bitmap bitmap = (Bitmap) MainActivity.mBitmap;
            mImageView.setLayerType(View.LAYER_TYPE_SOFTWARE, null);
            mImageView.setImageDrawable(new BitmapDrawable(getResources(), bitmap));
        }
    }


    @Override
    public void onClick(View v) {
        finish();
    }

}
