/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.nsd.util;

public enum DNSRecordClass {
    CLASS_UNKNOWN("?", 0),
    CLASS_IN("in", 1),
    CLASS_CS("cs", 2),
    CLASS_CH("ch", 3),
    CLASS_HS("hs", 4),
    CLASS_NONE("none", 254),
    CLASS_ANY("any", 255);

    public static final int CLASS_MASK = Short.MAX_VALUE;
    public static final int CLASS_UNIQUE = 32768;
    public static final boolean UNIQUE = true;
    public static final boolean NOT_UNIQUE = false;
    private final String externalName;
    private final int index;

    private DNSRecordClass(String name, int index) {
        this.externalName = name;
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isUnique(int index) {
        return this != CLASS_UNKNOWN && (index & 0x8000) != 0;
    }

    public static DNSRecordClass classForIndex(int index) {
        int maskedIndex = index & Short.MAX_VALUE;
        for (DNSRecordClass aClass : DNSRecordClass.values()) {
            if (aClass.index != maskedIndex) continue;
            return aClass;
        }
        return CLASS_UNKNOWN;
    }
}

