/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.nsd.task.state;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import jp.co.kingjim.tepraprint.sdk.nsd.NsdManager;
import jp.co.kingjim.tepraprint.sdk.nsd.NsdServiceInfo;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSOutgoing;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSQuestion;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSRecord;
import jp.co.kingjim.tepraprint.sdk.nsd.task.state.DNSStateTask;
import jp.co.kingjim.tepraprint.sdk.nsd.util.DNSRecordClass;
import jp.co.kingjim.tepraprint.sdk.nsd.util.DNSRecordType;
import jp.co.kingjim.tepraprint.sdk.nsd.util.DNSState;

public class Prober
extends DNSStateTask {
    private static final String TASK_DESCRIPTION = "probing";

    public Prober(NsdManager dns) {
        super(dns, Prober.defaultTTL());
        this.setTaskState(DNSState.PROBING_1);
        this.associate(DNSState.PROBING_1);
    }

    @Override
    public String getName() {
        return "Prober(" + (this.getDns() != null ? this.getDns().getName() : "") + ")";
    }

    @Override
    public void start(Timer timer) {
        long now = System.currentTimeMillis();
        if (now - this.getDns().getLastThrottleIncrement() < 5000L) {
            this.getDns().setThrottle(this.getDns().getThrottle() + 1);
        } else {
            this.getDns().setThrottle(1);
        }
        this.getDns().setLastThrottleIncrement(now);
        if (this.getDns().isAnnounced() && this.getDns().getThrottle() < 10) {
            timer.schedule((TimerTask)this, NsdManager.getRandom().nextInt(251), 250L);
        } else if (!this.getDns().isCanceling() && !this.getDns().isCanceled()) {
            timer.schedule((TimerTask)this, 1000L, 1000L);
        }
    }

    @Override
    public boolean cancel() {
        this.removeAssociation();
        return super.cancel();
    }

    @Override
    public String getTaskDescription() {
        return TASK_DESCRIPTION;
    }

    @Override
    protected boolean checkRunCondition() {
        return !this.getDns().isCanceling() && !this.getDns().isCanceled();
    }

    @Override
    protected DNSOutgoing createOugoing() {
        return new DNSOutgoing(0);
    }

    @Override
    protected DNSOutgoing buildOutgoingForDNS(DNSOutgoing out) throws IOException {
        DNSOutgoing newOut = out;
        newOut.addQuestion(DNSQuestion.newQuestion(this.getDns().getLocalHost().getName(), DNSRecordType.TYPE_ANY, DNSRecordClass.CLASS_IN, false));
        for (DNSRecord answer : this.getDns().getLocalHost().answers(DNSRecordClass.CLASS_ANY, false, this.getTTL())) {
            newOut = this.addAuthoritativeAnswer(newOut, answer);
        }
        return newOut;
    }

    @Override
    protected DNSOutgoing buildOutgoingForInfo(NsdServiceInfo info, DNSOutgoing out) throws IOException {
        DNSOutgoing newOut = out;
        newOut = this.addQuestion(newOut, DNSQuestion.newQuestion(info.getQualifiedName(), DNSRecordType.TYPE_ANY, DNSRecordClass.CLASS_IN, false));
        newOut = this.addAuthoritativeAnswer(newOut, new DNSRecord.Service(info.getQualifiedName(), DNSRecordClass.CLASS_IN, false, this.getTTL(), info.getPriority(), info.getWeight(), info.getPort(), this.getDns().getLocalHost().getName()));
        return newOut;
    }

    @Override
    protected void recoverTask(Throwable e) {
        this.getDns().recover();
    }

    @Override
    protected void advanceTask() {
        this.setTaskState(this.getTaskState().advance());
        if (!this.getTaskState().isProbing()) {
            this.cancel();
            this.getDns().startAnnouncer();
        }
    }
}

