/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.nsd.task.state;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.co.kingjim.tepraprint.sdk.nsd.NsdManager;
import jp.co.kingjim.tepraprint.sdk.nsd.NsdServiceInfo;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSOutgoing;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSStatefulObject;
import jp.co.kingjim.tepraprint.sdk.nsd.task.DNSTask;
import jp.co.kingjim.tepraprint.sdk.nsd.util.DNSState;

public abstract class DNSStateTask
extends DNSTask {
    private final int ttl;
    private static int defaultTTL = 3600;
    private DNSState taskState = null;

    public abstract String getTaskDescription();

    public static int defaultTTL() {
        return defaultTTL;
    }

    public static void setDefaultTTL(int value) {
        defaultTTL = value;
    }

    public DNSStateTask(NsdManager dns, int ttl) {
        super(dns);
        this.ttl = ttl;
    }

    public int getTTL() {
        return this.ttl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void associate(DNSState state) {
        NsdManager nsdManager = this.getDns();
        synchronized (nsdManager) {
            this.getDns().associateWithTask(this, state);
        }
        for (NsdServiceInfo serviceInfo : this.getDns().getServices().values()) {
            serviceInfo.associateWithTask(this, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAssociation() {
        NsdManager nsdManager = this.getDns();
        synchronized (nsdManager) {
            this.getDns().removeAssociationWithTask(this);
        }
        for (NsdServiceInfo serviceInfo : this.getDns().getServices().values()) {
            serviceInfo.removeAssociationWithTask(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DNSOutgoing out = this.createOugoing();
        try {
            if (!this.checkRunCondition()) {
                this.cancel();
                return;
            }
            ArrayList<DNSStatefulObject> stateObjects = new ArrayList<DNSStatefulObject>();
            Object object = this.getDns();
            synchronized (object) {
                if (this.getDns().isAssociatedWithTask(this, this.getTaskState())) {
                    stateObjects.add(this.getDns());
                    out = this.buildOutgoingForDNS(out);
                }
            }
            object = this.getDns().getServices().values().iterator();
            while (object.hasNext()) {
                NsdServiceInfo serviceInfo;
                NsdServiceInfo info;
                NsdServiceInfo nsdServiceInfo = info = (serviceInfo = (NsdServiceInfo)object.next());
                synchronized (nsdServiceInfo) {
                    if (info.isAssociatedWithTask(this, this.getTaskState())) {
                        stateObjects.add(info);
                        out = this.buildOutgoingForInfo(info, out);
                    }
                }
            }
            if (out.isEmpty()) {
                this.advanceObjectsState(stateObjects);
                this.cancel();
                return;
            }
            this.getDns().send(out);
            this.advanceObjectsState(stateObjects);
        }
        catch (Throwable e) {
            this.recoverTask(e);
        }
        this.advanceTask();
    }

    protected abstract boolean checkRunCondition();

    protected abstract DNSOutgoing buildOutgoingForDNS(DNSOutgoing var1) throws IOException;

    protected abstract DNSOutgoing buildOutgoingForInfo(NsdServiceInfo var1, DNSOutgoing var2) throws IOException;

    protected abstract DNSOutgoing createOugoing();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void advanceObjectsState(List<DNSStatefulObject> list) {
        if (list != null) {
            Iterator<DNSStatefulObject> iterator = list.iterator();
            while (iterator.hasNext()) {
                DNSStatefulObject object;
                DNSStatefulObject dNSStatefulObject = object = iterator.next();
                synchronized (dNSStatefulObject) {
                    object.advanceState(this);
                }
            }
        }
    }

    protected abstract void recoverTask(Throwable var1);

    protected abstract void advanceTask();

    protected DNSState getTaskState() {
        return this.taskState;
    }

    protected void setTaskState(DNSState taskState) {
        this.taskState = taskState;
    }
}

