/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.nsd.task.resolver;

import java.io.IOException;
import jp.co.kingjim.tepraprint.sdk.nsd.NsdManager;
import jp.co.kingjim.tepraprint.sdk.nsd.NsdServiceInfo;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSEntry;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSOutgoing;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSQuestion;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSRecord;
import jp.co.kingjim.tepraprint.sdk.nsd.task.resolver.DNSResolverTask;
import jp.co.kingjim.tepraprint.sdk.nsd.util.DNSRecordClass;
import jp.co.kingjim.tepraprint.sdk.nsd.util.DNSRecordType;

public class ServiceInfoResolver
extends DNSResolverTask {
    private final NsdServiceInfo info;

    public ServiceInfoResolver(NsdManager dns, NsdServiceInfo info) {
        super(dns);
        this.info = info;
        info.setDns(this.getDns());
        this.getDns().addListener(info, DNSQuestion.newQuestion(info.getQualifiedName(), DNSRecordType.TYPE_ANY, DNSRecordClass.CLASS_IN, false));
    }

    @Override
    public String getName() {
        return "ServiceInfoResolver(" + (this.getDns() != null ? this.getDns().getName() : "") + ")";
    }

    @Override
    public boolean cancel() {
        boolean result = super.cancel();
        if (!this.info.isPersistent()) {
            this.getDns().removeListener(this.info);
        }
        return result;
    }

    @Override
    protected DNSOutgoing addAnswers(DNSOutgoing out) throws IOException {
        DNSOutgoing newOut = out;
        if (!this.info.hasData()) {
            long now = System.currentTimeMillis();
            newOut = this.addAnswer(newOut, (DNSRecord)this.getDns().getCache().getDNSEntry(this.info.getQualifiedName(), DNSRecordType.TYPE_SRV, DNSRecordClass.CLASS_IN), now);
            newOut = this.addAnswer(newOut, (DNSRecord)this.getDns().getCache().getDNSEntry(this.info.getQualifiedName(), DNSRecordType.TYPE_TXT, DNSRecordClass.CLASS_IN), now);
            if (this.info.getServer().length() > 0) {
                for (DNSEntry dNSEntry : this.getDns().getCache().getDNSEntryList(this.info.getServer(), DNSRecordType.TYPE_A, DNSRecordClass.CLASS_IN)) {
                    newOut = this.addAnswer(newOut, (DNSRecord)dNSEntry, now);
                }
                for (DNSEntry dNSEntry : this.getDns().getCache().getDNSEntryList(this.info.getServer(), DNSRecordType.TYPE_AAAA, DNSRecordClass.CLASS_IN)) {
                    newOut = this.addAnswer(newOut, (DNSRecord)dNSEntry, now);
                }
            }
        }
        return newOut;
    }

    @Override
    protected DNSOutgoing addQuestions(DNSOutgoing out) throws IOException {
        DNSOutgoing newOut = out;
        if (!this.info.hasData()) {
            newOut = this.addQuestion(newOut, DNSQuestion.newQuestion(this.info.getQualifiedName(), DNSRecordType.TYPE_SRV, DNSRecordClass.CLASS_IN, false));
            newOut = this.addQuestion(newOut, DNSQuestion.newQuestion(this.info.getQualifiedName(), DNSRecordType.TYPE_TXT, DNSRecordClass.CLASS_IN, false));
            if (this.info.getServer().length() > 0) {
                newOut = this.addQuestion(newOut, DNSQuestion.newQuestion(this.info.getServer(), DNSRecordType.TYPE_A, DNSRecordClass.CLASS_IN, false));
                newOut = this.addQuestion(newOut, DNSQuestion.newQuestion(this.info.getServer(), DNSRecordType.TYPE_AAAA, DNSRecordClass.CLASS_IN, false));
            }
        }
        return newOut;
    }
}

