/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.nsd.task.resolver;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import jp.co.kingjim.tepraprint.sdk.nsd.NsdManager;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSOutgoing;
import jp.co.kingjim.tepraprint.sdk.nsd.task.DNSTask;

public abstract class DNSResolverTask
extends DNSTask {
    private static int MAX_COUNT = 3;
    protected int count = 0;

    public DNSResolverTask(NsdManager dns) {
        super(dns);
    }

    @Override
    public void start(Timer timer) {
        if (!this.getDns().isCanceling() && !this.getDns().isCanceled()) {
            timer.schedule((TimerTask)this, 225L, 225L);
        }
    }

    @Override
    public void run() {
        try {
            if (this.getDns().isCanceling() || this.getDns().isCanceled()) {
                this.cancel();
            } else if (this.count++ < MAX_COUNT) {
                DNSOutgoing out = new DNSOutgoing(0);
                out = this.addQuestions(out);
                if (this.getDns().isAnnounced()) {
                    out = this.addAnswers(out);
                }
                if (!out.isEmpty()) {
                    this.getDns().send(out);
                }
            } else {
                this.cancel();
            }
        }
        catch (Throwable e) {
            this.getDns().recover();
        }
    }

    protected abstract DNSOutgoing addQuestions(DNSOutgoing var1) throws IOException;

    protected abstract DNSOutgoing addAnswers(DNSOutgoing var1) throws IOException;
}

