/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.nsd.task;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import jp.co.kingjim.tepraprint.sdk.nsd.NsdManager;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSIncoming;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSOutgoing;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSQuestion;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSRecord;
import jp.co.kingjim.tepraprint.sdk.nsd.task.DNSTask;
import jp.co.kingjim.tepraprint.sdk.nsd.util.DNSConstants;

public class Responder
extends DNSTask {
    private final DNSIncoming in;
    private final boolean unicast;

    public Responder(NsdManager dns, DNSIncoming in, int port) {
        super(dns);
        this.in = in;
        this.unicast = port != DNSConstants.MDNS_PORT;
    }

    @Override
    public String getName() {
        return "Responder(" + (this.getDns() != null ? this.getDns().getName() : "") + ")";
    }

    @Override
    public void start(Timer timer) {
        int delay;
        DNSQuestion question;
        boolean iAmTheOnlyOne = true;
        Iterator<? extends DNSQuestion> iterator = this.in.getQuestions().iterator();
        while (iterator.hasNext() && (iAmTheOnlyOne = (question = iterator.next()).iAmTheOnlyOne(this.getDns()))) {
        }
        int n = delay = iAmTheOnlyOne && !this.in.isTruncated() ? 0 : 20 + NsdManager.getRandom().nextInt(96) - this.in.elapseSinceArrival();
        if (delay < 0) {
            delay = 0;
        }
        if (!this.getDns().isCanceling() && !this.getDns().isCanceled()) {
            timer.schedule((TimerTask)this, delay);
        }
    }

    @Override
    public void run() {
        this.getDns().respondToQuery(this.in);
        HashSet<DNSQuestion> questions = new HashSet<DNSQuestion>();
        HashSet<DNSRecord> answers = new HashSet<DNSRecord>();
        if (this.getDns().isAnnounced()) {
            try {
                for (DNSQuestion dNSQuestion : this.in.getQuestions()) {
                    if (this.unicast) {
                        questions.add(dNSQuestion);
                    }
                    dNSQuestion.addAnswers(this.getDns(), answers);
                }
                long now = System.currentTimeMillis();
                for (DNSRecord dNSRecord : this.in.getAnswers()) {
                    if (!dNSRecord.isStale(now)) continue;
                    answers.remove(dNSRecord);
                }
                if (!answers.isEmpty()) {
                    DNSOutgoing out = new DNSOutgoing(33792, !this.unicast, this.in.getSenderUDPPayload());
                    out.setId(this.in.getId());
                    for (DNSQuestion question : questions) {
                        if (question == null) continue;
                        out = this.addQuestion(out, question);
                    }
                    for (DNSRecord answer : answers) {
                        if (answer == null) continue;
                        out = this.addAnswer(out, this.in, answer);
                    }
                    if (!out.isEmpty()) {
                        this.getDns().send(out);
                    }
                }
            }
            catch (Throwable e) {
                this.getDns().close();
            }
        }
    }
}

