/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.nsd.task;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import jp.co.kingjim.tepraprint.sdk.nsd.NsdManager;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSIncoming;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSOutgoing;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSQuestion;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSRecord;

public abstract class DNSTask
extends TimerTask {
    private final NsdManager dns;

    protected DNSTask(NsdManager dns) {
        this.dns = dns;
    }

    public NsdManager getDns() {
        return this.dns;
    }

    public abstract void start(Timer var1);

    public abstract String getName();

    public DNSOutgoing addQuestion(DNSOutgoing out, DNSQuestion rec) throws IOException {
        DNSOutgoing newOut = out;
        try {
            newOut.addQuestion(rec);
        }
        catch (IOException e) {
            int flags = newOut.getFlags();
            boolean multicast = newOut.isMulticast();
            int maxUDPPayload = newOut.getMaxUDPPayload();
            int id = newOut.getId();
            newOut.setFlags(flags | 0x200);
            newOut.setId(id);
            this.dns.send(newOut);
            newOut = new DNSOutgoing(flags, multicast, maxUDPPayload);
            newOut.addQuestion(rec);
        }
        return newOut;
    }

    public DNSOutgoing addAnswer(DNSOutgoing out, DNSIncoming in, DNSRecord rec) throws IOException {
        DNSOutgoing newOut = out;
        try {
            newOut.addAnswer(in, rec);
        }
        catch (IOException e) {
            int flags = newOut.getFlags();
            boolean multicast = newOut.isMulticast();
            int maxUDPPayload = newOut.getMaxUDPPayload();
            int id = newOut.getId();
            newOut.setFlags(flags | 0x200);
            newOut.setId(id);
            this.dns.send(newOut);
            newOut = new DNSOutgoing(flags, multicast, maxUDPPayload);
            newOut.addAnswer(in, rec);
        }
        return newOut;
    }

    public DNSOutgoing addAnswer(DNSOutgoing out, DNSRecord rec, long now) throws IOException {
        DNSOutgoing newOut = out;
        try {
            newOut.addAnswer(rec, now);
        }
        catch (IOException e) {
            int flags = newOut.getFlags();
            boolean multicast = newOut.isMulticast();
            int maxUDPPayload = newOut.getMaxUDPPayload();
            int id = newOut.getId();
            newOut.setFlags(flags | 0x200);
            newOut.setId(id);
            this.dns.send(newOut);
            newOut = new DNSOutgoing(flags, multicast, maxUDPPayload);
            newOut.addAnswer(rec, now);
        }
        return newOut;
    }

    public DNSOutgoing addAuthoritativeAnswer(DNSOutgoing out, DNSRecord rec) throws IOException {
        DNSOutgoing newOut = out;
        try {
            newOut.addAuthorativeAnswer(rec);
        }
        catch (IOException e) {
            int flags = newOut.getFlags();
            boolean multicast = newOut.isMulticast();
            int maxUDPPayload = newOut.getMaxUDPPayload();
            int id = newOut.getId();
            newOut.setFlags(flags | 0x200);
            newOut.setId(id);
            this.dns.send(newOut);
            newOut = new DNSOutgoing(flags, multicast, maxUDPPayload);
            newOut.addAuthorativeAnswer(rec);
        }
        return newOut;
    }

    public DNSOutgoing addAdditionalAnswer(DNSOutgoing out, DNSIncoming in, DNSRecord rec) throws IOException {
        DNSOutgoing newOut = out;
        try {
            newOut.addAdditionalAnswer(in, rec);
        }
        catch (IOException e) {
            int flags = newOut.getFlags();
            boolean multicast = newOut.isMulticast();
            int maxUDPPayload = newOut.getMaxUDPPayload();
            int id = newOut.getId();
            newOut.setFlags(flags | 0x200);
            newOut.setId(id);
            this.dns.send(newOut);
            newOut = new DNSOutgoing(flags, multicast, maxUDPPayload);
            newOut.addAdditionalAnswer(in, rec);
        }
        return newOut;
    }
}

