/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.nsd.service;

import java.io.IOException;
import java.net.DatagramPacket;
import jp.co.kingjim.tepraprint.sdk.nsd.NsdManager;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSIncoming;
import jp.co.kingjim.tepraprint.sdk.nsd.util.DNSConstants;

public class SocketListener
extends Thread {
    private final NsdManager dns;

    public SocketListener(NsdManager dns) {
        super("SocketListener(" + (dns != null ? dns.getName() : "") + ")");
        this.setDaemon(true);
        this.dns = dns;
    }

    @Override
    public void run() {
        block8: {
            try {
                byte[] buf = new byte[8972];
                DatagramPacket packet = new DatagramPacket(buf, buf.length);
                while (!this.dns.isCanceling() && !this.dns.isCanceled()) {
                    packet.setLength(buf.length);
                    this.dns.getSocket().receive(packet);
                    if (!(this.dns.isCanceling() || this.dns.isCanceled() || this.dns.isClosing() || this.dns.isClosed())) {
                        try {
                            DNSIncoming msg;
                            if (this.dns.getLocalHost().shouldIgnorePacket(packet) || !(msg = new DNSIncoming(packet)).isValidResponseCode()) continue;
                            if (msg.isQuery()) {
                                if (packet.getPort() != DNSConstants.MDNS_PORT) {
                                    this.dns.handleQuery(msg, packet.getAddress(), packet.getPort());
                                }
                                this.dns.handleQuery(msg, this.dns.getGroup(), DNSConstants.MDNS_PORT);
                                continue;
                            }
                            this.dns.handleResponse(msg);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                if (this.dns.isCanceling() || this.dns.isCanceled() || this.dns.isClosing() || this.dns.isClosed()) break block8;
                e.printStackTrace();
                this.dns.recover();
            }
        }
    }
}

