/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.nsd.service;

import java.util.EventListener;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jp.co.kingjim.tepraprint.sdk.nsd.NsdServiceInfo;
import jp.co.kingjim.tepraprint.sdk.nsd.service.ServiceEvent;
import jp.co.kingjim.tepraprint.sdk.nsd.service.ServiceListener;

public class ListenerStatus<T extends EventListener> {
    public static final boolean SYNCHONEOUS = true;
    public static final boolean ASYNCHONEOUS = false;
    private final T listener;
    private final boolean synch;

    public ListenerStatus(T listener, boolean synch) {
        this.listener = listener;
        this.synch = synch;
    }

    public T getListener() {
        return this.listener;
    }

    public boolean isSynchronous() {
        return this.synch;
    }

    public int hashCode() {
        return this.getListener().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ListenerStatus && this.getListener().equals(((ListenerStatus)obj).getListener());
    }

    public static class ServiceListenerStatus
    extends ListenerStatus<ServiceListener> {
        private final ConcurrentMap<String, NsdServiceInfo> addedServices = new ConcurrentHashMap<String, NsdServiceInfo>(32);

        public ServiceListenerStatus(ServiceListener listener, boolean synch) {
            super(listener, synch);
        }

        public void serviceAdded(ServiceEvent event) {
            String qualifiedName = event.getName() + "." + event.getType();
            if (null == this.addedServices.putIfAbsent(qualifiedName, event.getInfo().clone())) {
                ((ServiceListener)this.getListener()).serviceAdded(event);
                NsdServiceInfo info = event.getInfo();
                if (info != null && info.hasData()) {
                    ((ServiceListener)this.getListener()).serviceResolved(event);
                }
            }
        }

        public void serviceRemoved(ServiceEvent event) {
            String qualifiedName = event.getName() + "." + event.getType();
            if (this.addedServices.remove(qualifiedName, this.addedServices.get(qualifiedName))) {
                ((ServiceListener)this.getListener()).serviceRemoved(event);
            }
        }

        public synchronized void serviceResolved(ServiceEvent event) {
            String qualifiedName;
            NsdServiceInfo previousServiceInfo;
            NsdServiceInfo info = event.getInfo();
            if (info != null && info.hasData() && !ServiceListenerStatus.isSameInfo(info, previousServiceInfo = (NsdServiceInfo)this.addedServices.get(qualifiedName = event.getName() + "." + event.getType()))) {
                if (null == previousServiceInfo) {
                    if (null == this.addedServices.putIfAbsent(qualifiedName, info.clone())) {
                        ((ServiceListener)this.getListener()).serviceResolved(event);
                    }
                } else if (this.addedServices.replace(qualifiedName, previousServiceInfo, info.clone())) {
                    ((ServiceListener)this.getListener()).serviceResolved(event);
                }
            }
        }

        private static final boolean isSameInfo(NsdServiceInfo info, NsdServiceInfo lastInfo) {
            byte[] lastText;
            if (info == null) {
                return false;
            }
            if (lastInfo == null) {
                return false;
            }
            if (!info.equals(lastInfo)) {
                return false;
            }
            byte[] text = info.getTextBytes();
            if (text.length != (lastText = lastInfo.getTextBytes()).length) {
                return false;
            }
            for (int i = 0; i < text.length; ++i) {
                if (text[i] == lastText[i]) continue;
                return false;
            }
            return true;
        }
    }
}

