/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.nsd.service;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import jp.co.kingjim.tepraprint.sdk.nsd.NsdManager;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSRecord;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSStatefulObject;
import jp.co.kingjim.tepraprint.sdk.nsd.service.NameRegister;
import jp.co.kingjim.tepraprint.sdk.nsd.task.DNSTask;
import jp.co.kingjim.tepraprint.sdk.nsd.util.DNSRecordClass;
import jp.co.kingjim.tepraprint.sdk.nsd.util.DNSRecordType;
import jp.co.kingjim.tepraprint.sdk.nsd.util.DNSState;

public class HostInfo
implements DNSStatefulObject {
    protected String name;
    protected InetAddress address;
    protected NetworkInterface networkInterface;
    private final HostInfoState hostInfoState;

    public static HostInfo newHostInfo(InetAddress address, NsdManager dns, String name) {
        HostInfo localhost = null;
        String aName = name != null ? name : "";
        InetAddress addr = address;
        try {
            if (addr == null) {
                String ip = System.getProperty("net.mdns.interface");
                if (ip != null) {
                    addr = InetAddress.getByName(ip);
                } else {
                    InetAddress[] addresses;
                    addr = InetAddress.getLocalHost();
                    if (addr.isLoopbackAddress() && (addresses = HostInfo.getInetAddresses()).length > 0) {
                        addr = addresses[0];
                    }
                }
            }
            if (aName.length() == 0) {
                aName = addr.getHostAddress();
            }
            if (aName.contains("in-addr.arpa") || aName.equals(addr.getHostAddress())) {
                aName = name != null && name.length() > 0 ? name : addr.getHostAddress();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            addr = HostInfo.loopbackAddress();
            aName = name != null && name.length() > 0 ? name : "computer";
        }
        int index = aName.indexOf(".local");
        if (index > 0) {
            aName = aName.substring(0, index);
        }
        aName = aName.replace('.', '-');
        aName = aName + ".local.";
        localhost = new HostInfo(addr, aName, dns);
        return localhost;
    }

    private static InetAddress[] getInetAddresses() {
        HashSet<InetAddress> result = new HashSet<InetAddress>();
        try {
            Enumeration<NetworkInterface> nifs = NetworkInterface.getNetworkInterfaces();
            while (nifs.hasMoreElements()) {
                NetworkInterface nif = nifs.nextElement();
                Enumeration<InetAddress> iaenum = nif.getInetAddresses();
                while (iaenum.hasMoreElements()) {
                    InetAddress interfaceAddress = iaenum.nextElement();
                    if (!HostInfo.useInetAddress(nif, interfaceAddress)) continue;
                    result.add(interfaceAddress);
                }
            }
        }
        catch (SocketException se) {
            se.printStackTrace();
        }
        return result.toArray(new InetAddress[result.size()]);
    }

    private static boolean useInetAddress(NetworkInterface networkInterface, InetAddress interfaceAddress) {
        Method supportsMulticast;
        Method isUp;
        try {
            isUp = NetworkInterface.class.getMethod("isUp", null);
        }
        catch (Exception e) {
            isUp = null;
        }
        Method _isUp = isUp;
        try {
            supportsMulticast = NetworkInterface.class.getMethod("supportsMulticast", null);
        }
        catch (Exception e) {
            supportsMulticast = null;
        }
        Method _supportsMulticast = supportsMulticast;
        try {
            if (_isUp != null) {
                try {
                    if (!((Boolean)_isUp.invoke((Object)networkInterface, (Object[])null)).booleanValue()) {
                        return false;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (_supportsMulticast != null) {
                try {
                    if (!((Boolean)_supportsMulticast.invoke((Object)networkInterface, (Object[])null)).booleanValue()) {
                        return false;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static InetAddress loopbackAddress() {
        try {
            return InetAddress.getByName(null);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    private HostInfo(InetAddress address, String name, NsdManager dns) {
        this.hostInfoState = new HostInfoState(dns);
        this.address = address;
        this.name = name;
        if (address != null) {
            try {
                this.networkInterface = NetworkInterface.getByInetAddress(address);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public InetAddress getInetAddress() {
        return this.address;
    }

    public Inet4Address getInet4Address() {
        if (this.getInetAddress() instanceof Inet4Address) {
            return (Inet4Address)this.address;
        }
        return null;
    }

    public Inet6Address getInet6Address() {
        if (this.getInetAddress() instanceof Inet6Address) {
            return (Inet6Address)this.address;
        }
        return null;
    }

    public NetworkInterface getNetworkInterface() {
        return this.networkInterface;
    }

    public boolean conflictWithRecord(DNSRecord.Address record) {
        DNSRecord.Address hostAddress = this.getDNSAddressRecord(record.getRecordType(), record.isUnique(), 3600);
        if (hostAddress != null) {
            return hostAddress.sameType(record) && hostAddress.sameName(record) && !hostAddress.sameValue(record);
        }
        return false;
    }

    public synchronized String incrementHostName() {
        this.name = NameRegister.Factory.getRegistry().incrementName(this.getInetAddress(), this.name, NameRegister.NameType.HOST);
        return this.name;
    }

    public boolean shouldIgnorePacket(DatagramPacket packet) {
        InetAddress from;
        boolean result = false;
        if (this.getInetAddress() != null && (from = packet.getAddress()) != null) {
            if ((this.getInetAddress().isLinkLocalAddress() || this.getInetAddress().isMCLinkLocal()) && !from.isLinkLocalAddress()) {
                result = true;
            }
            if (from.isLoopbackAddress() && !this.getInetAddress().isLoopbackAddress()) {
                result = true;
            }
        }
        return result;
    }

    public DNSRecord.Address getDNSAddressRecord(DNSRecordType type, boolean unique, int ttl) {
        switch (type) {
            case TYPE_A: {
                return this.getDNS4AddressRecord(unique, ttl);
            }
            case TYPE_A6: 
            case TYPE_AAAA: {
                return this.getDNS6AddressRecord(unique, ttl);
            }
        }
        return null;
    }

    private DNSRecord.Address getDNS4AddressRecord(boolean unique, int ttl) {
        if (this.getInetAddress() instanceof Inet4Address) {
            return new DNSRecord.IPv4Address(this.getName(), DNSRecordClass.CLASS_IN, unique, ttl, this.getInetAddress());
        }
        return null;
    }

    private DNSRecord.Address getDNS6AddressRecord(boolean unique, int ttl) {
        if (this.getInetAddress() instanceof Inet6Address) {
            return new DNSRecord.IPv6Address(this.getName(), DNSRecordClass.CLASS_IN, unique, ttl, this.getInetAddress());
        }
        return null;
    }

    public DNSRecord.Pointer getDNSReverseAddressRecord(DNSRecordType type, boolean unique, int ttl) {
        switch (type) {
            case TYPE_A: {
                return this.getDNS4ReverseAddressRecord(unique, ttl);
            }
            case TYPE_A6: 
            case TYPE_AAAA: {
                return this.getDNS6ReverseAddressRecord(unique, ttl);
            }
        }
        return null;
    }

    private DNSRecord.Pointer getDNS4ReverseAddressRecord(boolean unique, int ttl) {
        if (this.getInetAddress() instanceof Inet4Address) {
            return new DNSRecord.Pointer(this.getInetAddress().getHostAddress() + ".in-addr.arpa.", DNSRecordClass.CLASS_IN, unique, ttl, this.getName());
        }
        return null;
    }

    private DNSRecord.Pointer getDNS6ReverseAddressRecord(boolean unique, int ttl) {
        if (this.getInetAddress() instanceof Inet6Address) {
            return new DNSRecord.Pointer(this.getInetAddress().getHostAddress() + ".ip6.arpa.", DNSRecordClass.CLASS_IN, unique, ttl, this.getName());
        }
        return null;
    }

    public Collection<DNSRecord> answers(DNSRecordClass recordClass, boolean unique, int ttl) {
        ArrayList<DNSRecord> list = new ArrayList<DNSRecord>();
        DNSRecord.Address answer = this.getDNS4AddressRecord(unique, ttl);
        if (answer != null && answer.matchRecordClass(recordClass)) {
            list.add(answer);
        }
        if ((answer = this.getDNS6AddressRecord(unique, ttl)) != null && answer.matchRecordClass(recordClass)) {
            list.add(answer);
        }
        return list;
    }

    @Override
    public NsdManager getDns() {
        return this.hostInfoState.getDns();
    }

    @Override
    public boolean advanceState(DNSTask task) {
        return this.hostInfoState.advanceState(task);
    }

    @Override
    public void removeAssociationWithTask(DNSTask task) {
        this.hostInfoState.removeAssociationWithTask(task);
    }

    @Override
    public boolean revertState() {
        return this.hostInfoState.revertState();
    }

    @Override
    public void associateWithTask(DNSTask task, DNSState state) {
        this.hostInfoState.associateWithTask(task, state);
    }

    @Override
    public boolean isAssociatedWithTask(DNSTask task, DNSState state) {
        return this.hostInfoState.isAssociatedWithTask(task, state);
    }

    @Override
    public boolean cancelState() {
        return this.hostInfoState.cancelState();
    }

    @Override
    public boolean closeState() {
        return this.hostInfoState.closeState();
    }

    @Override
    public boolean recoverState() {
        return this.hostInfoState.recoverState();
    }

    @Override
    public boolean isProbing() {
        return this.hostInfoState.isProbing();
    }

    @Override
    public boolean isAnnouncing() {
        return this.hostInfoState.isAnnouncing();
    }

    @Override
    public boolean isAnnounced() {
        return this.hostInfoState.isAnnounced();
    }

    @Override
    public boolean isCanceling() {
        return this.hostInfoState.isCanceling();
    }

    @Override
    public boolean isCanceled() {
        return this.hostInfoState.isCanceled();
    }

    @Override
    public boolean isClosing() {
        return this.hostInfoState.isClosing();
    }

    @Override
    public boolean isClosed() {
        return this.hostInfoState.isClosed();
    }

    @Override
    public boolean waitForAnnounced(long timeout) {
        return this.hostInfoState.waitForAnnounced(timeout);
    }

    @Override
    public boolean waitForCanceled(long timeout) {
        if (this.address == null) {
            return true;
        }
        return this.hostInfoState.waitForCanceled(timeout);
    }

    private static final class HostInfoState
    extends DNSStatefulObject.DefaultImplementation {
        private static final long serialVersionUID = 1L;

        public HostInfoState(NsdManager dns) {
            this.setDns(dns);
        }
    }
}

