/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.nsd.dns;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import jp.co.kingjim.tepraprint.sdk.nsd.NsdManager;
import jp.co.kingjim.tepraprint.sdk.nsd.NsdServiceInfo;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSIncoming;
import jp.co.kingjim.tepraprint.sdk.nsd.task.RecordReaper;
import jp.co.kingjim.tepraprint.sdk.nsd.task.Responder;
import jp.co.kingjim.tepraprint.sdk.nsd.task.resolver.ServiceInfoResolver;
import jp.co.kingjim.tepraprint.sdk.nsd.task.resolver.ServiceResolver;
import jp.co.kingjim.tepraprint.sdk.nsd.task.state.Announcer;
import jp.co.kingjim.tepraprint.sdk.nsd.task.state.Canceler;
import jp.co.kingjim.tepraprint.sdk.nsd.task.state.Prober;

public interface DNSTaskStarter {
    public void purgeTimer();

    public void purgeStateTimer();

    public void cancelTimer();

    public void cancelStateTimer();

    public void startProber();

    public void startAnnouncer();

    public void startCanceler();

    public void startReaper();

    public void startServiceInfoResolver(NsdServiceInfo var1);

    public void startServiceResolver(String var1);

    public void startResponder(DNSIncoming var1, int var2);

    public static final class DNSTaskStarterImpl
    implements DNSTaskStarter {
        private final NsdManager dns;
        private final Timer timer;
        private final Timer stateTimer;

        public DNSTaskStarterImpl(NsdManager dns) {
            this.dns = dns;
            this.timer = new StarterTimer("NsdManager(" + this.dns.getName() + ").Timer", true);
            this.stateTimer = new StarterTimer("NsdManager(" + this.dns.getName() + ").State.Timer", true);
        }

        @Override
        public void purgeTimer() {
            this.timer.purge();
        }

        @Override
        public void purgeStateTimer() {
            this.stateTimer.purge();
        }

        @Override
        public void cancelTimer() {
            this.timer.cancel();
        }

        @Override
        public void cancelStateTimer() {
            this.stateTimer.cancel();
        }

        @Override
        public void startProber() {
            new Prober(this.dns).start(this.stateTimer);
        }

        @Override
        public void startAnnouncer() {
            new Announcer(this.dns).start(this.stateTimer);
        }

        @Override
        public void startCanceler() {
            new Canceler(this.dns).start(this.stateTimer);
        }

        @Override
        public void startReaper() {
            new RecordReaper(this.dns).start(this.timer);
        }

        @Override
        public void startServiceInfoResolver(NsdServiceInfo info) {
            new ServiceInfoResolver(this.dns, info).start(this.timer);
        }

        @Override
        public void startServiceResolver(String type) {
            new ServiceResolver(this.dns, type).start(this.timer);
        }

        @Override
        public void startResponder(DNSIncoming in, int port) {
            new Responder(this.dns, in, port).start(this.timer);
        }

        public static class StarterTimer
        extends Timer {
            private volatile boolean cancelled = false;

            public StarterTimer() {
            }

            public StarterTimer(boolean isDaemon) {
                super(isDaemon);
            }

            public StarterTimer(String name, boolean isDaemon) {
                super(name, isDaemon);
            }

            public StarterTimer(String name) {
                super(name);
            }

            @Override
            public synchronized void cancel() {
                if (this.cancelled) {
                    return;
                }
                this.cancelled = true;
                super.cancel();
            }

            @Override
            public synchronized void schedule(TimerTask task, long delay) {
                if (this.cancelled) {
                    return;
                }
                super.schedule(task, delay);
            }

            @Override
            public synchronized void schedule(TimerTask task, Date time) {
                if (this.cancelled) {
                    return;
                }
                super.schedule(task, time);
            }

            @Override
            public synchronized void schedule(TimerTask task, long delay, long period) {
                if (this.cancelled) {
                    return;
                }
                super.schedule(task, delay, period);
            }

            @Override
            public synchronized void schedule(TimerTask task, Date firstTime, long period) {
                if (this.cancelled) {
                    return;
                }
                super.schedule(task, firstTime, period);
            }

            @Override
            public synchronized void scheduleAtFixedRate(TimerTask task, long delay, long period) {
                if (this.cancelled) {
                    return;
                }
                super.scheduleAtFixedRate(task, delay, period);
            }

            @Override
            public synchronized void scheduleAtFixedRate(TimerTask task, Date firstTime, long period) {
                if (this.cancelled) {
                    return;
                }
                super.scheduleAtFixedRate(task, firstTime, period);
            }
        }
    }

    public static final class Factory {
        private static volatile Factory instance;
        private final ConcurrentMap<NsdManager, DNSTaskStarter> instances = new ConcurrentHashMap<NsdManager, DNSTaskStarter>(20);
        private static final AtomicReference<ClassDelegate> databaseClassDelegate;

        private Factory() {
        }

        protected static DNSTaskStarter newDNSTaskStarter(NsdManager dns) {
            DNSTaskStarter instance = null;
            ClassDelegate delegate = databaseClassDelegate.get();
            if (delegate != null) {
                instance = delegate.newDNSTaskStarter(dns);
            }
            return instance != null ? instance : new DNSTaskStarterImpl(dns);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static Factory getInstance() {
            if (instance != null) return instance;
            Class<Factory> clazz = Factory.class;
            synchronized (Factory.class) {
                if (instance != null) return instance;
                instance = new Factory();
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        public DNSTaskStarter getStarter(NsdManager dns) {
            DNSTaskStarter starter = (DNSTaskStarter)this.instances.get(dns);
            if (starter == null) {
                this.instances.putIfAbsent(dns, Factory.newDNSTaskStarter(dns));
                starter = (DNSTaskStarter)this.instances.get(dns);
            }
            return starter;
        }

        public void disposeStarter(NsdManager dns) {
            this.instances.remove(dns);
        }

        static {
            databaseClassDelegate = new AtomicReference();
        }

        public static interface ClassDelegate {
            public DNSTaskStarter newDNSTaskStarter(NsdManager var1);
        }
    }
}

