/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.nsd.dns;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import jp.co.kingjim.tepraprint.sdk.nsd.NsdManager;
import jp.co.kingjim.tepraprint.sdk.nsd.task.DNSTask;
import jp.co.kingjim.tepraprint.sdk.nsd.util.DNSState;

public interface DNSStatefulObject {
    public NsdManager getDns();

    public void associateWithTask(DNSTask var1, DNSState var2);

    public void removeAssociationWithTask(DNSTask var1);

    public boolean isAssociatedWithTask(DNSTask var1, DNSState var2);

    public boolean advanceState(DNSTask var1);

    public boolean revertState();

    public boolean cancelState();

    public boolean closeState();

    public boolean recoverState();

    public boolean isProbing();

    public boolean isAnnouncing();

    public boolean isAnnounced();

    public boolean isCanceling();

    public boolean isCanceled();

    public boolean isClosing();

    public boolean isClosed();

    public boolean waitForAnnounced(long var1);

    public boolean waitForCanceled(long var1);

    public static class DefaultImplementation
    extends ReentrantLock
    implements DNSStatefulObject {
        private static final long serialVersionUID = 1L;
        private volatile NsdManager dns = null;
        protected volatile DNSTask task = null;
        protected volatile DNSState state = DNSState.PROBING_1;
        private final DNSStatefulObjectSemaphore announcing = new DNSStatefulObjectSemaphore("Announce");
        private final DNSStatefulObjectSemaphore canceling = new DNSStatefulObjectSemaphore("Cancel");

        @Override
        public NsdManager getDns() {
            return this.dns;
        }

        protected void setDns(NsdManager dns) {
            this.dns = dns;
        }

        @Override
        public void associateWithTask(DNSTask task, DNSState state) {
            if (this.task == null && this.state == state) {
                this.lock();
                try {
                    if (this.task == null && this.state == state) {
                        this.setTask(task);
                    }
                }
                finally {
                    this.unlock();
                }
            }
        }

        @Override
        public void removeAssociationWithTask(DNSTask task) {
            if (this.task == task) {
                this.lock();
                try {
                    if (this.task == task) {
                        this.setTask(null);
                    }
                }
                finally {
                    this.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isAssociatedWithTask(DNSTask task, DNSState state) {
            this.lock();
            try {
                boolean bl = this.task == task && this.state == state;
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        protected void setTask(DNSTask task) {
            this.task = task;
        }

        protected void setState(DNSState state) {
            this.lock();
            try {
                this.state = state;
                if (this.isAnnounced()) {
                    this.announcing.signalEvent();
                }
                if (this.isCanceled()) {
                    this.canceling.signalEvent();
                    this.announcing.signalEvent();
                }
            }
            finally {
                this.unlock();
            }
        }

        @Override
        public boolean advanceState(DNSTask task) {
            boolean result = true;
            if (this.task == task) {
                this.lock();
                try {
                    if (this.task == task) {
                        this.setState(this.state.advance());
                    }
                }
                finally {
                    this.unlock();
                }
            }
            return result;
        }

        @Override
        public boolean revertState() {
            boolean result = true;
            if (!this.willCancel()) {
                this.lock();
                try {
                    if (!this.willCancel()) {
                        this.setState(this.state.revert());
                        this.setTask(null);
                    }
                }
                finally {
                    this.unlock();
                }
            }
            return result;
        }

        @Override
        public boolean cancelState() {
            boolean result = false;
            if (!this.willCancel()) {
                this.lock();
                try {
                    if (!this.willCancel()) {
                        this.setState(DNSState.CANCELING_1);
                        this.setTask(null);
                        result = true;
                    }
                }
                finally {
                    this.unlock();
                }
            }
            return result;
        }

        @Override
        public boolean closeState() {
            boolean result = false;
            if (!this.willClose()) {
                this.lock();
                try {
                    if (!this.willClose()) {
                        this.setState(DNSState.CLOSING);
                        this.setTask(null);
                        result = true;
                    }
                }
                finally {
                    this.unlock();
                }
            }
            return result;
        }

        @Override
        public boolean recoverState() {
            boolean result = false;
            this.lock();
            try {
                this.setState(DNSState.PROBING_1);
                this.setTask(null);
            }
            finally {
                this.unlock();
            }
            return result;
        }

        @Override
        public boolean isProbing() {
            return this.state.isProbing();
        }

        @Override
        public boolean isAnnouncing() {
            return this.state.isAnnouncing();
        }

        @Override
        public boolean isAnnounced() {
            return this.state.isAnnounced();
        }

        @Override
        public boolean isCanceling() {
            return this.state.isCanceling();
        }

        @Override
        public boolean isCanceled() {
            return this.state.isCanceled();
        }

        @Override
        public boolean isClosing() {
            return this.state.isClosing();
        }

        @Override
        public boolean isClosed() {
            return this.state.isClosed();
        }

        private boolean willCancel() {
            return this.state.isCanceled() || this.state.isCanceling();
        }

        private boolean willClose() {
            return this.state.isClosed() || this.state.isClosing();
        }

        @Override
        public boolean waitForAnnounced(long timeout) {
            if (!this.isAnnounced() && !this.willCancel()) {
                this.announcing.waitForEvent(timeout + 10L);
            }
            if (!this.isAnnounced()) {
                this.announcing.waitForEvent(10L);
            }
            return this.isAnnounced();
        }

        @Override
        public boolean waitForCanceled(long timeout) {
            if (!this.isCanceled()) {
                this.canceling.waitForEvent(timeout);
            }
            if (!this.isCanceled()) {
                this.canceling.waitForEvent(10L);
            }
            return this.isCanceled();
        }
    }

    public static final class DNSStatefulObjectSemaphore {
        private final String name;
        private final ConcurrentMap<Thread, Semaphore> semaphores;

        public DNSStatefulObjectSemaphore(String name) {
            this.name = name;
            this.semaphores = new ConcurrentHashMap<Thread, Semaphore>(50);
        }

        public void waitForEvent(long timeout) {
            Thread thread = Thread.currentThread();
            Semaphore semaphore = (Semaphore)this.semaphores.get(thread);
            if (semaphore == null) {
                semaphore = new Semaphore(1, true);
                semaphore.drainPermits();
                this.semaphores.putIfAbsent(thread, semaphore);
            }
            semaphore = (Semaphore)this.semaphores.get(thread);
            try {
                semaphore.tryAcquire(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public void signalEvent() {
            Collection semaphores = this.semaphores.values();
            for (Semaphore semaphore : semaphores) {
                semaphore.release();
                semaphores.remove(semaphore);
            }
        }
    }
}

