/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.nsd.dns;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jp.co.kingjim.tepraprint.sdk.nsd.NsdManager;
import jp.co.kingjim.tepraprint.sdk.nsd.NsdServiceInfo;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSEntry;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSIncoming;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSOutgoing;
import jp.co.kingjim.tepraprint.sdk.nsd.service.NameRegister;
import jp.co.kingjim.tepraprint.sdk.nsd.service.ServiceEvent;
import jp.co.kingjim.tepraprint.sdk.nsd.util.DNSRecordClass;
import jp.co.kingjim.tepraprint.sdk.nsd.util.DNSRecordType;

public abstract class DNSRecord
extends DNSEntry {
    private int ttl;
    private long created;
    private InetAddress source;
    public static final byte[] EMPTY_TXT = new byte[]{0};

    DNSRecord(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique, int ttl) {
        super(name, type, recordClass, unique);
        this.ttl = ttl;
        this.created = System.currentTimeMillis();
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof DNSRecord && super.equals(other) && this.sameValue((DNSRecord)other);
    }

    public abstract boolean sameValue(DNSRecord var1);

    public boolean sameType(DNSRecord other) {
        return this.getRecordType() == other.getRecordType();
    }

    public abstract boolean handleQuery(NsdManager var1, long var2);

    public abstract boolean handleResponse(NsdManager var1);

    abstract DNSOutgoing addAnswer(NsdManager var1, DNSIncoming var2, InetAddress var3, int var4, DNSOutgoing var5) throws IOException;

    boolean suppressedBy(DNSIncoming msg) {
        try {
            for (DNSRecord dNSRecord : msg.getAllAnswers()) {
                if (!this.suppressedBy(dNSRecord)) continue;
                return true;
            }
            return false;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            return false;
        }
    }

    boolean suppressedBy(DNSRecord other) {
        return this.equals(other) && other.ttl > this.ttl / 2;
    }

    long getExpirationTime(int percent) {
        return this.created + (long)(percent * this.ttl) * 10L;
    }

    int getRemainingTTL(long now) {
        return (int)Math.max(0L, (this.getExpirationTime(100) - now) / 1000L);
    }

    @Override
    public boolean isExpired(long now) {
        return this.getExpirationTime(100) <= now;
    }

    @Override
    public boolean isStale(long now) {
        return this.getExpirationTime(50) <= now;
    }

    public void resetTTL(DNSRecord other) {
        this.created = other.created;
        this.ttl = other.ttl;
    }

    public void setWillExpireSoon(long now) {
        this.created = now;
        this.ttl = 1;
    }

    abstract void write(DNSOutgoing.MessageOutputStream var1);

    public abstract boolean isSingleValued();

    public NsdServiceInfo getServiceInfo() {
        return this.getServiceInfo(false);
    }

    public abstract NsdServiceInfo getServiceInfo(boolean var1);

    public abstract ServiceEvent getServiceEvent(NsdManager var1);

    public void setRecordSource(InetAddress source) {
        this.source = source;
    }

    public InetAddress getRecordSource() {
        return this.source;
    }

    public void setTTL(int ttl) {
        this.ttl = ttl;
    }

    public int getTTL() {
        return this.ttl;
    }

    public static class HostInformation
    extends DNSRecord {
        String os;
        String cpu;

        public HostInformation(String name, DNSRecordClass recordClass, boolean unique, int ttl, String cpu, String os) {
            super(name, DNSRecordType.TYPE_HINFO, recordClass, unique, ttl);
            this.cpu = cpu;
            this.os = os;
        }

        @Override
        DNSOutgoing addAnswer(NsdManager dns, DNSIncoming in, InetAddress addr, int port, DNSOutgoing out) throws IOException {
            return out;
        }

        @Override
        public boolean handleQuery(NsdManager dns, long expirationTime) {
            return false;
        }

        @Override
        public boolean handleResponse(NsdManager dns) {
            return false;
        }

        @Override
        public boolean sameValue(DNSRecord other) {
            if (!(other instanceof HostInformation)) {
                return false;
            }
            HostInformation hinfo = (HostInformation)other;
            if (this.cpu == null && hinfo.cpu != null) {
                return false;
            }
            if (this.os == null && hinfo.os != null) {
                return false;
            }
            return this.cpu.equals(hinfo.cpu) && this.os.equals(hinfo.os);
        }

        @Override
        public boolean isSingleValued() {
            return true;
        }

        @Override
        void write(DNSOutgoing.MessageOutputStream out) {
            String hostInfo = this.cpu + " " + this.os;
            out.writeUTF(hostInfo, 0, hostInfo.length());
        }

        @Override
        public NsdServiceInfo getServiceInfo(boolean persistent) {
            HashMap<String, String> hinfo = new HashMap<String, String>(2);
            hinfo.put("cpu", this.cpu);
            hinfo.put("os", this.os);
            return new NsdServiceInfo(this.getQualifiedNameMap(), 0, 0, 0, persistent, hinfo);
        }

        @Override
        public ServiceEvent getServiceEvent(NsdManager dns) {
            NsdServiceInfo info = this.getServiceInfo(false);
            info.setDns(dns);
            return new ServiceEvent(dns, info.getType(), info.getName(), info);
        }
    }

    public static class Service
    extends DNSRecord {
        private final int priority;
        private final int weight;
        private final int port;
        private final String server;

        public Service(String name, DNSRecordClass recordClass, boolean unique, int ttl, int priority, int weight, int port, String server) {
            super(name, DNSRecordType.TYPE_SRV, recordClass, unique, ttl);
            this.priority = priority;
            this.weight = weight;
            this.port = port;
            this.server = server;
        }

        @Override
        void write(DNSOutgoing.MessageOutputStream out) {
            out.writeShort(this.priority);
            out.writeShort(this.weight);
            out.writeShort(this.port);
            if (DNSIncoming.USE_DOMAIN_NAME_FORMAT_FOR_SRV_TARGET) {
                out.writeName(this.server);
            } else {
                out.writeUTF(this.server, 0, this.server.length());
                out.writeByte(0);
            }
        }

        @Override
        protected void toByteArray(DataOutputStream dout) throws IOException {
            super.toByteArray(dout);
            dout.writeShort(this.priority);
            dout.writeShort(this.weight);
            dout.writeShort(this.port);
            try {
                dout.write(this.server.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }

        public String getServer() {
            return this.server;
        }

        public int getPriority() {
            return this.priority;
        }

        public int getWeight() {
            return this.weight;
        }

        public int getPort() {
            return this.port;
        }

        @Override
        public boolean sameValue(DNSRecord other) {
            if (!(other instanceof Service)) {
                return false;
            }
            Service s = (Service)other;
            return this.priority == s.priority && this.weight == s.weight && this.port == s.port && this.server.equals(s.server);
        }

        @Override
        public boolean isSingleValued() {
            return true;
        }

        @Override
        public boolean handleQuery(NsdManager dns, long expirationTime) {
            NsdServiceInfo info = dns.getServices().get(this.getKey());
            if (!(info == null || !info.isAnnouncing() && !info.isAnnounced() || this.port == info.getPort() && this.server.equalsIgnoreCase(dns.getLocalHost().getName()))) {
                Service localService = new Service(info.getQualifiedName(), DNSRecordClass.CLASS_IN, true, 3600, info.getPriority(), info.getWeight(), info.getPort(), dns.getLocalHost().getName());
                int comparison = this.compareTo(localService);
                if (comparison == 0) {
                    return false;
                }
                if (!info.isProbing() || comparison <= 0) {
                    return false;
                }
                String oldName = info.getQualifiedName().toLowerCase();
                info.setName(NameRegister.Factory.getRegistry().incrementName(dns.getLocalHost().getInetAddress(), info.getName(), NameRegister.NameType.SERVICE));
                dns.getServices().remove(oldName);
                dns.getServices().put(info.getQualifiedName().toLowerCase(), info);
                info.revertState();
                return true;
            }
            return false;
        }

        @Override
        public boolean handleResponse(NsdManager dns) {
            NsdServiceInfo info = dns.getServices().get(this.getKey());
            if (!(info == null || this.port == info.getPort() && this.server.equalsIgnoreCase(dns.getLocalHost().getName()))) {
                if (info.isProbing()) {
                    String oldName = info.getQualifiedName().toLowerCase();
                    info.setName(NameRegister.Factory.getRegistry().incrementName(dns.getLocalHost().getInetAddress(), info.getName(), NameRegister.NameType.SERVICE));
                    dns.getServices().remove(oldName);
                    dns.getServices().put(info.getQualifiedName().toLowerCase(), info);
                }
                info.revertState();
                return true;
            }
            return false;
        }

        @Override
        DNSOutgoing addAnswer(NsdManager dns, DNSIncoming in, InetAddress addr, int port, DNSOutgoing out) throws IOException {
            NsdServiceInfo info = dns.getServices().get(this.getKey());
            if (info != null && port == info.getPort() != this.server.equals(dns.getLocalHost().getName())) {
                return dns.addAnswer(in, addr, port, out, new Service(info.getQualifiedName(), DNSRecordClass.CLASS_IN, true, 3600, info.getPriority(), info.getWeight(), info.getPort(), dns.getLocalHost().getName()));
            }
            return out;
        }

        @Override
        public NsdServiceInfo getServiceInfo(boolean persistent) {
            return new NsdServiceInfo(this.getQualifiedNameMap(), this.port, this.weight, this.priority, persistent, (byte[])null);
        }

        @Override
        public ServiceEvent getServiceEvent(NsdManager dns) {
            NsdServiceInfo info = this.getServiceInfo(false);
            info.setDns(dns);
            return new ServiceEvent(dns, info.getType(), info.getName(), info);
        }
    }

    public static class Text
    extends DNSRecord {
        private final byte[] text;

        public Text(String name, DNSRecordClass recordClass, boolean unique, int ttl, byte[] text) {
            super(name, DNSRecordType.TYPE_TXT, recordClass, unique, ttl);
            this.text = text != null && text.length > 0 ? text : EMPTY_TXT;
        }

        public byte[] getText() {
            return this.text;
        }

        @Override
        void write(DNSOutgoing.MessageOutputStream out) {
            out.writeBytes(this.text, 0, this.text.length);
        }

        @Override
        public boolean sameValue(DNSRecord other) {
            if (!(other instanceof Text)) {
                return false;
            }
            Text txt = (Text)other;
            if (this.text == null && txt.text != null) {
                return false;
            }
            if (txt.text.length != this.text.length) {
                return false;
            }
            int i = this.text.length;
            while (i-- > 0) {
                if (txt.text[i] == this.text[i]) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isSingleValued() {
            return true;
        }

        @Override
        public boolean handleQuery(NsdManager dns, long expirationTime) {
            return false;
        }

        @Override
        public boolean handleResponse(NsdManager dns) {
            return false;
        }

        @Override
        DNSOutgoing addAnswer(NsdManager dns, DNSIncoming in, InetAddress addr, int port, DNSOutgoing out) throws IOException {
            return out;
        }

        @Override
        public NsdServiceInfo getServiceInfo(boolean persistent) {
            return new NsdServiceInfo(this.getQualifiedNameMap(), 0, 0, 0, persistent, this.text);
        }

        @Override
        public ServiceEvent getServiceEvent(NsdManager dns) {
            NsdServiceInfo info = this.getServiceInfo(false);
            info.setDns(dns);
            return new ServiceEvent(dns, info.getType(), info.getName(), info);
        }
    }

    public static class Pointer
    extends DNSRecord {
        private final String alias;

        public Pointer(String name, DNSRecordClass recordClass, boolean unique, int ttl, String alias) {
            super(name, DNSRecordType.TYPE_PTR, recordClass, unique, ttl);
            this.alias = alias;
        }

        @Override
        public boolean isSameEntry(DNSEntry entry) {
            return super.isSameEntry(entry) && entry instanceof Pointer && this.sameValue((Pointer)entry);
        }

        @Override
        void write(DNSOutgoing.MessageOutputStream out) {
            out.writeName(this.alias);
        }

        @Override
        public boolean sameValue(DNSRecord other) {
            if (!(other instanceof Pointer)) {
                return false;
            }
            Pointer pointer = (Pointer)other;
            if (this.alias == null && pointer.alias != null) {
                return false;
            }
            return this.alias.equals(pointer.alias);
        }

        @Override
        public boolean isSingleValued() {
            return false;
        }

        @Override
        public boolean handleQuery(NsdManager dns, long expirationTime) {
            return false;
        }

        @Override
        public boolean handleResponse(NsdManager dns) {
            return false;
        }

        public String getAlias() {
            return this.alias;
        }

        @Override
        DNSOutgoing addAnswer(NsdManager dns, DNSIncoming in, InetAddress addr, int port, DNSOutgoing out) throws IOException {
            return out;
        }

        @Override
        public NsdServiceInfo getServiceInfo(boolean persistent) {
            if (this.isServicesDiscoveryMetaQuery()) {
                Map<NsdServiceInfo.Fields, String> map = NsdServiceInfo.decodeQualifiedNameMapForType(this.getAlias());
                return new NsdServiceInfo(map, 0, 0, 0, persistent, (byte[])null);
            }
            if (this.isReverseLookup()) {
                return new NsdServiceInfo(this.getQualifiedNameMap(), 0, 0, 0, persistent, (byte[])null);
            }
            if (this.isDomainDiscoveryQuery()) {
                return new NsdServiceInfo(this.getQualifiedNameMap(), 0, 0, 0, persistent, (byte[])null);
            }
            Map<NsdServiceInfo.Fields, String> map = NsdServiceInfo.decodeQualifiedNameMapForType(this.getAlias());
            map.put(NsdServiceInfo.Fields.Subtype, this.getQualifiedNameMap().get((Object)NsdServiceInfo.Fields.Subtype));
            return new NsdServiceInfo(map, 0, 0, 0, persistent, this.getAlias());
        }

        @Override
        public ServiceEvent getServiceEvent(NsdManager dns) {
            NsdServiceInfo info = this.getServiceInfo(false);
            info.setDns(dns);
            String domainName = info.getType();
            String serviceName = NsdManager.toUnqualifiedName(domainName, this.getAlias());
            return new ServiceEvent(dns, domainName, serviceName, info);
        }
    }

    public static abstract class Address
    extends DNSRecord {
        InetAddress addr;

        protected Address(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique, int ttl, InetAddress addr) {
            super(name, type, recordClass, unique, ttl);
            this.addr = addr;
        }

        protected Address(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique, int ttl, byte[] rawAddress) {
            super(name, type, recordClass, unique, ttl);
            try {
                this.addr = InetAddress.getByAddress(rawAddress);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }

        boolean same(DNSRecord other) {
            if (!(other instanceof Address)) {
                return false;
            }
            return this.sameName(other) && this.sameValue(other);
        }

        public boolean sameName(DNSRecord other) {
            return this.getName().equalsIgnoreCase(other.getName());
        }

        @Override
        public boolean sameValue(DNSRecord other) {
            if (!(other instanceof Address)) {
                return false;
            }
            Address address = (Address)other;
            if (this.getAddress() == null && address.getAddress() != null) {
                return false;
            }
            return this.getAddress().equals(address.getAddress());
        }

        @Override
        public boolean isSingleValued() {
            return false;
        }

        public InetAddress getAddress() {
            return this.addr;
        }

        @Override
        protected void toByteArray(DataOutputStream dout) throws IOException {
            super.toByteArray(dout);
            byte[] buffer = this.getAddress().getAddress();
            for (int i = 0; i < buffer.length; ++i) {
                dout.writeByte(buffer[i]);
            }
        }

        @Override
        public boolean handleQuery(NsdManager dns, long expirationTime) {
            Address localAddress;
            if (dns.getLocalHost().conflictWithRecord(this) && (localAddress = dns.getLocalHost().getDNSAddressRecord(this.getRecordType(), this.isUnique(), 3600)) != null) {
                int comparison = this.compareTo(localAddress);
                if (comparison == 0) {
                    return false;
                }
                if (dns.isProbing() && comparison > 0) {
                    dns.getLocalHost().incrementHostName();
                    dns.getCache().clear();
                    Iterator<NsdServiceInfo> iterator = dns.getServices().values().iterator();
                    while (iterator.hasNext()) {
                        NsdServiceInfo serviceInfo;
                        NsdServiceInfo info = serviceInfo = iterator.next();
                        info.revertState();
                    }
                }
                dns.revertState();
                return true;
            }
            return false;
        }

        @Override
        public boolean handleResponse(NsdManager dns) {
            if (dns.getLocalHost().conflictWithRecord(this)) {
                if (dns.isProbing()) {
                    dns.getLocalHost().incrementHostName();
                    dns.getCache().clear();
                    Iterator<NsdServiceInfo> iterator = dns.getServices().values().iterator();
                    while (iterator.hasNext()) {
                        NsdServiceInfo serviceInfo;
                        NsdServiceInfo info = serviceInfo = iterator.next();
                        info.revertState();
                    }
                }
                dns.revertState();
                return true;
            }
            return false;
        }

        @Override
        DNSOutgoing addAnswer(NsdManager dns, DNSIncoming in, InetAddress addr, int port, DNSOutgoing out) throws IOException {
            return out;
        }

        @Override
        public NsdServiceInfo getServiceInfo(boolean persistent) {
            NsdServiceInfo info = new NsdServiceInfo(this.getQualifiedNameMap(), 0, 0, 0, persistent, (byte[])null);
            return info;
        }

        @Override
        public ServiceEvent getServiceEvent(NsdManager dns) {
            NsdServiceInfo info = this.getServiceInfo(false);
            info.setDns(dns);
            return new ServiceEvent(dns, info.getType(), info.getName(), info);
        }
    }

    public static class IPv6Address
    extends Address {
        public IPv6Address(String name, DNSRecordClass recordClass, boolean unique, int ttl, InetAddress addr) {
            super(name, DNSRecordType.TYPE_AAAA, recordClass, unique, ttl, addr);
        }

        public IPv6Address(String name, DNSRecordClass recordClass, boolean unique, int ttl, byte[] rawAddress) {
            super(name, DNSRecordType.TYPE_AAAA, recordClass, unique, ttl, rawAddress);
        }

        @Override
        void write(DNSOutgoing.MessageOutputStream out) {
            if (this.addr != null) {
                byte[] buffer = this.addr.getAddress();
                if (this.addr instanceof Inet4Address) {
                    byte[] tempbuffer = buffer;
                    buffer = new byte[16];
                    for (int i = 0; i < 16; ++i) {
                        buffer[i] = i < 11 ? tempbuffer[i - 12] : (byte)0;
                    }
                }
                int length = buffer.length;
                out.writeBytes(buffer, 0, length);
            }
        }

        @Override
        public NsdServiceInfo getServiceInfo(boolean persistent) {
            NsdServiceInfo info = super.getServiceInfo(persistent);
            info.addAddress((Inet6Address)this.addr);
            return info;
        }
    }

    public static class IPv4Address
    extends Address {
        public IPv4Address(String name, DNSRecordClass recordClass, boolean unique, int ttl, InetAddress addr) {
            super(name, DNSRecordType.TYPE_A, recordClass, unique, ttl, addr);
        }

        public IPv4Address(String name, DNSRecordClass recordClass, boolean unique, int ttl, byte[] rawAddress) {
            super(name, DNSRecordType.TYPE_A, recordClass, unique, ttl, rawAddress);
        }

        @Override
        void write(DNSOutgoing.MessageOutputStream out) {
            if (this.addr != null) {
                byte[] buffer = this.addr.getAddress();
                if (!(this.addr instanceof Inet4Address)) {
                    byte[] tempbuffer = buffer;
                    buffer = new byte[4];
                    System.arraycopy(tempbuffer, 12, buffer, 0, 4);
                }
                int length = buffer.length;
                out.writeBytes(buffer, 0, length);
            }
        }

        @Override
        public NsdServiceInfo getServiceInfo(boolean persistent) {
            NsdServiceInfo info = super.getServiceInfo(persistent);
            info.addAddress((Inet4Address)this.addr);
            return info;
        }
    }
}

