/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.nsd.dns;

import java.net.InetAddress;
import java.util.Set;
import jp.co.kingjim.tepraprint.sdk.nsd.NsdManager;
import jp.co.kingjim.tepraprint.sdk.nsd.NsdServiceInfo;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSEntry;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSRecord;
import jp.co.kingjim.tepraprint.sdk.nsd.util.DNSRecordClass;
import jp.co.kingjim.tepraprint.sdk.nsd.util.DNSRecordType;

public class DNSQuestion
extends DNSEntry {
    DNSQuestion(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique) {
        super(name, type, recordClass, unique);
    }

    public static DNSQuestion newQuestion(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique) {
        switch (type) {
            case TYPE_A: {
                return new DNS4Address(name, type, recordClass, unique);
            }
            case TYPE_A6: {
                return new DNS6Address(name, type, recordClass, unique);
            }
            case TYPE_AAAA: {
                return new DNS6Address(name, type, recordClass, unique);
            }
            case TYPE_ANY: {
                return new AllRecords(name, type, recordClass, unique);
            }
            case TYPE_HINFO: {
                return new HostInformation(name, type, recordClass, unique);
            }
            case TYPE_PTR: {
                return new Pointer(name, type, recordClass, unique);
            }
            case TYPE_SRV: {
                return new Service(name, type, recordClass, unique);
            }
            case TYPE_TXT: {
                return new Text(name, type, recordClass, unique);
            }
        }
        return new DNSQuestion(name, type, recordClass, unique);
    }

    public boolean answeredBy(DNSEntry rec) {
        return this.isSameRecordClass(rec) && this.isSameType(rec) && this.getName().equals(rec.getName());
    }

    public void addAnswers(NsdManager dns, Set<DNSRecord> answers) {
    }

    protected void addAnswersForServiceInfo(NsdManager dns, Set<DNSRecord> answers, NsdServiceInfo info) {
        if (info != null && info.isAnnounced() && (this.getName().equalsIgnoreCase(info.getQualifiedName()) || this.getName().equalsIgnoreCase(info.getType()) || this.getName().equalsIgnoreCase(info.getTypeWithSubtype()))) {
            answers.addAll(dns.getLocalHost().answers(this.getRecordClass(), true, 3600));
            answers.addAll(info.answers(this.getRecordClass(), true, 3600, dns.getLocalHost()));
        }
    }

    @Override
    public boolean isStale(long now) {
        return false;
    }

    @Override
    public boolean isExpired(long now) {
        return false;
    }

    public boolean iAmTheOnlyOne(NsdManager dns) {
        return false;
    }

    private static class DNS4Address
    extends DNSQuestion {
        DNS4Address(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique) {
            super(name, type, recordClass, unique);
        }

        @Override
        public void addAnswers(NsdManager dns, Set<DNSRecord> answers) {
            DNSRecord.Address answer = dns.getLocalHost().getDNSAddressRecord(this.getRecordType(), true, 3600);
            if (answer != null) {
                answers.add(answer);
            }
        }

        @Override
        public boolean iAmTheOnlyOne(NsdManager dns) {
            String name = this.getName().toLowerCase();
            return dns.getLocalHost().getName().equals(name) || dns.getServices().keySet().contains(name);
        }
    }

    private static class DNS6Address
    extends DNSQuestion {
        DNS6Address(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique) {
            super(name, type, recordClass, unique);
        }

        @Override
        public void addAnswers(NsdManager dns, Set<DNSRecord> answers) {
            DNSRecord.Address answer = dns.getLocalHost().getDNSAddressRecord(this.getRecordType(), true, 3600);
            if (answer != null) {
                answers.add(answer);
            }
        }

        @Override
        public boolean iAmTheOnlyOne(NsdManager dns) {
            String name = this.getName().toLowerCase();
            return dns.getLocalHost().getName().equals(name) || dns.getServices().keySet().contains(name);
        }
    }

    private static class AllRecords
    extends DNSQuestion {
        AllRecords(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique) {
            super(name, type, recordClass, unique);
        }

        @Override
        public boolean isSameType(DNSEntry entry) {
            return entry != null;
        }

        @Override
        public void addAnswers(NsdManager dns, Set<DNSRecord> answers) {
            String loname = this.getName().toLowerCase();
            if (dns.getLocalHost().getName().equalsIgnoreCase(loname)) {
                answers.addAll(dns.getLocalHost().answers(this.getRecordClass(), this.isUnique(), 3600));
                return;
            }
            if (dns.getServiceTypes().containsKey(loname)) {
                Pointer question = new Pointer(this.getName(), DNSRecordType.TYPE_PTR, this.getRecordClass(), this.isUnique());
                ((DNSQuestion)question).addAnswers(dns, answers);
                return;
            }
            this.addAnswersForServiceInfo(dns, answers, dns.getServices().get(loname));
        }

        @Override
        public boolean iAmTheOnlyOne(NsdManager dns) {
            String name = this.getName().toLowerCase();
            return dns.getLocalHost().getName().equals(name) || dns.getServices().keySet().contains(name);
        }
    }

    private static class HostInformation
    extends DNSQuestion {
        HostInformation(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique) {
            super(name, type, recordClass, unique);
        }
    }

    private static class Pointer
    extends DNSQuestion {
        Pointer(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique) {
            super(name, type, recordClass, unique);
        }

        @Override
        public void addAnswers(NsdManager dns, Set<DNSRecord> answers) {
            for (NsdServiceInfo serviceInfo : dns.getServices().values()) {
                this.addAnswersForServiceInfo(dns, answers, serviceInfo);
            }
            if (this.isServicesDiscoveryMetaQuery()) {
                for (String serviceType : dns.getServiceTypes().keySet()) {
                    NsdManager.ServiceTypeEntry typeEntry = dns.getServiceTypes().get(serviceType);
                    answers.add(new DNSRecord.Pointer("_services._dns-sd._udp.local.", DNSRecordClass.CLASS_IN, false, 3600, typeEntry.getType()));
                }
            } else if (this.isReverseLookup()) {
                String ipValue = this.getQualifiedNameMap().get((Object)NsdServiceInfo.Fields.Instance);
                if (ipValue != null && ipValue.length() > 0) {
                    String hostIPAddress;
                    InetAddress address = dns.getLocalHost().getInetAddress();
                    String string = hostIPAddress = address != null ? address.getHostAddress() : "";
                    if (ipValue.equalsIgnoreCase(hostIPAddress)) {
                        if (this.isV4ReverseLookup()) {
                            answers.add(dns.getLocalHost().getDNSReverseAddressRecord(DNSRecordType.TYPE_A, false, 3600));
                        }
                        if (this.isV6ReverseLookup()) {
                            answers.add(dns.getLocalHost().getDNSReverseAddressRecord(DNSRecordType.TYPE_AAAA, false, 3600));
                        }
                    }
                }
            } else if (this.isDomainDiscoveryQuery()) {
                // empty if block
            }
        }
    }

    private static class Service
    extends DNSQuestion {
        Service(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique) {
            super(name, type, recordClass, unique);
        }

        @Override
        public void addAnswers(NsdManager dns, Set<DNSRecord> answers) {
            String loname = this.getName().toLowerCase();
            if (dns.getLocalHost().getName().equalsIgnoreCase(loname)) {
                answers.addAll(dns.getLocalHost().answers(this.getRecordClass(), this.isUnique(), 3600));
                return;
            }
            if (dns.getServiceTypes().containsKey(loname)) {
                Pointer question = new Pointer(this.getName(), DNSRecordType.TYPE_PTR, this.getRecordClass(), this.isUnique());
                ((DNSQuestion)question).addAnswers(dns, answers);
                return;
            }
            this.addAnswersForServiceInfo(dns, answers, dns.getServices().get(loname));
        }

        @Override
        public boolean iAmTheOnlyOne(NsdManager dns) {
            String name = this.getName().toLowerCase();
            return dns.getLocalHost().getName().equals(name) || dns.getServices().keySet().contains(name);
        }
    }

    private static class Text
    extends DNSQuestion {
        Text(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique) {
            super(name, type, recordClass, unique);
        }

        @Override
        public void addAnswers(NsdManager dns, Set<DNSRecord> answers) {
            this.addAnswersForServiceInfo(dns, answers, dns.getServices().get(this.getName().toLowerCase()));
        }

        @Override
        public boolean iAmTheOnlyOne(NsdManager dns) {
            String name = this.getName().toLowerCase();
            return dns.getLocalHost().getName().equals(name) || dns.getServices().keySet().contains(name);
        }
    }
}

