/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.nsd.dns;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSIncoming;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSMessage;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSQuestion;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSRecord;

public final class DNSOutgoing
extends DNSMessage {
    public static boolean USE_DOMAIN_NAME_COMPRESSION = true;
    Map<String, Integer> names = new HashMap<String, Integer>();
    private int maxUDPPayload;
    private final MessageOutputStream questionsBytes;
    private final MessageOutputStream answersBytes;
    private final MessageOutputStream authoritativeAnswersBytes;
    private final MessageOutputStream additionalsAnswersBytes;
    private static final int HEADER_SIZE = 12;

    public DNSOutgoing(int flags) {
        this(flags, true, 1460);
    }

    public DNSOutgoing(int flags, boolean multicast) {
        this(flags, multicast, 1460);
    }

    public DNSOutgoing(int flags, boolean multicast, int senderUDPPayload) {
        super(flags, 0, multicast);
        this.maxUDPPayload = senderUDPPayload > 0 ? senderUDPPayload : 1460;
        this.questionsBytes = new MessageOutputStream(senderUDPPayload, this);
        this.answersBytes = new MessageOutputStream(senderUDPPayload, this);
        this.authoritativeAnswersBytes = new MessageOutputStream(senderUDPPayload, this);
        this.additionalsAnswersBytes = new MessageOutputStream(senderUDPPayload, this);
    }

    public int availableSpace() {
        return this.maxUDPPayload - 12 - this.questionsBytes.size() - this.answersBytes.size() - this.authoritativeAnswersBytes.size() - this.additionalsAnswersBytes.size();
    }

    public void addQuestion(DNSQuestion rec) throws IOException {
        MessageOutputStream record = new MessageOutputStream(512, this);
        record.writeQuestion(rec);
        byte[] byteArray = record.toByteArray();
        if (byteArray.length >= this.availableSpace()) {
            throw new IOException("message full");
        }
        this.questions.add(rec);
        this.questionsBytes.write(byteArray, 0, byteArray.length);
    }

    public void addAnswer(DNSIncoming in, DNSRecord rec) throws IOException {
        if (in == null || !rec.suppressedBy(in)) {
            this.addAnswer(rec, 0L);
        }
    }

    public void addAnswer(DNSRecord rec, long now) throws IOException {
        if (!(rec == null || now != 0L && rec.isExpired(now))) {
            MessageOutputStream record = new MessageOutputStream(512, this);
            record.writeRecord(rec, now);
            byte[] byteArray = record.toByteArray();
            if (byteArray.length < this.availableSpace()) {
                this.answers.add(rec);
                this.answersBytes.write(byteArray, 0, byteArray.length);
            } else {
                throw new IOException("message full");
            }
        }
    }

    public void addAuthorativeAnswer(DNSRecord rec) throws IOException {
        MessageOutputStream record = new MessageOutputStream(512, this);
        record.writeRecord(rec, 0L);
        byte[] byteArray = record.toByteArray();
        if (byteArray.length >= this.availableSpace()) {
            throw new IOException("message full");
        }
        this.authoritativeAnswers.add(rec);
        this.authoritativeAnswersBytes.write(byteArray, 0, byteArray.length);
    }

    public void addAdditionalAnswer(DNSIncoming in, DNSRecord rec) throws IOException {
        MessageOutputStream record = new MessageOutputStream(512, this);
        record.writeRecord(rec, 0L);
        byte[] byteArray = record.toByteArray();
        if (byteArray.length >= this.availableSpace()) {
            throw new IOException("message full");
        }
        this.additionals.add(rec);
        this.additionalsAnswersBytes.write(byteArray, 0, byteArray.length);
    }

    public byte[] data() {
        long now = System.currentTimeMillis();
        this.names.clear();
        MessageOutputStream message = new MessageOutputStream(this.maxUDPPayload, this);
        message.writeShort(this.multicast ? 0 : this.getId());
        message.writeShort(this.getFlags());
        message.writeShort(this.getNumberOfQuestions());
        message.writeShort(this.getNumberOfAnswers());
        message.writeShort(this.getNumberOfAuthorities());
        message.writeShort(this.getNumberOfAdditionals());
        for (DNSQuestion question : this.questions) {
            message.writeQuestion(question);
        }
        for (DNSRecord record : this.answers) {
            message.writeRecord(record, now);
        }
        for (DNSRecord record : this.authoritativeAnswers) {
            message.writeRecord(record, now);
        }
        for (DNSRecord record : this.additionals) {
            message.writeRecord(record, now);
        }
        return message.toByteArray();
    }

    public int getMaxUDPPayload() {
        return this.maxUDPPayload;
    }

    public static class MessageOutputStream
    extends ByteArrayOutputStream {
        private final DNSOutgoing out;
        private final int offset;

        MessageOutputStream(int size, DNSOutgoing out) {
            this(size, out, 0);
        }

        MessageOutputStream(int size, DNSOutgoing out, int offset) {
            super(size);
            this.out = out;
            this.offset = offset;
        }

        void writeByte(int value) {
            this.write(value & 0xFF);
        }

        void writeBytes(String str, int off, int len) {
            for (int i = 0; i < len; ++i) {
                this.writeByte(str.charAt(off + i));
            }
        }

        @Override
        public void writeBytes(byte[] data) {
            if (data != null) {
                this.writeBytes(data, 0, data.length);
            }
        }

        void writeBytes(byte[] data, int off, int len) {
            for (int i = 0; i < len; ++i) {
                this.writeByte(data[off + i]);
            }
        }

        void writeShort(int value) {
            this.writeByte(value >> 8);
            this.writeByte(value);
        }

        void writeInt(int value) {
            this.writeShort(value >> 16);
            this.writeShort(value);
        }

        void writeUTF(String str, int off, int len) {
            char ch;
            int i;
            int utflen = 0;
            for (i = 0; i < len; ++i) {
                ch = str.charAt(off + i);
                if (ch >= '\u0001' && ch <= '\u007f') {
                    ++utflen;
                    continue;
                }
                if (ch > '\u07ff') {
                    utflen += 3;
                    continue;
                }
                utflen += 2;
            }
            this.writeByte(utflen);
            for (i = 0; i < len; ++i) {
                ch = str.charAt(off + i);
                if (ch >= '\u0001' && ch <= '\u007f') {
                    this.writeByte(ch);
                    continue;
                }
                if (ch > '\u07ff') {
                    this.writeByte(0xE0 | ch >> 12 & 0xF);
                    this.writeByte(0x80 | ch >> 6 & 0x3F);
                    this.writeByte(0x80 | ch >> 0 & 0x3F);
                    continue;
                }
                this.writeByte(0xC0 | ch >> 6 & 0x1F);
                this.writeByte(0x80 | ch >> 0 & 0x3F);
            }
        }

        void writeName(String name) {
            this.writeName(name, true);
        }

        void writeName(String name, boolean useCompression) {
            String aName = name;
            while (true) {
                int n;
                if ((n = aName.indexOf(46)) < 0) {
                    n = aName.length();
                }
                if (n <= 0) {
                    this.writeByte(0);
                    return;
                }
                String label = aName.substring(0, n);
                if (useCompression && USE_DOMAIN_NAME_COMPRESSION) {
                    Integer offset = this.out.names.get(aName);
                    if (offset != null) {
                        int val = offset;
                        this.writeByte(val >> 8 | 0xC0);
                        this.writeByte(val & 0xFF);
                        return;
                    }
                    this.out.names.put(aName, this.size() + this.offset);
                    this.writeUTF(label, 0, label.length());
                } else {
                    this.writeUTF(label, 0, label.length());
                }
                if (!(aName = aName.substring(n)).startsWith(".")) continue;
                aName = aName.substring(1);
            }
        }

        void writeQuestion(DNSQuestion question) {
            this.writeName(question.getName());
            this.writeShort(question.getRecordType().getIndex());
            this.writeShort(question.getRecordClass().getIndex());
        }

        void writeRecord(DNSRecord rec, long now) {
            this.writeName(rec.getName());
            this.writeShort(rec.getRecordType().getIndex());
            this.writeShort(rec.getRecordClass().getIndex() | (rec.isUnique() && this.out.isMulticast() ? 32768 : 0));
            this.writeInt(now == 0L ? rec.getTTL() : rec.getRemainingTTL(now));
            MessageOutputStream record = new MessageOutputStream(512, this.out, this.offset + this.size() + 2);
            rec.write(record);
            byte[] byteArray = record.toByteArray();
            this.writeShort(byteArray.length);
            this.write(byteArray, 0, byteArray.length);
        }
    }
}

