/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.nsd.dns;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSQuestion;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSRecord;

public abstract class DNSMessage {
    public static final boolean MULTICAST = true;
    public static final boolean UNICAST = false;
    private int id;
    boolean multicast;
    private int flags;
    protected final List<DNSQuestion> questions;
    protected final List<DNSRecord> answers;
    protected final List<DNSRecord> authoritativeAnswers;
    protected final List<DNSRecord> additionals;

    protected DNSMessage(int flags, int id, boolean multicast) {
        this.flags = flags;
        this.id = id;
        this.multicast = multicast;
        this.questions = Collections.synchronizedList(new LinkedList());
        this.answers = Collections.synchronizedList(new LinkedList());
        this.authoritativeAnswers = Collections.synchronizedList(new LinkedList());
        this.additionals = Collections.synchronizedList(new LinkedList());
    }

    public int getId() {
        return this.multicast ? 0 : this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public boolean isMulticast() {
        return this.multicast;
    }

    public Collection<? extends DNSQuestion> getQuestions() {
        return this.questions;
    }

    public int getNumberOfQuestions() {
        return this.getQuestions().size();
    }

    public Collection<? extends DNSRecord> getAllAnswers() {
        ArrayList<DNSRecord> aList = new ArrayList<DNSRecord>(this.answers.size() + this.authoritativeAnswers.size() + this.additionals.size());
        aList.addAll(this.answers);
        aList.addAll(this.authoritativeAnswers);
        aList.addAll(this.additionals);
        return aList;
    }

    public Collection<? extends DNSRecord> getAnswers() {
        return this.answers;
    }

    public int getNumberOfAnswers() {
        return this.getAnswers().size();
    }

    public Collection<? extends DNSRecord> getAuthorities() {
        return this.authoritativeAnswers;
    }

    public int getNumberOfAuthorities() {
        return this.getAuthorities().size();
    }

    public Collection<? extends DNSRecord> getAdditionals() {
        return this.additionals;
    }

    public int getNumberOfAdditionals() {
        return this.getAdditionals().size();
    }

    public boolean isValidResponseCode() {
        return (this.flags & 0xF) == 0;
    }

    public int getOperationCode() {
        return (this.flags & 0x7800) >> 11;
    }

    public boolean isTruncated() {
        return (this.flags & 0x200) != 0;
    }

    public boolean isAuthoritativeAnswer() {
        return (this.flags & 0x400) != 0;
    }

    public boolean isQuery() {
        return (this.flags & 0x8000) == 0;
    }

    public boolean isResponse() {
        return (this.flags & 0x8000) == 32768;
    }

    public boolean isEmpty() {
        return this.getNumberOfQuestions() + this.getNumberOfAnswers() + this.getNumberOfAuthorities() + this.getNumberOfAdditionals() == 0;
    }
}

