/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.nsd.dns;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSMessage;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSQuestion;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSRecord;
import jp.co.kingjim.tepraprint.sdk.nsd.util.DNSConstants;
import jp.co.kingjim.tepraprint.sdk.nsd.util.DNSLabel;
import jp.co.kingjim.tepraprint.sdk.nsd.util.DNSOptionCode;
import jp.co.kingjim.tepraprint.sdk.nsd.util.DNSRecordClass;
import jp.co.kingjim.tepraprint.sdk.nsd.util.DNSRecordType;
import jp.co.kingjim.tepraprint.sdk.nsd.util.DNSResultCode;

public final class DNSIncoming
extends DNSMessage {
    public static boolean USE_DOMAIN_NAME_FORMAT_FOR_SRV_TARGET = true;
    private final DatagramPacket packet;
    private final long receivedTime;
    private final MessageInputStream messageInputStream;
    private int senderUDPPayload;

    public DNSIncoming(DatagramPacket packet) throws IOException {
        super(0, 0, packet.getPort() == DNSConstants.MDNS_PORT);
        this.packet = packet;
        InetAddress source = packet.getAddress();
        this.messageInputStream = new MessageInputStream(packet.getData(), packet.getLength());
        this.receivedTime = System.currentTimeMillis();
        this.senderUDPPayload = 1460;
        try {
            DNSRecord rec;
            int i;
            int numAdditionals;
            int numAuthorities;
            int numAnswers;
            this.setId(this.messageInputStream.readUnsignedShort());
            this.setFlags(this.messageInputStream.readUnsignedShort());
            if (this.getOperationCode() > 0) {
                throw new IOException("Received a message with a non standard operation code. Currently unsupported in the specification.");
            }
            int numQuestions = this.messageInputStream.readUnsignedShort();
            if (numQuestions * 5 + ((numAnswers = this.messageInputStream.readUnsignedShort()) + (numAuthorities = this.messageInputStream.readUnsignedShort()) + (numAdditionals = this.messageInputStream.readUnsignedShort())) * 11 > packet.getLength()) {
                throw new IOException("questions:" + numQuestions + " answers:" + numAnswers + " authorities:" + numAuthorities + " additionals:" + numAdditionals);
            }
            if (numQuestions > 0) {
                for (i = 0; i < numQuestions; ++i) {
                    this.questions.add(this.readQuestion());
                }
            }
            if (numAnswers > 0) {
                for (i = 0; i < numAnswers; ++i) {
                    rec = this.readAnswer(source);
                    if (rec == null) continue;
                    this.answers.add(rec);
                }
            }
            if (numAuthorities > 0) {
                for (i = 0; i < numAuthorities; ++i) {
                    rec = this.readAnswer(source);
                    if (rec == null) continue;
                    this.authoritativeAnswers.add(rec);
                }
            }
            if (numAdditionals > 0) {
                for (i = 0; i < numAdditionals; ++i) {
                    rec = this.readAnswer(source);
                    if (rec == null) continue;
                    this.additionals.add(rec);
                }
            }
            if (this.messageInputStream.available() > 0) {
                throw new IOException("Received a message with the wrong length.");
            }
        }
        catch (Exception e) {
            IOException ioe = new IOException("DNSIncoming corrupted message");
            ioe.initCause(e);
            throw ioe;
        }
    }

    private DNSIncoming(int flags, int id, boolean multicast, DatagramPacket packet, long receivedTime) {
        super(flags, id, multicast);
        this.packet = packet;
        this.messageInputStream = new MessageInputStream(packet.getData(), packet.getLength());
        this.receivedTime = receivedTime;
    }

    public DNSIncoming clone() {
        DNSIncoming in = new DNSIncoming(this.getFlags(), this.getId(), this.isMulticast(), this.packet, this.receivedTime);
        in.senderUDPPayload = this.senderUDPPayload;
        in.questions.addAll(this.questions);
        in.answers.addAll(this.answers);
        in.authoritativeAnswers.addAll(this.authoritativeAnswers);
        in.additionals.addAll(this.additionals);
        return in;
    }

    private DNSQuestion readQuestion() {
        String domain = this.messageInputStream.readName();
        DNSRecordType type = DNSRecordType.typeForIndex(this.messageInputStream.readUnsignedShort());
        int recordClassIndex = this.messageInputStream.readUnsignedShort();
        DNSRecordClass recordClass = DNSRecordClass.classForIndex(recordClassIndex);
        boolean unique = recordClass.isUnique(recordClassIndex);
        return DNSQuestion.newQuestion(domain, type, recordClass, unique);
    }

    private DNSRecord readAnswer(InetAddress source) {
        String domain = this.messageInputStream.readName();
        DNSRecordType type = DNSRecordType.typeForIndex(this.messageInputStream.readUnsignedShort());
        int recordClassIndex = this.messageInputStream.readUnsignedShort();
        DNSRecordClass recordClass = type == DNSRecordType.TYPE_OPT ? DNSRecordClass.CLASS_UNKNOWN : DNSRecordClass.classForIndex(recordClassIndex);
        boolean unique = recordClass.isUnique(recordClassIndex);
        int ttl = this.messageInputStream.readInt();
        int len = this.messageInputStream.readUnsignedShort();
        DNSRecord rec = null;
        block1 : switch (type) {
            case TYPE_A: {
                rec = new DNSRecord.IPv4Address(domain, recordClass, unique, ttl, this.messageInputStream.readBytes(len));
                break;
            }
            case TYPE_AAAA: {
                rec = new DNSRecord.IPv6Address(domain, recordClass, unique, ttl, this.messageInputStream.readBytes(len));
                break;
            }
            case TYPE_CNAME: 
            case TYPE_PTR: {
                String service = "";
                service = this.messageInputStream.readName();
                if (service.length() <= 0) break;
                rec = new DNSRecord.Pointer(domain, recordClass, unique, ttl, service);
                break;
            }
            case TYPE_TXT: {
                rec = new DNSRecord.Text(domain, recordClass, unique, ttl, this.messageInputStream.readBytes(len));
                break;
            }
            case TYPE_SRV: {
                int priority = this.messageInputStream.readUnsignedShort();
                int weight = this.messageInputStream.readUnsignedShort();
                int port = this.messageInputStream.readUnsignedShort();
                String target = "";
                target = USE_DOMAIN_NAME_FORMAT_FOR_SRV_TARGET ? this.messageInputStream.readName() : this.messageInputStream.readNonNameString();
                rec = new DNSRecord.Service(domain, recordClass, unique, ttl, priority, weight, port, target);
                break;
            }
            case TYPE_HINFO: {
                StringBuilder buf = new StringBuilder();
                buf.append(this.messageInputStream.readUTF(len));
                int index = buf.indexOf(" ");
                String cpu = (index > 0 ? buf.substring(0, index) : buf.toString()).trim();
                String os = (index > 0 ? buf.substring(index + 1) : "").trim();
                rec = new DNSRecord.HostInformation(domain, recordClass, unique, ttl, cpu, os);
                break;
            }
            case TYPE_OPT: {
                DNSResultCode extendedResultCode = DNSResultCode.resultCodeForFlags(this.getFlags(), ttl);
                int version = (ttl & 0xFF0000) >> 16;
                if (version != 0) break;
                this.senderUDPPayload = recordClassIndex;
                block16: while (this.messageInputStream.available() > 0) {
                    int optionCodeInt = 0;
                    DNSOptionCode optionCode = null;
                    if (this.messageInputStream.available() < 2) break block1;
                    optionCodeInt = this.messageInputStream.readUnsignedShort();
                    optionCode = DNSOptionCode.resultCodeForFlags(optionCodeInt);
                    int optionLength = 0;
                    if (this.messageInputStream.available() < 2) break block1;
                    optionLength = this.messageInputStream.readUnsignedShort();
                    byte[] optiondata = new byte[]{};
                    if (this.messageInputStream.available() >= optionLength) {
                        optiondata = this.messageInputStream.readBytes(optionLength);
                    }
                    switch (optionCode) {
                        case Owner: {
                            byte ownerVersion = 0;
                            byte ownerSequence = 0;
                            byte[] ownerPrimaryMacAddress = null;
                            byte[] ownerWakeupMacAddress = null;
                            byte[] ownerPassword = null;
                            try {
                                ownerVersion = optiondata[0];
                                ownerSequence = optiondata[1];
                                ownerWakeupMacAddress = ownerPrimaryMacAddress = new byte[]{optiondata[2], optiondata[3], optiondata[4], optiondata[5], optiondata[6], optiondata[7]};
                                if (optiondata.length > 8) {
                                    ownerWakeupMacAddress = new byte[]{optiondata[8], optiondata[9], optiondata[10], optiondata[11], optiondata[12], optiondata[13]};
                                }
                                if (optiondata.length == 18) {
                                    ownerPassword = new byte[]{optiondata[14], optiondata[15], optiondata[16], optiondata[17]};
                                }
                                if (optiondata.length != 22) continue block16;
                                ownerPassword = new byte[]{optiondata[14], optiondata[15], optiondata[16], optiondata[17], optiondata[18], optiondata[19], optiondata[20], optiondata[21]};
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            break;
                        }
                        case LLQ: 
                        case NSID: 
                        case UL: {
                            break;
                        }
                        case Unknown: {
                            break;
                        }
                    }
                }
                break;
            }
            default: {
                this.messageInputStream.skip(len);
            }
        }
        if (rec != null) {
            rec.setRecordSource(source);
        }
        return rec;
    }

    public void append(DNSIncoming that) {
        if (!(this.isQuery() && this.isTruncated() && that.isQuery())) {
            throw new IllegalArgumentException();
        }
        this.questions.addAll(that.getQuestions());
        this.answers.addAll(that.getAnswers());
        this.authoritativeAnswers.addAll(that.getAuthorities());
        this.additionals.addAll(that.getAdditionals());
    }

    public int elapseSinceArrival() {
        return (int)(System.currentTimeMillis() - this.receivedTime);
    }

    public int getSenderUDPPayload() {
        return this.senderUDPPayload;
    }

    public static class MessageInputStream
    extends ByteArrayInputStream {
        final Map<Integer, String> names = new HashMap<Integer, String>();

        public MessageInputStream(byte[] buffer, int length) {
            this(buffer, 0, length);
        }

        public MessageInputStream(byte[] buffer, int offset, int length) {
            super(buffer, offset, length);
        }

        public int readByte() {
            return this.read();
        }

        public int readUnsignedByte() {
            return this.read() & 0xFF;
        }

        public int readUnsignedShort() {
            return this.readUnsignedByte() << 8 | this.readUnsignedByte();
        }

        public int readInt() {
            return this.readUnsignedShort() << 16 | this.readUnsignedShort();
        }

        public byte[] readBytes(int len) {
            byte[] bytes = new byte[len];
            this.read(bytes, 0, len);
            return bytes;
        }

        public String readUTF(int len) {
            StringBuilder buffer = new StringBuilder(len);
            for (int index = 0; index < len; ++index) {
                int ch = this.readUnsignedByte();
                switch (ch >> 4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        break;
                    }
                    case 12: 
                    case 13: {
                        ch = (ch & 0x1F) << 6 | this.readUnsignedByte() & 0x3F;
                        ++index;
                        break;
                    }
                    case 14: {
                        ch = (ch & 0xF) << 12 | (this.readUnsignedByte() & 0x3F) << 6 | this.readUnsignedByte() & 0x3F;
                        ++index;
                        ++index;
                        break;
                    }
                    default: {
                        ch = (ch & 0x3F) << 4 | this.readUnsignedByte() & 0xF;
                        ++index;
                    }
                }
                buffer.append((char)ch);
            }
            return buffer.toString();
        }

        protected synchronized int peek() {
            return this.pos < this.count ? this.buf[this.pos] & 0xFF : -1;
        }

        public String readName() {
            HashMap<Integer, StringBuilder> names = new HashMap<Integer, StringBuilder>();
            StringBuilder buffer = new StringBuilder();
            boolean finished = false;
            while (!finished) {
                int len = this.readUnsignedByte();
                if (len == 0) {
                    finished = true;
                    break;
                }
                switch (DNSLabel.labelForByte(len)) {
                    case Standard: {
                        int offset = this.pos - 1;
                        String label = this.readUTF(len) + ".";
                        buffer.append(label);
                        for (StringBuilder previousLabel : names.values()) {
                            previousLabel.append(label);
                        }
                        names.put(offset, new StringBuilder(label));
                        break;
                    }
                    case Compressed: {
                        int index = DNSLabel.getLabelValue(len) << 8 | this.readUnsignedByte();
                        String compressedLabel = this.names.get(index);
                        if (compressedLabel == null) {
                            compressedLabel = "";
                        }
                        buffer.append(compressedLabel);
                        for (StringBuilder previousLabel : names.values()) {
                            previousLabel.append(compressedLabel);
                        }
                        finished = true;
                        break;
                    }
                    case Extended: {
                        break;
                    }
                }
            }
            for (Integer index : names.keySet()) {
                this.names.put(index, ((StringBuilder)names.get(index)).toString());
            }
            return buffer.toString();
        }

        public String readNonNameString() {
            int len = this.readUnsignedByte();
            return this.readUTF(len);
        }
    }
}

