/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.nsd.dns;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import jp.co.kingjim.tepraprint.sdk.nsd.NsdServiceInfo;
import jp.co.kingjim.tepraprint.sdk.nsd.util.DNSRecordClass;
import jp.co.kingjim.tepraprint.sdk.nsd.util.DNSRecordType;

public abstract class DNSEntry {
    private final String key;
    private final String name;
    private final String type;
    private final DNSRecordType recordType;
    private final DNSRecordClass dnsClass;
    private final boolean unique;
    final Map<NsdServiceInfo.Fields, String> qualifiedNameMap;

    DNSEntry(String name, DNSRecordType type, DNSRecordClass recordClass, boolean unique) {
        this.name = name;
        this.recordType = type;
        this.dnsClass = recordClass;
        this.unique = unique;
        this.qualifiedNameMap = NsdServiceInfo.decodeQualifiedNameMapForType(this.getName());
        String domain = this.qualifiedNameMap.get((Object)NsdServiceInfo.Fields.Domain);
        String protocol = this.qualifiedNameMap.get((Object)NsdServiceInfo.Fields.Protocol);
        String application = this.qualifiedNameMap.get((Object)NsdServiceInfo.Fields.Application);
        String instance = this.qualifiedNameMap.get((Object)NsdServiceInfo.Fields.Instance).toLowerCase();
        this.type = (application.length() > 0 ? "_" + application + "." : "") + (protocol.length() > 0 ? "_" + protocol + "." : "") + domain + ".";
        this.key = ((instance.length() > 0 ? instance + "." : "") + this.type).toLowerCase();
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof DNSEntry) {
            DNSEntry other = (DNSEntry)obj;
            result = this.getKey().equals(other.getKey()) && this.getRecordType().equals((Object)other.getRecordType()) && this.getRecordClass() == other.getRecordClass();
        }
        return result;
    }

    public boolean isSameEntry(DNSEntry entry) {
        return this.getKey().equals(entry.getKey()) && this.matchRecordType(entry.getRecordType()) && this.matchRecordClass(entry.getRecordClass());
    }

    public boolean sameSubtype(DNSEntry other) {
        return this.getSubtype().equals(other.getSubtype());
    }

    public boolean matchRecordClass(DNSRecordClass recordClass) {
        return DNSRecordClass.CLASS_ANY == recordClass || DNSRecordClass.CLASS_ANY == this.getRecordClass() || this.getRecordClass().equals((Object)recordClass);
    }

    public boolean matchRecordType(DNSRecordType recordType) {
        return this.getRecordType().equals((Object)recordType);
    }

    public String getSubtype() {
        String subtype = this.getQualifiedNameMap().get((Object)NsdServiceInfo.Fields.Subtype);
        return subtype != null ? subtype : "";
    }

    public String getName() {
        return this.name != null ? this.name : "";
    }

    public String getType() {
        return this.type != null ? this.type : "";
    }

    public String getKey() {
        return this.key != null ? this.key : "";
    }

    public DNSRecordType getRecordType() {
        return this.recordType != null ? this.recordType : DNSRecordType.TYPE_IGNORE;
    }

    public DNSRecordClass getRecordClass() {
        return this.dnsClass != null ? this.dnsClass : DNSRecordClass.CLASS_UNKNOWN;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public Map<NsdServiceInfo.Fields, String> getQualifiedNameMap() {
        return Collections.unmodifiableMap(this.qualifiedNameMap);
    }

    public boolean isServicesDiscoveryMetaQuery() {
        return this.qualifiedNameMap.get((Object)NsdServiceInfo.Fields.Application).equals("dns-sd") && this.qualifiedNameMap.get((Object)NsdServiceInfo.Fields.Instance).equals("_services");
    }

    public boolean isDomainDiscoveryQuery() {
        if (this.qualifiedNameMap.get((Object)NsdServiceInfo.Fields.Application).equals("dns-sd")) {
            String name = this.qualifiedNameMap.get((Object)NsdServiceInfo.Fields.Instance);
            return "b".equals(name) || "db".equals(name) || "r".equals(name) || "dr".equals(name) || "lb".equals(name);
        }
        return false;
    }

    public boolean isReverseLookup() {
        return this.isV4ReverseLookup() || this.isV6ReverseLookup();
    }

    public boolean isV4ReverseLookup() {
        return this.qualifiedNameMap.get((Object)NsdServiceInfo.Fields.Domain).endsWith("in-addr.arpa");
    }

    public boolean isV6ReverseLookup() {
        return this.qualifiedNameMap.get((Object)NsdServiceInfo.Fields.Domain).endsWith("ip6.arpa");
    }

    public abstract boolean isStale(long var1);

    public abstract boolean isExpired(long var1);

    public boolean isSameRecordClass(DNSEntry entry) {
        return entry != null && entry.getRecordClass() == this.getRecordClass();
    }

    public boolean isSameType(DNSEntry entry) {
        return entry != null && entry.getRecordType() == this.getRecordType();
    }

    protected void toByteArray(DataOutputStream dout) throws IOException {
        dout.write(this.getName().getBytes("UTF8"));
        dout.writeShort(this.getRecordType().getIndex());
        dout.writeShort(this.getRecordClass().getIndex());
    }

    protected byte[] toByteArray() {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            this.toByteArray(dout);
            dout.close();
            return bout.toByteArray();
        }
        catch (IOException e) {
            throw new InternalError();
        }
    }

    public int compareTo(DNSEntry that) {
        byte[] thisBytes = this.toByteArray();
        byte[] thatBytes = that.toByteArray();
        int n = Math.min(thisBytes.length, thatBytes.length);
        for (int i = 0; i < n; ++i) {
            if (thisBytes[i] > thatBytes[i]) {
                return 1;
            }
            if (thisBytes[i] >= thatBytes[i]) continue;
            return -1;
        }
        return thisBytes.length - thatBytes.length;
    }
}

