/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.nsd;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import jp.co.kingjim.tepraprint.sdk.nsd.NsdManager;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSCache;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSEntry;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSListener;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSRecord;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSStatefulObject;
import jp.co.kingjim.tepraprint.sdk.nsd.service.HostInfo;
import jp.co.kingjim.tepraprint.sdk.nsd.service.ServiceEvent;
import jp.co.kingjim.tepraprint.sdk.nsd.task.DNSTask;
import jp.co.kingjim.tepraprint.sdk.nsd.util.DNSRecordClass;
import jp.co.kingjim.tepraprint.sdk.nsd.util.DNSRecordType;
import jp.co.kingjim.tepraprint.sdk.nsd.util.DNSState;

public class NsdServiceInfo
implements Cloneable,
DNSListener,
DNSStatefulObject {
    public static final byte[] NO_VALUE = new byte[0];
    private String domain;
    private String protocol;
    private String application;
    private String name;
    private String subtype;
    private String server;
    private int port;
    private int weight;
    private int priority;
    private byte[] text;
    private Map<String, byte[]> props;
    private final Set<Inet4Address> ipv4Addresses;
    private final Set<Inet6Address> ipv6Addresses;
    private transient String key;
    private boolean persistent;
    private boolean needTextAnnouncing;
    private final ServiceInfoState state;

    public NsdServiceInfo(String type, String name, String subtype, int port, int weight, int priority, boolean persistent, String text) {
        this(NsdServiceInfo.decodeQualifiedNameMap(type, name, subtype), port, weight, priority, persistent, (byte[])null);
        this.server = text;
        byte[] encodedText = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(256);
            ByteArrayOutputStream out2 = new ByteArrayOutputStream(100);
            NsdServiceInfo.writeUTF(out2, text);
            byte[] data = out2.toByteArray();
            if (data.length > 255) {
                throw new IOException("Cannot have individual values larger that 255 chars. Offending value: " + text);
            }
            out.write((byte)data.length);
            out.write(data, 0, data.length);
            encodedText = out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected exception: " + e);
        }
        this.text = encodedText != null && encodedText.length > 0 ? encodedText : DNSRecord.EMPTY_TXT;
    }

    public NsdServiceInfo(String type, String name, String subtype, int port, int weight, int priority, boolean persistent, byte[] text) {
        this(NsdServiceInfo.decodeQualifiedNameMap(type, name, subtype), port, weight, priority, persistent, text);
    }

    public NsdServiceInfo(Map<Fields, String> qualifiedNameMap, int port, int weight, int priority, boolean persistent, Map<String, ?> props) {
        this(qualifiedNameMap, port, weight, priority, persistent, NsdServiceInfo.textFromProperties(props));
    }

    public NsdServiceInfo(Map<Fields, String> qualifiedNameMap, int port, int weight, int priority, boolean persistent, String text) {
        this(qualifiedNameMap, port, weight, priority, persistent, (byte[])null);
        this.server = text;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(text.length());
            NsdServiceInfo.writeUTF(out, text);
            this.text = out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected exception: " + e);
        }
    }

    public NsdServiceInfo(Map<Fields, String> qualifiedNameMap, int port, int weight, int priority, boolean persistent, byte[] text) {
        Map<Fields, String> map = NsdServiceInfo.checkQualifiedNameMap(qualifiedNameMap);
        this.domain = map.get((Object)Fields.Domain);
        this.protocol = map.get((Object)Fields.Protocol);
        this.application = map.get((Object)Fields.Application);
        this.name = map.get((Object)Fields.Instance);
        this.subtype = map.get((Object)Fields.Subtype);
        this.port = port;
        this.weight = weight;
        this.priority = priority;
        this.text = text;
        this.setNeedTextAnnouncing(false);
        this.state = new ServiceInfoState(this);
        this.persistent = persistent;
        this.ipv4Addresses = Collections.synchronizedSet(new LinkedHashSet());
        this.ipv6Addresses = Collections.synchronizedSet(new LinkedHashSet());
    }

    public NsdServiceInfo(NsdServiceInfo info) {
        this.ipv4Addresses = Collections.synchronizedSet(new LinkedHashSet());
        this.ipv6Addresses = Collections.synchronizedSet(new LinkedHashSet());
        if (info != null) {
            Inet4Address[] ipv4Addresses;
            Inet6Address[] ipv6Addresses;
            this.domain = info.getDomain();
            this.protocol = info.getProtocol();
            this.application = info.getApplication();
            this.name = info.getName();
            this.subtype = info.getSubtype();
            this.port = info.getPort();
            this.weight = info.getWeight();
            this.priority = info.getPriority();
            this.text = info.getTextBytes();
            this.persistent = info.isPersistent();
            for (Inet6Address address : ipv6Addresses = info.getInet6Addresses()) {
                this.ipv6Addresses.add(address);
            }
            for (Inet4Address address : ipv4Addresses = info.getInet4Addresses()) {
                this.ipv4Addresses.add(address);
            }
        }
        this.state = new ServiceInfoState(this);
    }

    public static Map<Fields, String> decodeQualifiedNameMap(String type, String name, String subtype) {
        Map<Fields, String> qualifiedNameMap = NsdServiceInfo.decodeQualifiedNameMapForType(type);
        qualifiedNameMap.put(Fields.Instance, name);
        qualifiedNameMap.put(Fields.Subtype, subtype);
        return NsdServiceInfo.checkQualifiedNameMap(qualifiedNameMap);
    }

    public static Map<Fields, String> decodeQualifiedNameMapForType(String type) {
        String aType;
        String casePreservedType = type;
        String application = aType = type.toLowerCase();
        String protocol = "";
        String subtype = "";
        String name = "";
        String domain = "";
        if (aType.contains("in-addr.arpa") || aType.contains("ip6.arpa")) {
            int index = aType.contains("in-addr.arpa") ? aType.indexOf("in-addr.arpa") : aType.indexOf("ip6.arpa");
            name = NsdServiceInfo.removeSeparators(casePreservedType.substring(0, index));
            domain = casePreservedType.substring(index);
            application = "";
        } else if (!aType.contains("_") && aType.contains(".")) {
            int index = aType.indexOf(46);
            name = NsdServiceInfo.removeSeparators(casePreservedType.substring(0, index));
            domain = NsdServiceInfo.removeSeparators(casePreservedType.substring(index));
            application = "";
        } else {
            int end;
            int start;
            int index;
            if ((!aType.startsWith("_") || aType.startsWith("_services")) && (index = aType.indexOf("._")) > 0) {
                name = casePreservedType.substring(0, index);
                if (index + 1 < aType.length()) {
                    aType = aType.substring(index + 1);
                    casePreservedType = casePreservedType.substring(index + 1);
                }
            }
            if ((index = aType.lastIndexOf("._")) > 0) {
                start = index + 2;
                end = aType.indexOf(46, start);
                protocol = casePreservedType.substring(start, end);
            }
            if (protocol.length() > 0) {
                index = aType.indexOf("_" + protocol.toLowerCase() + ".");
                start = index + protocol.length() + 2;
                end = aType.length() - (aType.endsWith(".") ? 1 : 0);
                if (end > start) {
                    domain = casePreservedType.substring(start, end);
                }
                application = index > 0 ? casePreservedType.substring(0, index - 1) : "";
            }
            if ((index = application.toLowerCase().indexOf("._sub")) > 0) {
                start = index + 5;
                subtype = NsdServiceInfo.removeSeparators(application.substring(0, index));
                application = application.substring(start);
            }
        }
        HashMap<Fields, String> qualifiedNameMap = new HashMap<Fields, String>(5);
        qualifiedNameMap.put(Fields.Domain, NsdServiceInfo.removeSeparators(domain));
        qualifiedNameMap.put(Fields.Protocol, protocol);
        qualifiedNameMap.put(Fields.Application, NsdServiceInfo.removeSeparators(application));
        qualifiedNameMap.put(Fields.Instance, name);
        qualifiedNameMap.put(Fields.Subtype, subtype);
        return qualifiedNameMap;
    }

    protected static Map<Fields, String> checkQualifiedNameMap(Map<Fields, String> qualifiedNameMap) {
        String subtype;
        String instance;
        String application;
        String protocol;
        String domain;
        HashMap<Fields, String> checkedQualifiedNameMap = new HashMap<Fields, String>(5);
        String string = domain = qualifiedNameMap.containsKey((Object)Fields.Domain) ? qualifiedNameMap.get((Object)Fields.Domain) : "local";
        if (domain == null || domain.length() == 0) {
            domain = "local";
        }
        domain = NsdServiceInfo.removeSeparators(domain);
        checkedQualifiedNameMap.put(Fields.Domain, domain);
        String string2 = protocol = qualifiedNameMap.containsKey((Object)Fields.Protocol) ? qualifiedNameMap.get((Object)Fields.Protocol) : "tcp";
        if (protocol == null || protocol.length() == 0) {
            protocol = "tcp";
        }
        protocol = NsdServiceInfo.removeSeparators(protocol);
        checkedQualifiedNameMap.put(Fields.Protocol, protocol);
        String string3 = application = qualifiedNameMap.containsKey((Object)Fields.Application) ? qualifiedNameMap.get((Object)Fields.Application) : "";
        if (application == null || application.length() == 0) {
            application = "";
        }
        application = NsdServiceInfo.removeSeparators(application);
        checkedQualifiedNameMap.put(Fields.Application, application);
        String string4 = instance = qualifiedNameMap.containsKey((Object)Fields.Instance) ? qualifiedNameMap.get((Object)Fields.Instance) : "";
        if (instance == null || instance.length() == 0) {
            instance = "";
        }
        instance = NsdServiceInfo.removeSeparators(instance);
        checkedQualifiedNameMap.put(Fields.Instance, instance);
        String string5 = subtype = qualifiedNameMap.containsKey((Object)Fields.Subtype) ? qualifiedNameMap.get((Object)Fields.Subtype) : "";
        if (subtype == null || subtype.length() == 0) {
            subtype = "";
        }
        subtype = NsdServiceInfo.removeSeparators(subtype);
        checkedQualifiedNameMap.put(Fields.Subtype, subtype);
        return checkedQualifiedNameMap;
    }

    private static String removeSeparators(String name) {
        if (name == null) {
            return "";
        }
        String newName = name.trim();
        if (newName.startsWith(".")) {
            newName = newName.substring(1);
        }
        if (newName.startsWith("_")) {
            newName = newName.substring(1);
        }
        if (newName.endsWith(".")) {
            newName = newName.substring(0, newName.length() - 1);
        }
        return newName;
    }

    public synchronized boolean hasData() {
        return this.getServer() != null && this.hasInetAddress() && this.getTextBytes() != null && this.getTextBytes().length > 0;
    }

    private final boolean hasInetAddress() {
        return this.ipv4Addresses.size() > 0 || this.ipv6Addresses.size() > 0;
    }

    public String getType() {
        String domain = this.getDomain();
        String protocol = this.getProtocol();
        String application = this.getApplication();
        return (application.length() > 0 ? "_" + application + "." : "") + (protocol.length() > 0 ? "_" + protocol + "." : "") + domain + ".";
    }

    public String getTypeWithSubtype() {
        String subtype = this.getSubtype();
        return (subtype.length() > 0 ? "_" + subtype.toLowerCase() + "._sub." : "") + this.getType();
    }

    public String getName() {
        return this.name != null ? this.name : "";
    }

    public String getKey() {
        if (this.key == null) {
            this.key = this.getQualifiedName().toLowerCase();
        }
        return this.key;
    }

    public void setName(String name) {
        this.name = name;
        this.key = null;
    }

    public String getQualifiedName() {
        String domain = this.getDomain();
        String protocol = this.getProtocol();
        String application = this.getApplication();
        String instance = this.getName();
        return (instance.length() > 0 ? instance + "." : "") + (application.length() > 0 ? "_" + application + "." : "") + (protocol.length() > 0 ? "_" + protocol + "." : "") + domain + ".";
    }

    public String getServer() {
        return this.server != null ? this.server : "";
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void addAddress(Inet4Address addr) {
        this.ipv4Addresses.add(addr);
    }

    public void addAddress(Inet6Address addr) {
        this.ipv6Addresses.add(addr);
    }

    public InetAddress[] getInetAddresses() {
        ArrayList<InetAddress> aList = new ArrayList<InetAddress>(this.ipv4Addresses.size() + this.ipv6Addresses.size());
        aList.addAll(this.ipv4Addresses);
        aList.addAll(this.ipv6Addresses);
        return aList.toArray(new InetAddress[aList.size()]);
    }

    public Inet4Address[] getInet4Addresses() {
        return this.ipv4Addresses.toArray(new Inet4Address[this.ipv4Addresses.size()]);
    }

    public Inet6Address[] getInet6Addresses() {
        return this.ipv6Addresses.toArray(new Inet6Address[this.ipv6Addresses.size()]);
    }

    public int getPort() {
        return this.port;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getWeight() {
        return this.weight;
    }

    public byte[] getTextBytes() {
        return this.text != null && this.text.length > 0 ? this.text : DNSRecord.EMPTY_TXT;
    }

    public Collection<DNSRecord> answers(DNSRecordClass recordClass, boolean unique, int ttl, HostInfo localHost) {
        ArrayList<DNSRecord> list = new ArrayList<DNSRecord>();
        if (recordClass == DNSRecordClass.CLASS_ANY || recordClass == DNSRecordClass.CLASS_IN) {
            if (this.getSubtype().length() > 0) {
                list.add(new DNSRecord.Pointer(this.getTypeWithSubtype(), DNSRecordClass.CLASS_IN, false, ttl, this.getQualifiedName()));
            }
            list.add(new DNSRecord.Pointer(this.getType(), DNSRecordClass.CLASS_IN, false, ttl, this.getQualifiedName()));
            list.add(new DNSRecord.Service(this.getQualifiedName(), DNSRecordClass.CLASS_IN, unique, ttl, this.priority, this.weight, this.port, localHost.getName()));
            list.add(new DNSRecord.Text(this.getQualifiedName(), DNSRecordClass.CLASS_IN, unique, ttl, this.getTextBytes()));
        }
        return list;
    }

    public void _setText(byte[] text) {
        this.text = text;
        this.props = null;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setNeedTextAnnouncing(boolean needTextAnnouncing) {
        this.needTextAnnouncing = needTextAnnouncing;
        if (this.needTextAnnouncing) {
            this.state.setTask(null);
        }
    }

    public boolean needTextAnnouncing() {
        return this.needTextAnnouncing;
    }

    public String getDomain() {
        return this.domain != null ? this.domain : "local";
    }

    public String getProtocol() {
        return this.protocol != null ? this.protocol : "tcp";
    }

    public String getApplication() {
        return this.application != null ? this.application : "";
    }

    public String getSubtype() {
        return this.subtype != null ? this.subtype : "";
    }

    public Map<Fields, String> getQualifiedNameMap() {
        HashMap<Fields, String> map = new HashMap<Fields, String>(5);
        map.put(Fields.Domain, this.getDomain());
        map.put(Fields.Protocol, this.getProtocol());
        map.put(Fields.Application, this.getApplication());
        map.put(Fields.Instance, this.getName());
        map.put(Fields.Subtype, this.getSubtype());
        return map;
    }

    static void writeUTF(OutputStream out, String str) throws IOException {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                out.write(c);
                continue;
            }
            if (c > '\u07ff') {
                out.write(0xE0 | c >> 12 & 0xF);
                out.write(0x80 | c >> 6 & 0x3F);
                out.write(0x80 | c >> 0 & 0x3F);
                continue;
            }
            out.write(0xC0 | c >> 6 & 0x1F);
            out.write(0x80 | c >> 0 & 0x3F);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRecord(DNSCache dnsCache, long now, DNSEntry rec) {
        if (rec instanceof DNSRecord && !rec.isExpired(now)) {
            NsdManager dns;
            boolean serviceUpdated = false;
            switch (rec.getRecordType()) {
                case TYPE_A: {
                    if (!rec.getName().equalsIgnoreCase(this.getServer())) break;
                    this.ipv4Addresses.add((Inet4Address)((DNSRecord.Address)rec).getAddress());
                    serviceUpdated = true;
                    break;
                }
                case TYPE_AAAA: {
                    if (!rec.getName().equalsIgnoreCase(this.getServer())) break;
                    this.ipv6Addresses.add((Inet6Address)((DNSRecord.Address)rec).getAddress());
                    serviceUpdated = true;
                    break;
                }
                case TYPE_SRV: {
                    if (!rec.getName().equalsIgnoreCase(this.getQualifiedName())) break;
                    DNSRecord.Service srv = (DNSRecord.Service)rec;
                    boolean serverChanged = this.server == null || !this.server.equalsIgnoreCase(srv.getServer());
                    this.server = srv.getServer();
                    this.port = srv.getPort();
                    this.weight = srv.getWeight();
                    this.priority = srv.getPriority();
                    if (serverChanged) {
                        this.ipv4Addresses.clear();
                        this.ipv6Addresses.clear();
                        for (DNSEntry dNSEntry : dnsCache.getDNSEntryList(this.server, DNSRecordType.TYPE_A, DNSRecordClass.CLASS_IN)) {
                            this.updateRecord(dnsCache, now, dNSEntry);
                        }
                        for (DNSEntry dNSEntry : dnsCache.getDNSEntryList(this.server, DNSRecordType.TYPE_AAAA, DNSRecordClass.CLASS_IN)) {
                            this.updateRecord(dnsCache, now, dNSEntry);
                        }
                        break;
                    }
                    serviceUpdated = true;
                    break;
                }
                case TYPE_TXT: {
                    if (!rec.getName().equalsIgnoreCase(this.getQualifiedName())) break;
                    DNSRecord.Text txt = (DNSRecord.Text)rec;
                    this.text = txt.getText();
                    this.props = null;
                    serviceUpdated = true;
                    break;
                }
                case TYPE_PTR: {
                    if (this.getSubtype().length() != 0 || rec.getSubtype().length() == 0) break;
                    this.subtype = rec.getSubtype();
                    serviceUpdated = true;
                    break;
                }
            }
            if (serviceUpdated && this.hasData() && (dns = this.getDns()) != null) {
                ServiceEvent event = new ServiceEvent(dns, this.getType(), this.getName(), this);
                dns.handleServiceResolved(event);
            }
            NsdServiceInfo nsdServiceInfo = this;
            synchronized (nsdServiceInfo) {
                this.notifyAll();
            }
        }
    }

    @Override
    public boolean advanceState(DNSTask task) {
        return this.state.advanceState(task);
    }

    @Override
    public boolean revertState() {
        return this.state.revertState();
    }

    @Override
    public boolean cancelState() {
        return this.state.cancelState();
    }

    @Override
    public boolean closeState() {
        return this.state.closeState();
    }

    @Override
    public boolean recoverState() {
        return this.state.recoverState();
    }

    @Override
    public void removeAssociationWithTask(DNSTask task) {
        this.state.removeAssociationWithTask(task);
    }

    @Override
    public void associateWithTask(DNSTask task, DNSState state) {
        this.state.associateWithTask(task, state);
    }

    @Override
    public boolean isAssociatedWithTask(DNSTask task, DNSState state) {
        return this.state.isAssociatedWithTask(task, state);
    }

    @Override
    public boolean isProbing() {
        return this.state.isProbing();
    }

    @Override
    public boolean isAnnouncing() {
        return this.state.isAnnouncing();
    }

    @Override
    public boolean isAnnounced() {
        return this.state.isAnnounced();
    }

    @Override
    public boolean isCanceling() {
        return this.state.isCanceling();
    }

    @Override
    public boolean isCanceled() {
        return this.state.isCanceled();
    }

    @Override
    public boolean isClosing() {
        return this.state.isClosing();
    }

    @Override
    public boolean isClosed() {
        return this.state.isClosed();
    }

    @Override
    public boolean waitForAnnounced(long timeout) {
        return this.state.waitForAnnounced(timeout);
    }

    @Override
    public boolean waitForCanceled(long timeout) {
        return this.state.waitForCanceled(timeout);
    }

    public void setDns(NsdManager dns) {
        this.state.setDns(dns);
    }

    @Override
    public NsdManager getDns() {
        return this.state.getDns();
    }

    public int hashCode() {
        return this.getQualifiedName().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof NsdServiceInfo && this.getQualifiedName().equals(((NsdServiceInfo)obj).getQualifiedName());
    }

    public NsdServiceInfo clone() {
        Inet4Address[] ipv4Addresses;
        Inet6Address[] ipv6Addresses;
        NsdServiceInfo serviceInfo = new NsdServiceInfo(this.getQualifiedNameMap(), this.port, this.weight, this.priority, this.persistent, this.text);
        for (Inet6Address address : ipv6Addresses = this.getInet6Addresses()) {
            serviceInfo.ipv6Addresses.add(address);
        }
        for (Inet4Address address : ipv4Addresses = this.getInet4Addresses()) {
            serviceInfo.ipv4Addresses.add(address);
        }
        return serviceInfo;
    }

    private static byte[] textFromProperties(Map<String, ?> props) {
        byte[] text = null;
        if (props != null) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream(256);
                for (String key : props.keySet()) {
                    byte[] data;
                    Object val = props.get(key);
                    ByteArrayOutputStream out2 = new ByteArrayOutputStream(100);
                    NsdServiceInfo.writeUTF(out2, key);
                    if (val != null) {
                        if (val instanceof String) {
                            out2.write(61);
                            NsdServiceInfo.writeUTF(out2, (String)val);
                        } else if (val instanceof byte[]) {
                            byte[] bval = (byte[])val;
                            if (bval.length > 0) {
                                out2.write(61);
                                out2.write(bval, 0, bval.length);
                            } else {
                                val = null;
                            }
                        } else {
                            throw new IllegalArgumentException("invalid property value: " + val);
                        }
                    }
                    if ((data = out2.toByteArray()).length > 255) {
                        throw new IOException("Cannot have individual values larger that 255 chars. Offending value: " + key + (val != null ? "" : "=" + val));
                    }
                    out.write((byte)data.length);
                    out.write(data, 0, data.length);
                }
                text = out.toByteArray();
            }
            catch (IOException e) {
                throw new RuntimeException("unexpected exception: " + e);
            }
        }
        return text != null && text.length > 0 ? text : DNSRecord.EMPTY_TXT;
    }

    public static enum Fields {
        Domain,
        Protocol,
        Application,
        Instance,
        Subtype;

    }

    private static final class ServiceInfoState
    extends DNSStatefulObject.DefaultImplementation {
        private static final long serialVersionUID = 1L;
        private final NsdServiceInfo info;

        public ServiceInfoState(NsdServiceInfo info) {
            this.info = info;
        }

        @Override
        protected void setTask(DNSTask task) {
            super.setTask(task);
            if (this.task == null && this.info.needTextAnnouncing()) {
                this.lock();
                try {
                    if (this.task == null && this.info.needTextAnnouncing()) {
                        if (this.state.isAnnounced()) {
                            this.setState(DNSState.ANNOUNCING_1);
                            if (this.getDns() != null) {
                                this.getDns().startAnnouncer();
                            }
                        }
                        this.info.setNeedTextAnnouncing(false);
                    }
                }
                finally {
                    this.unlock();
                }
            }
        }

        @Override
        public void setDns(NsdManager dns) {
            super.setDns(dns);
        }
    }
}

