/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.nsd;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.ReentrantLock;
import jp.co.kingjim.tepraprint.sdk.nsd.NsdServiceInfo;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSCache;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSEntry;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSIncoming;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSListener;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSOutgoing;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSQuestion;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSRecord;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSStatefulObject;
import jp.co.kingjim.tepraprint.sdk.nsd.dns.DNSTaskStarter;
import jp.co.kingjim.tepraprint.sdk.nsd.service.HostInfo;
import jp.co.kingjim.tepraprint.sdk.nsd.service.ListenerStatus;
import jp.co.kingjim.tepraprint.sdk.nsd.service.NameRegister;
import jp.co.kingjim.tepraprint.sdk.nsd.service.ServiceEvent;
import jp.co.kingjim.tepraprint.sdk.nsd.service.ServiceListener;
import jp.co.kingjim.tepraprint.sdk.nsd.service.SocketListener;
import jp.co.kingjim.tepraprint.sdk.nsd.task.DNSTask;
import jp.co.kingjim.tepraprint.sdk.nsd.util.DNSConstants;
import jp.co.kingjim.tepraprint.sdk.nsd.util.DNSRecordClass;
import jp.co.kingjim.tepraprint.sdk.nsd.util.DNSRecordType;
import jp.co.kingjim.tepraprint.sdk.nsd.util.DNSState;

public class NsdManager
implements Closeable,
DNSStatefulObject,
DNSTaskStarter {
    private volatile InetAddress group;
    private volatile MulticastSocket socket;
    private final List<DNSListener> listeners;
    private final ConcurrentMap<String, List<ListenerStatus.ServiceListenerStatus>> serviceListeners;
    private final DNSCache cache;
    private final ConcurrentMap<String, NsdServiceInfo> services;
    private final ConcurrentMap<String, ServiceTypeEntry> serviceTypes;
    protected Thread shutdown;
    private HostInfo localHost;
    private Thread incomingListener;
    private int throttle;
    private long lastThrottleIncrement;
    private final ExecutorService executor = Executors.newSingleThreadExecutor(new NamedThreadFactory("NsdManager"));
    private static final Random random = new Random();
    private final ReentrantLock ioLock = new ReentrantLock();
    private DNSIncoming plannedAnswer;
    private final ConcurrentMap<String, ServiceCollector> serviceCollectors;
    private final String name;
    private final Object recoverLock = new Object();

    public NsdManager(InetAddress address, String name) throws IOException {
        this.cache = new DNSCache(100);
        this.listeners = Collections.synchronizedList(new ArrayList());
        this.serviceListeners = new ConcurrentHashMap<String, List<ListenerStatus.ServiceListenerStatus>>();
        this.serviceCollectors = new ConcurrentHashMap<String, ServiceCollector>();
        this.services = new ConcurrentHashMap<String, NsdServiceInfo>(20);
        this.serviceTypes = new ConcurrentHashMap<String, ServiceTypeEntry>(20);
        this.localHost = HostInfo.newHostInfo(address, this, name);
        this.name = name != null ? name : this.localHost.getName();
        this.openMulticastSocket(this.getLocalHost());
        this.start(this.getServices().values());
        this.startReaper();
    }

    private void start(Collection<? extends NsdServiceInfo> serviceInfos) {
        if (this.incomingListener == null) {
            this.incomingListener = new SocketListener(this);
            this.incomingListener.start();
        }
        this.startProber();
        for (NsdServiceInfo nsdServiceInfo : serviceInfos) {
            try {
                this.registerService(new NsdServiceInfo(nsdServiceInfo));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void openMulticastSocket(HostInfo hostInfo) throws IOException {
        if (this.group == null) {
            this.group = hostInfo.getInetAddress() instanceof Inet6Address ? InetAddress.getByName("FF02::FB") : InetAddress.getByName("224.0.0.251");
        }
        if (this.socket != null) {
            this.closeMulticastSocket();
        }
        try {
            this.socket = new MulticastSocket(DNSConstants.MDNS_PORT);
            if (hostInfo != null && hostInfo.getNetworkInterface() != null) {
                try {
                    this.socket.setNetworkInterface(hostInfo.getNetworkInterface());
                }
                catch (SocketException e) {
                    e.printStackTrace();
                }
            }
            this.socket.setTimeToLive(255);
            this.socket.joinGroup(this.group);
        }
        catch (IOException ie) {
            if (this.socket != null) {
                try {
                    this.socket.leaveGroup(this.group);
                    this.socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.socket = null;
            }
            throw ie;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeMulticastSocket() {
        if (this.socket != null) {
            try {
                try {
                    this.socket.leaveGroup(this.group);
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
                this.socket.close();
                while (this.incomingListener != null && this.incomingListener.isAlive()) {
                    NsdManager nsdManager = this;
                    synchronized (nsdManager) {
                        try {
                            if (this.incomingListener != null && this.incomingListener.isAlive()) {
                                this.wait(1000L);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                this.incomingListener = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.socket = null;
        }
    }

    @Override
    public boolean advanceState(DNSTask task) {
        return this.localHost.advanceState(task);
    }

    @Override
    public boolean revertState() {
        return this.localHost.revertState();
    }

    @Override
    public boolean cancelState() {
        return this.localHost.cancelState();
    }

    @Override
    public boolean closeState() {
        return this.localHost.closeState();
    }

    @Override
    public boolean recoverState() {
        return this.localHost.recoverState();
    }

    @Override
    public NsdManager getDns() {
        return this;
    }

    @Override
    public void associateWithTask(DNSTask task, DNSState state) {
        this.localHost.associateWithTask(task, state);
    }

    @Override
    public void removeAssociationWithTask(DNSTask task) {
        this.localHost.removeAssociationWithTask(task);
    }

    @Override
    public boolean isAssociatedWithTask(DNSTask task, DNSState state) {
        return this.localHost.isAssociatedWithTask(task, state);
    }

    @Override
    public boolean isProbing() {
        return this.localHost.isProbing();
    }

    @Override
    public boolean isAnnouncing() {
        return this.localHost.isAnnouncing();
    }

    @Override
    public boolean isAnnounced() {
        return this.localHost.isAnnounced();
    }

    @Override
    public boolean isCanceling() {
        return this.localHost.isCanceling();
    }

    @Override
    public boolean isCanceled() {
        return this.localHost.isCanceled();
    }

    @Override
    public boolean isClosing() {
        return this.localHost.isClosing();
    }

    @Override
    public boolean isClosed() {
        return this.localHost.isClosed();
    }

    @Override
    public boolean waitForAnnounced(long timeout) {
        return this.localHost.waitForAnnounced(timeout);
    }

    @Override
    public boolean waitForCanceled(long timeout) {
        return this.localHost.waitForCanceled(timeout);
    }

    public NsdManager() throws IOException {
        this(null, null);
    }

    public NsdManager(InetAddress addr) throws IOException {
        this(addr, null);
    }

    public NsdManager(String name) throws IOException {
        this(null, name);
    }

    public DNSCache getCache() {
        return this.cache;
    }

    public String getName() {
        return this.name;
    }

    public String getHostName() {
        return this.localHost.getName();
    }

    public HostInfo getLocalHost() {
        return this.localHost;
    }

    public InetAddress getInetAddress() throws IOException {
        return this.localHost.getInetAddress();
    }

    public NsdServiceInfo getServiceInfo(String type, String name) {
        return this.getServiceInfo(type, name, false, 6000L);
    }

    public NsdServiceInfo getServiceInfo(String type, String name, long timeout) {
        return this.getServiceInfo(type, name, false, timeout);
    }

    public NsdServiceInfo getServiceInfo(String type, String name, boolean persistent) {
        return this.getServiceInfo(type, name, persistent, 6000L);
    }

    public NsdServiceInfo getServiceInfo(String type, String name, boolean persistent, long timeout) {
        NsdServiceInfo info = this.resolveServiceInfo(type, name, "", persistent);
        this.waitForInfoData(info, timeout);
        return info.hasData() ? info : null;
    }

    NsdServiceInfo resolveServiceInfo(String type, String name, String subtype, boolean persistent) {
        this.cleanCache();
        String loType = type.toLowerCase();
        if (this.serviceCollectors.putIfAbsent(loType, new ServiceCollector(type)) == null) {
            this.addServiceListener(loType, (ServiceListener)this.serviceCollectors.get(loType), true);
        }
        NsdServiceInfo info = this.getServiceInfoFromCache(type, name, subtype, persistent);
        this.startServiceInfoResolver(info);
        return info;
    }

    NsdServiceInfo getServiceInfoFromCache(String type, String name, String subtype, boolean persistent) {
        NsdServiceInfo cachedInfo;
        NsdServiceInfo info = new NsdServiceInfo(type, name, subtype, 0, 0, 0, persistent, (byte[])null);
        DNSEntry pointerEntry = this.getCache().getDNSEntry(new DNSRecord.Pointer(type, DNSRecordClass.CLASS_ANY, false, 0, info.getQualifiedName()));
        if (pointerEntry instanceof DNSRecord && (cachedInfo = ((DNSRecord)pointerEntry).getServiceInfo(persistent)) != null) {
            NsdServiceInfo nsdServiceInfo;
            NsdServiceInfo cachedAddressInfo;
            Iterator<? extends DNSEntry> cachedServiceEntryInfo;
            Map<NsdServiceInfo.Fields, String> map = cachedInfo.getQualifiedNameMap();
            byte[] srvBytes = null;
            String server = "";
            DNSEntry serviceEntry = this.getCache().getDNSEntry(info.getQualifiedName(), DNSRecordType.TYPE_SRV, DNSRecordClass.CLASS_ANY);
            if (serviceEntry instanceof DNSRecord && (cachedServiceEntryInfo = ((DNSRecord)serviceEntry).getServiceInfo(persistent)) != null) {
                cachedInfo = new NsdServiceInfo(map, ((NsdServiceInfo)((Object)cachedServiceEntryInfo)).getPort(), ((NsdServiceInfo)((Object)cachedServiceEntryInfo)).getWeight(), ((NsdServiceInfo)((Object)cachedServiceEntryInfo)).getPriority(), persistent, (byte[])null);
                srvBytes = ((NsdServiceInfo)((Object)cachedServiceEntryInfo)).getTextBytes();
                server = ((NsdServiceInfo)((Object)cachedServiceEntryInfo)).getServer();
            }
            for (DNSEntry dNSEntry : this.getCache().getDNSEntryList(server, DNSRecordType.TYPE_A, DNSRecordClass.CLASS_ANY)) {
                if (!(dNSEntry instanceof DNSRecord) || (cachedAddressInfo = ((DNSRecord)dNSEntry).getServiceInfo(persistent)) == null) continue;
                for (Inet4Address inet4Address : cachedAddressInfo.getInet4Addresses()) {
                    cachedInfo.addAddress(inet4Address);
                }
                cachedInfo._setText(cachedAddressInfo.getTextBytes());
            }
            for (DNSEntry dNSEntry : this.getCache().getDNSEntryList(server, DNSRecordType.TYPE_AAAA, DNSRecordClass.CLASS_ANY)) {
                if (!(dNSEntry instanceof DNSRecord) || (cachedAddressInfo = ((DNSRecord)dNSEntry).getServiceInfo(persistent)) == null) continue;
                for (InetAddress inetAddress : cachedAddressInfo.getInet6Addresses()) {
                    cachedInfo.addAddress((Inet6Address)inetAddress);
                }
                cachedInfo._setText(cachedAddressInfo.getTextBytes());
            }
            DNSEntry textEntry = this.getCache().getDNSEntry(cachedInfo.getQualifiedName(), DNSRecordType.TYPE_TXT, DNSRecordClass.CLASS_ANY);
            if (textEntry instanceof DNSRecord && (nsdServiceInfo = ((DNSRecord)textEntry).getServiceInfo(persistent)) != null) {
                cachedInfo._setText(nsdServiceInfo.getTextBytes());
            }
            if (cachedInfo.getTextBytes().length == 0) {
                cachedInfo._setText(srvBytes);
            }
            if (cachedInfo.hasData()) {
                info = cachedInfo;
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForInfoData(NsdServiceInfo info, long timeout) {
        NsdServiceInfo nsdServiceInfo = info;
        synchronized (nsdServiceInfo) {
            long loops = timeout / 200L;
            if (loops < 1L) {
                loops = 1L;
            }
            int i = 0;
            while ((long)i < loops && !info.hasData()) {
                try {
                    info.wait(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    public void requestServiceInfo(String type, String name) {
        this.requestServiceInfo(type, name, false, 6000L);
    }

    public void requestServiceInfo(String type, String name, boolean persistent) {
        this.requestServiceInfo(type, name, persistent, 6000L);
    }

    public void requestServiceInfo(String type, String name, long timeout) {
        this.requestServiceInfo(type, name, false, 6000L);
    }

    public void requestServiceInfo(String type, String name, boolean persistent, long timeout) {
        NsdServiceInfo info = this.resolveServiceInfo(type, name, "", persistent);
        this.waitForInfoData(info, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleServiceResolved(ServiceEvent event) {
        List list = (List)this.serviceListeners.get(event.getType().toLowerCase());
        if (list != null && !list.isEmpty() && event.getInfo() != null && event.getInfo().hasData()) {
            ArrayList listCopy;
            final ServiceEvent localEvent = event;
            List list2 = list;
            synchronized (list2) {
                listCopy = new ArrayList(list);
            }
            for (final ListenerStatus.ServiceListenerStatus listener : listCopy) {
                try {
                    if (this.executor.isShutdown()) continue;
                    this.executor.submit(new Runnable(){

                        @Override
                        public void run() {
                            listener.serviceResolved(localEvent);
                        }
                    });
                }
                catch (Exception exception) {}
            }
        }
    }

    public void addServiceListener(String type, ServiceListener listener) {
        this.addServiceListener(type, listener, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addServiceListener(String type, ServiceListener listener, boolean synch) {
        ListenerStatus.ServiceListenerStatus status = new ListenerStatus.ServiceListenerStatus(listener, synch);
        String loType = type.toLowerCase();
        List list = (List)this.serviceListeners.get(loType);
        if (list == null) {
            if (this.serviceListeners.putIfAbsent(loType, new LinkedList()) == null && this.serviceCollectors.putIfAbsent(loType, new ServiceCollector(type)) == null) {
                this.addServiceListener(loType, (ServiceListener)this.serviceCollectors.get(loType), true);
            }
            list = (List)this.serviceListeners.get(loType);
        }
        if (list != null) {
            List list2 = list;
            synchronized (list2) {
                if (!list.contains(listener)) {
                    list.add(status);
                }
            }
        }
        ArrayList<ServiceEvent> serviceEvents = new ArrayList<ServiceEvent>();
        Collection<DNSEntry> dnsEntryLits = this.getCache().allValues();
        for (DNSEntry entry : dnsEntryLits) {
            DNSRecord record = (DNSRecord)entry;
            if (record.getRecordType() != DNSRecordType.TYPE_SRV || !record.getKey().endsWith(loType)) continue;
            serviceEvents.add(new ServiceEvent(this, record.getType(), NsdManager.toUnqualifiedName(record.getType(), record.getName()), record.getServiceInfo()));
        }
        for (ServiceEvent serviceEvent : serviceEvents) {
            status.serviceAdded(serviceEvent);
        }
        this.startServiceResolver(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceListener(String type, ServiceListener listener) {
        String loType = type.toLowerCase();
        List list = (List)this.serviceListeners.get(loType);
        if (list != null) {
            List list2 = list;
            synchronized (list2) {
                ListenerStatus.ServiceListenerStatus status = new ListenerStatus.ServiceListenerStatus(listener, false);
                list.remove(status);
                if (list.isEmpty()) {
                    this.serviceListeners.remove(loType, list);
                }
            }
        }
    }

    public void registerService(NsdServiceInfo infoAbstract) throws IOException {
        if (this.isClosing() || this.isClosed()) {
            throw new IllegalStateException("This DNS is closed.");
        }
        NsdServiceInfo info = infoAbstract;
        if (info.getDns() != null) {
            if (info.getDns() != this) {
                throw new IllegalStateException("A service information can only be registered with a single instamce of NsdManager.");
            }
            if (this.services.get(info.getKey()) != null) {
                throw new IllegalStateException("A service information can only be registered once.");
            }
        }
        info.setDns(this);
        info.recoverState();
        info.setServer(this.localHost.getName());
        info.addAddress(this.localHost.getInet4Address());
        info.addAddress(this.localHost.getInet6Address());
        this.waitForAnnounced(6000L);
        this.makeServiceNameUnique(info);
        while (this.services.putIfAbsent(info.getKey(), info) != null) {
            this.makeServiceNameUnique(info);
        }
        this.startProber();
        info.waitForAnnounced(6000L);
    }

    public void unregisterService(NsdServiceInfo infoAbstract) {
        NsdServiceInfo info = (NsdServiceInfo)this.services.get(infoAbstract.getKey());
        if (info != null) {
            info.cancelState();
            this.startCanceler();
            info.waitForCanceled(5000L);
            this.services.remove(info.getKey(), info);
        }
    }

    public void unregisterAllServices() {
        NsdServiceInfo info;
        for (String name : this.services.keySet()) {
            info = (NsdServiceInfo)this.services.get(name);
            if (info == null) continue;
            info.cancelState();
        }
        this.startCanceler();
        for (String name : this.services.keySet()) {
            info = (NsdServiceInfo)this.services.get(name);
            if (info == null) continue;
            info.waitForCanceled(5000L);
            this.services.remove(name, info);
        }
    }

    private boolean makeServiceNameUnique(NsdServiceInfo info) {
        boolean collision;
        String originalQualifiedName = info.getKey();
        long now = System.currentTimeMillis();
        do {
            NsdServiceInfo selfService;
            collision = false;
            for (DNSEntry dNSEntry : this.getCache().getDNSEntryList(info.getKey())) {
                DNSRecord.Service s;
                if (!DNSRecordType.TYPE_SRV.equals((Object)dNSEntry.getRecordType()) || dNSEntry.isExpired(now) || (s = (DNSRecord.Service)dNSEntry).getPort() == info.getPort() && s.getServer().equals(this.localHost.getName())) continue;
                info.setName(NameRegister.Factory.getRegistry().incrementName(this.localHost.getInetAddress(), info.getName(), NameRegister.NameType.SERVICE));
                collision = true;
                break;
            }
            if ((selfService = (NsdServiceInfo)this.services.get(info.getKey())) == null || selfService == info) continue;
            info.setName(NameRegister.Factory.getRegistry().incrementName(this.localHost.getInetAddress(), info.getName(), NameRegister.NameType.SERVICE));
            collision = true;
        } while (collision);
        return !originalQualifiedName.equals(info.getKey());
    }

    public void addListener(DNSListener listener, DNSQuestion question) {
        long now = System.currentTimeMillis();
        this.listeners.add(listener);
        if (question != null) {
            for (DNSEntry dNSEntry : this.getCache().getDNSEntryList(question.getName().toLowerCase())) {
                if (!question.answeredBy(dNSEntry) || dNSEntry.isExpired(now)) continue;
                listener.updateRecord(this.getCache(), now, dNSEntry);
            }
        }
    }

    public void removeListener(DNSListener listener) {
        this.listeners.remove(listener);
    }

    public void renewServiceCollector(DNSRecord record) {
        NsdServiceInfo info = record.getServiceInfo();
        if (this.serviceCollectors.containsKey(info.getType().toLowerCase())) {
            this.startServiceResolver(info.getType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(long now, DNSRecord rec, Operation operation) {
        ArrayList<DNSListener> listenerList = null;
        List<DNSListener> list = this.listeners;
        synchronized (list) {
            listenerList = new ArrayList<DNSListener>(this.listeners);
        }
        for (DNSListener listener : listenerList) {
            listener.updateRecord(this.getCache(), now, rec);
        }
        if (DNSRecordType.TYPE_PTR.equals((Object)rec.getRecordType()) || DNSRecordType.TYPE_SRV.equals((Object)rec.getRecordType())) {
            List<ListenerStatus.ServiceListenerStatus> serviceListenerList;
            List list2;
            NsdServiceInfo info;
            ServiceEvent event = rec.getServiceEvent(this);
            if ((event.getInfo() == null || !event.getInfo().hasData()) && (info = this.getServiceInfoFromCache(event.getType(), event.getName(), "", false)).hasData()) {
                event = new ServiceEvent(this, event.getType(), event.getName(), info);
            }
            if ((list2 = (List)this.serviceListeners.get(event.getType().toLowerCase())) != null) {
                List list3 = list2;
                synchronized (list3) {
                    serviceListenerList = new ArrayList<ListenerStatus.ServiceListenerStatus>(list2);
                }
            } else {
                serviceListenerList = Collections.emptyList();
            }
            if (!serviceListenerList.isEmpty()) {
                final ServiceEvent localEvent = event;
                switch (operation) {
                    case Add: {
                        for (final ListenerStatus.ServiceListenerStatus listener : serviceListenerList) {
                            if (listener.isSynchronous()) {
                                listener.serviceAdded(localEvent);
                                continue;
                            }
                            try {
                                if (this.executor.isShutdown()) continue;
                                this.executor.submit(new Runnable(){

                                    @Override
                                    public void run() {
                                        listener.serviceAdded(localEvent);
                                    }
                                });
                            }
                            catch (Exception exception) {}
                        }
                        break;
                    }
                    case Remove: {
                        for (final ListenerStatus.ServiceListenerStatus listener : serviceListenerList) {
                            if (listener.isSynchronous()) {
                                listener.serviceRemoved(localEvent);
                                continue;
                            }
                            try {
                                if (this.executor.isShutdown()) continue;
                                this.executor.execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        listener.serviceRemoved(localEvent);
                                    }
                                });
                            }
                            catch (Exception exception) {}
                        }
                        break;
                    }
                }
            }
        }
    }

    void handleRecord(DNSRecord record, long now) {
        DNSRecord newRecord = record;
        Operation cacheOperation = Operation.Noop;
        boolean expired = newRecord.isExpired(now);
        if (!newRecord.isServicesDiscoveryMetaQuery() && !newRecord.isDomainDiscoveryQuery()) {
            boolean unique = newRecord.isUnique();
            DNSRecord cachedRecord = (DNSRecord)this.getCache().getDNSEntry(newRecord);
            if (unique) {
                for (DNSEntry dNSEntry : this.getCache().getDNSEntryList(newRecord.getKey())) {
                    if (!newRecord.getRecordType().equals((Object)dNSEntry.getRecordType()) || !newRecord.getRecordClass().equals((Object)dNSEntry.getRecordClass()) || dNSEntry == cachedRecord) continue;
                    ((DNSRecord)dNSEntry).setWillExpireSoon(now);
                }
            }
            if (cachedRecord != null) {
                if (expired) {
                    if (newRecord.getTTL() == 0) {
                        cacheOperation = Operation.Noop;
                        cachedRecord.setWillExpireSoon(now);
                    } else {
                        cacheOperation = Operation.Remove;
                        this.getCache().removeDNSEntry(cachedRecord);
                    }
                } else if (!newRecord.sameValue(cachedRecord) || !newRecord.sameSubtype(cachedRecord) && newRecord.getSubtype().length() > 0) {
                    if (newRecord.isSingleValued()) {
                        cacheOperation = Operation.Update;
                        this.getCache().replaceDNSEntry(newRecord, cachedRecord);
                    } else {
                        cacheOperation = Operation.Add;
                        this.getCache().addDNSEntry(newRecord);
                    }
                } else {
                    cachedRecord.resetTTL(newRecord);
                    newRecord = cachedRecord;
                }
            } else if (!expired) {
                cacheOperation = Operation.Add;
                this.getCache().addDNSEntry(newRecord);
            }
        }
        if (cacheOperation != Operation.Noop) {
            this.updateRecord(now, newRecord, cacheOperation);
        }
    }

    public void handleResponse(DNSIncoming msg) throws IOException {
        long now = System.currentTimeMillis();
        boolean hostConflictDetected = false;
        boolean serviceConflictDetected = false;
        for (DNSRecord dNSRecord : msg.getAllAnswers()) {
            this.handleRecord(dNSRecord, now);
            if (DNSRecordType.TYPE_A.equals((Object)dNSRecord.getRecordType()) || DNSRecordType.TYPE_AAAA.equals((Object)dNSRecord.getRecordType())) {
                hostConflictDetected |= dNSRecord.handleResponse(this);
                continue;
            }
            serviceConflictDetected |= dNSRecord.handleResponse(this);
        }
        if (hostConflictDetected || serviceConflictDetected) {
            this.startProber();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleQuery(DNSIncoming in, InetAddress addr, int port) throws IOException {
        boolean conflictDetected = false;
        long expirationTime = System.currentTimeMillis() + 120L;
        for (DNSRecord dNSRecord : in.getAllAnswers()) {
            conflictDetected |= dNSRecord.handleQuery(this, expirationTime);
        }
        this.ioLock();
        try {
            if (this.plannedAnswer != null) {
                this.plannedAnswer.append(in);
            } else {
                DNSIncoming plannedAnswer = in.clone();
                if (in.isTruncated()) {
                    // empty if block
                }
                this.startResponder(plannedAnswer, port);
            }
        }
        finally {
            this.ioUnlock();
        }
        long now = System.currentTimeMillis();
        for (DNSRecord dNSRecord : in.getAnswers()) {
            this.handleRecord(dNSRecord, now);
        }
        if (conflictDetected) {
            this.startProber();
        }
    }

    public void respondToQuery(DNSIncoming in) {
        this.ioLock();
        try {
            if (this.plannedAnswer == in) {
                this.plannedAnswer = null;
            }
        }
        finally {
            this.ioUnlock();
        }
    }

    public DNSOutgoing addAnswer(DNSIncoming in, InetAddress addr, int port, DNSOutgoing out, DNSRecord rec) throws IOException {
        DNSOutgoing newOut = out;
        if (newOut == null) {
            newOut = new DNSOutgoing(33792, false, in.getSenderUDPPayload());
        }
        try {
            newOut.addAnswer(in, rec);
        }
        catch (IOException e) {
            newOut.setFlags(newOut.getFlags() | 0x200);
            newOut.setId(in.getId());
            this.send(newOut);
            newOut = new DNSOutgoing(33792, false, in.getSenderUDPPayload());
            newOut.addAnswer(in, rec);
        }
        return newOut;
    }

    public void send(DNSOutgoing out) throws IOException {
        if (!out.isEmpty()) {
            byte[] message = out.data();
            DatagramPacket packet = new DatagramPacket(message, message.length, this.group, DNSConstants.MDNS_PORT);
            MulticastSocket ms = this.socket;
            if (ms != null && !ms.isClosed()) {
                ms.send(packet);
            }
        }
    }

    @Override
    public void purgeTimer() {
        DNSTaskStarter.Factory.getInstance().getStarter(this.getDns()).purgeTimer();
    }

    @Override
    public void purgeStateTimer() {
        DNSTaskStarter.Factory.getInstance().getStarter(this.getDns()).purgeStateTimer();
    }

    @Override
    public void cancelTimer() {
        DNSTaskStarter.Factory.getInstance().getStarter(this.getDns()).cancelTimer();
    }

    @Override
    public void cancelStateTimer() {
        DNSTaskStarter.Factory.getInstance().getStarter(this.getDns()).cancelStateTimer();
    }

    @Override
    public void startProber() {
        DNSTaskStarter.Factory.getInstance().getStarter(this.getDns()).startProber();
    }

    @Override
    public void startAnnouncer() {
        DNSTaskStarter.Factory.getInstance().getStarter(this.getDns()).startAnnouncer();
    }

    @Override
    public void startCanceler() {
        DNSTaskStarter.Factory.getInstance().getStarter(this.getDns()).startCanceler();
    }

    @Override
    public void startReaper() {
        DNSTaskStarter.Factory.getInstance().getStarter(this.getDns()).startReaper();
    }

    @Override
    public void startServiceInfoResolver(NsdServiceInfo info) {
        DNSTaskStarter.Factory.getInstance().getStarter(this.getDns()).startServiceInfoResolver(info);
    }

    @Override
    public void startServiceResolver(String type) {
        DNSTaskStarter.Factory.getInstance().getStarter(this.getDns()).startServiceResolver(type);
    }

    @Override
    public void startResponder(DNSIncoming in, int port) {
        DNSTaskStarter.Factory.getInstance().getStarter(this.getDns()).startResponder(in, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover() {
        if (this.isClosing() || this.isClosed() || this.isCanceling() || this.isCanceled()) {
            return;
        }
        Object object = this.recoverLock;
        synchronized (object) {
            if (this.cancelState()) {
                Thread recover = new Thread(this.getName() + ".recover()"){

                    @Override
                    public void run() {
                        NsdManager.this.__recover();
                    }
                };
                recover.start();
            }
        }
    }

    void __recover() {
        this.purgeTimer();
        ArrayList<NsdServiceInfo> oldServiceInfos = new ArrayList<NsdServiceInfo>(this.getServices().values());
        this.unregisterAllServices();
        this.disposeServiceCollectors();
        this.waitForCanceled(5000L);
        this.purgeStateTimer();
        this.closeMulticastSocket();
        this.getCache().clear();
        if (this.isCanceled()) {
            for (NsdServiceInfo info : oldServiceInfos) {
                info.recoverState();
            }
            this.recoverState();
            try {
                this.openMulticastSocket(this.getLocalHost());
                this.start(oldServiceInfos);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void cleanCache() {
        long now = System.currentTimeMillis();
        for (DNSEntry entry : this.getCache().allValues()) {
            try {
                DNSRecord record = (DNSRecord)entry;
                if (record.isExpired(now)) {
                    this.updateRecord(now, record, Operation.Remove);
                    this.getCache().removeDNSEntry(record);
                    continue;
                }
                if (!record.isStale(now)) continue;
                this.renewServiceCollector(record);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void close() {
        if (this.isClosing()) {
            return;
        }
        if (this.closeState()) {
            this.cancelTimer();
            this.unregisterAllServices();
            this.disposeServiceCollectors();
            this.waitForCanceled(1000L);
            this.cancelStateTimer();
            this.executor.shutdown();
            this.closeMulticastSocket();
            if (this.shutdown != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdown);
            }
            DNSTaskStarter.Factory.getInstance().disposeStarter(this.getDns());
        }
        this.advanceState(null);
    }

    public NsdServiceInfo[] list(String type) {
        return this.list(type, 6000L);
    }

    public NsdServiceInfo[] list(String type, long timeout) {
        this.cleanCache();
        String loType = type.toLowerCase();
        boolean newCollectorCreated = false;
        if (this.isCanceling() || this.isCanceled()) {
            System.out.println("NsdManager Cancelling.");
            return new NsdServiceInfo[0];
        }
        ServiceCollector collector = (ServiceCollector)this.serviceCollectors.get(loType);
        if (collector == null) {
            newCollectorCreated = this.serviceCollectors.putIfAbsent(loType, new ServiceCollector(type)) == null;
            collector = (ServiceCollector)this.serviceCollectors.get(loType);
            if (newCollectorCreated) {
                this.addServiceListener(type, collector, true);
            }
        }
        return collector != null ? collector.list(timeout) : new NsdServiceInfo[]{};
    }

    public Map<String, NsdServiceInfo[]> listBySubtype(String type) {
        return this.listBySubtype(type, 6000L);
    }

    public Map<String, NsdServiceInfo[]> listBySubtype(String type, long timeout) {
        HashMap map = new HashMap(5);
        for (NsdServiceInfo info : this.list(type, timeout)) {
            String subtype = info.getSubtype().toLowerCase();
            if (!map.containsKey(subtype)) {
                map.put(subtype, new ArrayList(10));
            }
            ((List)map.get(subtype)).add(info);
        }
        HashMap<String, NsdServiceInfo[]> result = new HashMap<String, NsdServiceInfo[]>(map.size());
        for (String subtype : map.keySet()) {
            List infoForSubType = (List)map.get(subtype);
            result.put(subtype, infoForSubType.toArray(new NsdServiceInfo[infoForSubType.size()]));
        }
        return result;
    }

    private void disposeServiceCollectors() {
        for (String type : this.serviceCollectors.keySet()) {
            ServiceCollector collector = (ServiceCollector)this.serviceCollectors.get(type);
            if (collector == null) continue;
            this.removeServiceListener(type, collector);
            this.serviceCollectors.remove(type, collector);
        }
    }

    public static String toUnqualifiedName(String type, String qualifiedName) {
        String loType = type.toLowerCase();
        String loQualifiedName = qualifiedName.toLowerCase();
        if (loQualifiedName.endsWith(loType) && !loQualifiedName.equals(loType)) {
            return qualifiedName.substring(0, qualifiedName.length() - type.length() - 1);
        }
        return qualifiedName;
    }

    public void setLastThrottleIncrement(long lastThrottleIncrement) {
        this.lastThrottleIncrement = lastThrottleIncrement;
    }

    public long getLastThrottleIncrement() {
        return this.lastThrottleIncrement;
    }

    public void setThrottle(int throttle) {
        this.throttle = throttle;
    }

    public int getThrottle() {
        return this.throttle;
    }

    public static Random getRandom() {
        return random;
    }

    public void ioLock() {
        this.ioLock.lock();
    }

    public void ioUnlock() {
        this.ioLock.unlock();
    }

    public Map<String, NsdServiceInfo> getServices() {
        return this.services;
    }

    public Map<String, ServiceTypeEntry> getServiceTypes() {
        return this.serviceTypes;
    }

    public MulticastSocket getSocket() {
        return this.socket;
    }

    public InetAddress getGroup() {
        return this.group;
    }

    public class NamedThreadFactory
    implements ThreadFactory {
        private final ThreadFactory delegate;
        private final String namePrefix;

        public NamedThreadFactory(String namePrefix) {
            this.namePrefix = namePrefix;
            this.delegate = Executors.defaultThreadFactory();
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = this.delegate.newThread(runnable);
            thread.setName(this.namePrefix + ' ' + thread.getName());
            return thread;
        }
    }

    private static class ServiceCollector
    implements ServiceListener {
        private final ConcurrentMap<String, NsdServiceInfo> infos = new ConcurrentHashMap<String, NsdServiceInfo>();
        private final ConcurrentMap<String, ServiceEvent> events = new ConcurrentHashMap<String, ServiceEvent>();
        private final String type;
        private volatile boolean needToWaitForInfos;

        public ServiceCollector(String type) {
            this.type = type;
            this.needToWaitForInfos = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serviceAdded(ServiceEvent event) {
            ServiceCollector serviceCollector = this;
            synchronized (serviceCollector) {
                NsdServiceInfo info = event.getInfo();
                if (info != null && info.hasData()) {
                    this.infos.put(event.getName(), info);
                } else {
                    String subtype = info != null ? info.getSubtype() : "";
                    info = event.getDNS().resolveServiceInfo(event.getType(), event.getName(), subtype, true);
                    if (info != null) {
                        this.infos.put(event.getName(), info);
                    } else {
                        this.events.put(event.getName(), event);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serviceRemoved(ServiceEvent event) {
            ServiceCollector serviceCollector = this;
            synchronized (serviceCollector) {
                this.infos.remove(event.getName());
                this.events.remove(event.getName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serviceResolved(ServiceEvent event) {
            ServiceCollector serviceCollector = this;
            synchronized (serviceCollector) {
                this.infos.put(event.getName(), event.getInfo());
                this.events.remove(event.getName());
            }
        }

        public NsdServiceInfo[] list(long timeout) {
            if (this.infos.isEmpty() || !this.events.isEmpty() || this.needToWaitForInfos) {
                long loops = timeout / 200L;
                if (loops < 1L) {
                    loops = 1L;
                }
                int i = 0;
                while ((long)i < loops) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.events.isEmpty() && !this.infos.isEmpty() && !this.needToWaitForInfos) break;
                    ++i;
                }
            }
            this.needToWaitForInfos = false;
            return this.infos.values().toArray(new NsdServiceInfo[this.infos.size()]);
        }
    }

    public static enum Operation {
        Remove,
        Update,
        Add,
        RegisterServiceType,
        Noop;

    }

    public static class ServiceTypeEntry
    extends AbstractMap<String, String>
    implements Cloneable {
        private final Set<Map.Entry<String, String>> entrySet;
        private final String type;

        public ServiceTypeEntry(String type) {
            this.type = type;
            this.entrySet = new HashSet<Map.Entry<String, String>>();
        }

        public String getType() {
            return this.type;
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return this.entrySet;
        }

        public boolean contains(String subtype) {
            return subtype != null && this.containsKey(subtype.toLowerCase());
        }

        public boolean add(String subtype) {
            if (subtype == null || this.contains(subtype)) {
                return false;
            }
            this.entrySet.add(new SubTypeEntry(subtype));
            return true;
        }

        public Iterator<String> iterator() {
            return this.keySet().iterator();
        }

        @Override
        public ServiceTypeEntry clone() {
            ServiceTypeEntry entry = new ServiceTypeEntry(this.getType());
            for (Map.Entry<String, String> subTypeEntry : this.entrySet()) {
                entry.add(subTypeEntry.getValue());
            }
            return entry;
        }

        private static class SubTypeEntry
        implements Map.Entry<String, String>,
        Serializable,
        Cloneable {
            private static final long serialVersionUID = 1L;
            private final String key;
            private final String value;

            public SubTypeEntry(String subtype) {
                this.value = subtype != null ? subtype : "";
                this.key = this.value.toLowerCase();
            }

            @Override
            public String getKey() {
                return this.key;
            }

            @Override
            public String getValue() {
                return this.value;
            }

            @Override
            public String setValue(String value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean equals(Object entry) {
                if (!(entry instanceof Map.Entry)) {
                    return false;
                }
                return this.getKey().equals(((Map.Entry)entry).getKey()) && this.getValue().equals(((Map.Entry)entry).getValue());
            }

            @Override
            public int hashCode() {
                return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
            }

            public SubTypeEntry clone() {
                return this;
            }
        }
    }
}

