/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.formdata;

import android.text.TextUtils;
import android.text.format.Time;
import android.util.Base64;
import android.util.Xml;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class PlistParser {
    private static final String TagPlist = "plist";
    private static final String TagDict = "dict";
    private static final String TagKey = "key";
    private static final String TagArray = "array";
    private static final String TagString = "string";
    private static final String TagInteger = "integer";
    private static final String TagReal = "real";
    private static final String TagData = "data";
    private static final String TagDate = "date";
    private static final String TagTrue = "true";
    private static final String TagFalse = "false";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object parse(InputStream is, boolean closeWhenDone) {
        Object parsedObj = null;
        try {
            XmlPullParser xmlParser = Xml.newPullParser();
            xmlParser.setInput(is, "UTF-8");
            while (!TextUtils.equals((CharSequence)xmlParser.getName(), (CharSequence)TagPlist)) {
                xmlParser.next();
            }
            xmlParser.next();
            PlistParser.moveToNextTag(xmlParser);
            parsedObj = PlistParser.parseRecursively(xmlParser);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (closeWhenDone) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return parsedObj;
    }

    private static Object parseRecursively(XmlPullParser xmlParser) {
        Object parsedObj = null;
        try {
            int event = xmlParser.getEventType();
            if (event != 2) {
                return null;
            }
            String tag = xmlParser.getName();
            if (TextUtils.equals((CharSequence)tag, (CharSequence)TagDict)) {
                parsedObj = PlistParser.parseDict(xmlParser);
            } else if (TextUtils.equals((CharSequence)tag, (CharSequence)TagArray)) {
                parsedObj = PlistParser.parseArray(xmlParser);
            } else {
                String text = PlistParser.getText(xmlParser, tag);
                if (TextUtils.equals((CharSequence)tag, (CharSequence)TagString)) {
                    parsedObj = text;
                } else if (TextUtils.equals((CharSequence)tag, (CharSequence)TagInteger)) {
                    parsedObj = Float.valueOf(Float.parseFloat(text));
                } else if (TextUtils.equals((CharSequence)tag, (CharSequence)TagReal)) {
                    parsedObj = Float.valueOf(Float.parseFloat(text));
                } else if (TextUtils.equals((CharSequence)tag, (CharSequence)TagData)) {
                    parsedObj = Base64.decode((String)text, (int)0);
                } else if (TextUtils.equals((CharSequence)tag, (CharSequence)TagDate)) {
                    Time date = new Time();
                    date.parse(text.replaceAll("[:-]", ""));
                    parsedObj = date;
                } else if (TextUtils.equals((CharSequence)tag, (CharSequence)TagTrue) || TextUtils.equals((CharSequence)tag, (CharSequence)TagFalse)) {
                    parsedObj = Boolean.parseBoolean(tag);
                }
            }
            PlistParser.moveToNextTag(xmlParser);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return parsedObj;
    }

    private static Map<String, Object> parseDict(XmlPullParser xmlParser) throws Exception {
        HashMap<String, Object> parsedMap = new HashMap<String, Object>();
        xmlParser.next();
        if (!PlistParser.moveToNextTag(xmlParser)) {
            return null;
        }
        int currentDepth = xmlParser.getDepth();
        while (xmlParser.getDepth() == currentDepth) {
            String key = PlistParser.getText(xmlParser, TagKey);
            Object value = PlistParser.parseRecursively(xmlParser);
            if (key == null || value == null) continue;
            parsedMap.put(key, value);
        }
        return parsedMap;
    }

    private static List<Object> parseArray(XmlPullParser xmlParser) throws Exception {
        ArrayList<Object> parsedList = new ArrayList<Object>();
        xmlParser.next();
        if (!PlistParser.moveToNextTag(xmlParser)) {
            return null;
        }
        int currentDepth = xmlParser.getDepth();
        while (xmlParser.getDepth() == currentDepth) {
            Object value = PlistParser.parseRecursively(xmlParser);
            if (value == null) continue;
            parsedList.add(value);
        }
        return parsedList;
    }

    private static String getText(XmlPullParser xmlParser, String tag) {
        String text = null;
        try {
            int startEvent = xmlParser.getEventType();
            String tagName = xmlParser.getName();
            if (!TextUtils.equals((CharSequence)tagName, (CharSequence)tag) || startEvent != 2) {
                return null;
            }
            try {
                int valueEvent = xmlParser.next();
                if (valueEvent != 4) {
                    return null;
                }
                text = xmlParser.getText();
            }
            catch (XmlPullParserException e) {
                e.printStackTrace();
            }
            int endEvent = xmlParser.next();
            PlistParser.moveToNextTag(xmlParser);
            if (!TextUtils.equals((CharSequence)tagName, (CharSequence)tag) || endEvent != 3) {
                return null;
            }
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return text;
    }

    private static boolean moveToNextTag(XmlPullParser xmlParser) {
        int event = 0;
        try {
            event = xmlParser.getEventType();
            while (event != 2 && event != 1) {
                event = xmlParser.next();
            }
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return event != 1;
    }
}

