/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.formdata;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import java.util.List;
import java.util.Map;
import jp.co.kingjim.tepraprint.sdk.formdata.ObjectData;
import jp.co.kingjim.tepraprint.sdk.formdata.ObjectDataString;

public class ObjectDataVerticalString
extends ObjectDataString {
    public ObjectDataVerticalString(Map<String, Object> objectInfo, Map<String, Object> contextInfo) {
        super(objectInfo, contextInfo);
        if (this.getLineBreakMode() == ObjectData.LineBreakMode.Paragraph) {
            this.setLineBreakMode(ObjectData.LineBreakMode.Clip);
        }
    }

    @Override
    protected final RectF getContentBounds() {
        RectF contentBounds = this.getBounds();
        float border = this.getBorderArea(this.getTapeWidth());
        float dy = Math.min(border, contentBounds.height());
        contentBounds.inset(0.0f, dy / 2.0f);
        return contentBounds;
    }

    @Override
    protected ObjectData.SizeF determineContentSize() {
        String text;
        ObjectData.SizeF size = this.getContentSize();
        if (this.getLineBreakMode() == ObjectData.LineBreakMode.Stretch && (text = this.getStringContent()) != null) {
            Paint paint = this.getTextPaint();
            float inset = this.getBorderArea(this.getTapeWidth());
            float actualTextHeight = paint.getFontMetrics().bottom - paint.getFontMetrics().top;
            float boldOffset = actualTextHeight * this.getBoldOffsetRate() * 2.0f;
            float lineWidth = (actualTextHeight + boldOffset) * (float)text.length() * 11.0f / 12.0f + inset * 2.0f;
            size.width = Math.max(size.width, lineWidth);
        }
        return size;
    }

    @Override
    protected void drawTextLines(Canvas canvas, List<String> textLines, Paint paint) {
        String line = textLines.get(0);
        if (line == null) {
            return;
        }
        RectF textBounds = this.getTextBounds(paint);
        canvas.save();
        RectF contentBounds = this.getContentBounds();
        canvas.clipRect(contentBounds);
        float charHeight = paint.getTextSize();
        float lineHeight = Math.max(textBounds.height(), charHeight);
        float gapY = (paint.getFontMetrics().top + paint.getFontMetrics().bottom) / 2.0f;
        float centerY = textBounds.top + lineHeight / 2.0f;
        float baseY = textBounds.top + lineHeight / 2.0f - gapY;
        float verticalHeight = charHeight * (float)line.length();
        float offsetX = 0.0f;
        if (this.mLineBreakMode != ObjectData.LineBreakMode.Stretch) {
            if (this.getTextAlignment() == ObjectData.TextAlignment.Center) {
                offsetX = (contentBounds.width() - verticalHeight) / 2.0f;
            } else if (this.getTextAlignment() == ObjectData.TextAlignment.Right) {
                offsetX = contentBounds.width() - verticalHeight;
            }
        }
        float nextX = paint.getFontMetrics().bottom + offsetX;
        ObjectData.SizeF contentSize = this.determineContentSize();
        if ((float)contentSize.degree != 0.0f) {
            float degree = contentSize.degree;
            float axisX = (textBounds.right + textBounds.left) / 2.0f;
            float axisY = (textBounds.top + textBounds.bottom) / 2.0f;
            canvas.rotate(degree, axisX, axisY);
        }
        for (char ch : line.toCharArray()) {
            String chString = String.valueOf(ch);
            Rect chBounds = new Rect();
            paint.getTextBounds(chString, 0, 1, chBounds);
            float centerX = textBounds.left + nextX + (float)chBounds.left + (float)(chBounds.width() / 2);
            canvas.rotate(-90.0f, centerX, centerY);
            canvas.drawText(chString, textBounds.left + nextX, baseY + (float)((chBounds.height() - chBounds.width()) / 2), paint);
            canvas.rotate(90.0f, centerX, centerY);
            nextX += paint.getFontMetrics().descent - paint.getFontMetrics().ascent;
        }
        canvas.restore();
    }

    @Override
    protected RectF getTextBounds(Paint textPaint) {
        RectF textBounds = this.getContentBounds();
        if (textPaint != null) {
            float boldOffsetX = (textPaint.getFontMetrics().bottom - textPaint.getFontMetrics().top) * this.getBoldOffsetRate();
            textBounds.inset(boldOffsetX, 0.0f);
        }
        return textBounds;
    }
}

