/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.formdata;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import java.util.HashMap;
import java.util.Map;
import jp.co.kingjim.tepraprint.sdk.TepraPrintDataProvider;
import jp.co.kingjim.tepraprint.sdk.TepraPrintProductInformation;
import jp.co.kingjim.tepraprint.sdk.formdata.ObjectData;
import jp.co.kingjim.tepraprint.sdk.formdata.ObjectDataFactory;
import jp.co.kingjim.tepraprint.sdk.formdata.ObjectDataSecondFrame;
import jp.co.kingjim.tepraprint.sdk.formdata.Utils;

public class ObjectDataTopFrame
extends ObjectData {
    private float mLength = 0.0f;
    private float mPrintableArea;
    private ObjectData.Margins mMargins;
    private float mMarginsValue;
    private boolean mTapeLengthAuto = false;
    private ObjectDataSecondFrame mSecondFrame;

    public ObjectDataTopFrame(Map<String, Object> objectInfo, Map<String, Object> contextInfo, TepraPrintDataProvider provider) {
        super(objectInfo, contextInfo);
        float borderArea;
        float secondFrameWidth;
        Float marginsValue;
        int resolution = this.getResolution();
        Boolean tapeLengthAuto = (Boolean)objectInfo.get("TepraTapeLengthAuto");
        if (tapeLengthAuto != null) {
            this.mTapeLengthAuto = tapeLengthAuto;
        }
        Float lengthInch = (Float)objectInfo.get("TepraLengthInch");
        Float lengthMM = (Float)objectInfo.get("TepraLengthMM");
        if (lengthInch != null) {
            this.mLength = lengthInch.floatValue() * (float)resolution;
        }
        if (lengthMM != null) {
            this.mLength = lengthMM.floatValue() / 25.4f * (float)resolution;
        }
        int tapeWidth = this.getTapeWidth();
        int modelNumber = this.getModelNumber();
        this.mPrintableArea = TepraPrintProductInformation.getPrintableSize(tapeWidth, resolution, modelNumber);
        String marginsStr = (String)objectInfo.get("TepraMargins");
        this.mMargins = Utils.getEnumValue(ObjectData.Margins.class, marginsStr);
        if (this.mMargins == null) {
            this.mMargins = ObjectData.Margins.Standard;
        }
        if ((marginsValue = (Float)objectInfo.get("TepraMarginsValue")) == null) {
            marginsValue = Float.valueOf(0.0f);
        }
        float marginsValueMin = 0.03937008f * (float)resolution;
        float marginsValueStd = 0.39370078f * (float)resolution;
        float marginsValueMax = 0.8267717f * (float)resolution;
        switch (this.mMargins) {
            case Minimum: {
                this.mMarginsValue = marginsValueMin;
                break;
            }
            case Large: {
                this.mMarginsValue = marginsValueMax;
                break;
            }
            case NumberInch: {
                this.mMarginsValue = marginsValue.floatValue() * (float)resolution;
                break;
            }
            case NumberMM: {
                this.mMarginsValue = marginsValue.floatValue() / 25.4f * (float)resolution;
                break;
            }
            default: {
                this.mMarginsValue = marginsValueStd;
            }
        }
        if (this.mMarginsValue < marginsValueMin || marginsValueMax < this.mMarginsValue) {
            this.mMarginsValue = marginsValueStd;
        }
        if (this.mLength < this.mMarginsValue) {
            this.mLength = this.mMarginsValue;
        }
        HashMap<String, Object> contextForChild = new HashMap<String, Object>();
        if (contextInfo != null) {
            contextForChild.putAll(contextInfo);
        }
        if ((secondFrameWidth = this.mLength - this.mMarginsValue * 2.0f - (borderArea = this.getBorderArea(this.getTapeWidth()))) < 0.0f) {
            secondFrameWidth = 0.0f;
        }
        contextForChild.put("ObjectParameterBaseWidth", Float.valueOf(secondFrameWidth));
        float secondFrameHeight = this.mPrintableArea - borderArea;
        if (secondFrameHeight < 0.0f) {
            secondFrameHeight = 0.0f;
        }
        contextForChild.put("ObjectParameterBaseHeight", Float.valueOf(secondFrameHeight));
        contextForChild.put("ObjectParameterSizeMode", (Object)this.getFrameSizeMode());
        contextForChild.put("ObjectParameterShowFrame", true);
        ObjectDataFactory factory = new ObjectDataFactory(provider);
        this.mSecondFrame = new ObjectDataSecondFrame(objectInfo, contextForChild, factory);
        this.mSecondFrame.setParentDrawAreaType(this.drawAreaType);
    }

    public RectF getCurrentBounds() {
        return this.getBounds();
    }

    public float getMarginsValue() {
        return this.mMarginsValue;
    }

    @Override
    public void setPage(int pageIndex) {
        this.mSecondFrame.setPage(pageIndex);
        super.setPage(pageIndex);
        ObjectData.SizeF determinedSize = this.getDeterminedContentSize();
        this.setBounds(new RectF(0.0f, 0.0f, determinedSize.width, determinedSize.height));
    }

    @Override
    protected ObjectData.SizeF determineContentSize() {
        ObjectData.SizeF secondFrameSize = this.mSecondFrame.getDeterminedContentSize();
        ObjectData.SizeF frameSize = new ObjectData.SizeF();
        frameSize.height = this.mPrintableArea;
        if (this.mTapeLengthAuto) {
            float borderArea = this.getBorderArea(this.getTapeWidth());
            frameSize.width = borderArea + this.mMarginsValue * 2.0f + secondFrameSize.width;
        } else {
            frameSize.width = this.mLength;
        }
        frameSize.width = Math.min(frameSize.width, this.getMaxTapeLength());
        return frameSize;
    }

    @Override
    protected void setBounds(RectF bounds) {
        super.setBounds(bounds);
        float borderArea = this.getBorderArea(this.getTapeWidth());
        float offsetX = borderArea / 2.0f + this.mMarginsValue;
        float offsetY = borderArea / 2.0f;
        ObjectData.SizeF frameSize = this.mSecondFrame.getDeterminedContentSize();
        RectF secondFrameRect = new RectF(offsetX, offsetY, offsetX + frameSize.width, offsetY + frameSize.height - 1.0f);
        this.mSecondFrame.setBounds(secondFrameRect);
    }

    @Override
    public void drawContent(Canvas canvas) {
        if (this.mSecondFrame != null) {
            this.mSecondFrame.drawContent(canvas);
        }
        Paint clearPaint = new Paint();
        clearPaint.setColor(-1);
        clearPaint.setStyle(Paint.Style.FILL);
        RectF bounds = this.getBounds();
        RectF leftMarginRect = new RectF(0.0f, 0.0f, this.mMarginsValue, bounds.height());
        canvas.drawRect(leftMarginRect, clearPaint);
        RectF rightMarginRect = new RectF(bounds.width() - this.mMarginsValue, 0.0f, bounds.width(), bounds.height());
        canvas.drawRect(rightMarginRect, clearPaint);
    }
}

