/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.formdata;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.co.kingjim.tepraprint.sdk.formdata.ObjectData;
import jp.co.kingjim.tepraprint.sdk.formdata.Utils;

public class ObjectDataString
extends ObjectData {
    private static final String NewLineExpression = "\n|\r\n|\r";
    private static final float ItalicTextSkew = -0.25f;
    private static final int PointPerInch = 72;
    private ObjectData.FontSize mFontSize;
    private Float mFontPointValue;
    private boolean mIsItalic;
    private boolean mIsBold;
    private ObjectData.TextAlignment mTextAlignment;
    protected ObjectData.LineBreakMode mLineBreakMode;
    private Typeface mTypeface;

    public ObjectDataString(Map<String, Object> objectInfo, Map<String, Object> contextInfo) {
        super(objectInfo, contextInfo);
        String typeFaceStr;
        ObjectData.TypeFace typeFace;
        Boolean isBold;
        String fontSizeStr = (String)objectInfo.get("TepraFontSize");
        this.mFontSize = Utils.getEnumValue(ObjectData.FontSize.class, fontSizeStr);
        if (this.mFontSize == null) {
            this.mFontSize = ObjectData.FontSize.Large;
        } else if (this.mFontSize == ObjectData.FontSize.Point) {
            if (objectInfo.get("TepraFontPointValue") != null) {
                this.mFontPointValue = (Float)objectInfo.get("TepraFontPointValue");
                if (this.mFontPointValue.floatValue() < 4.0f) {
                    this.mFontPointValue = Float.valueOf(4.0f);
                } else if (this.mFontPointValue.floatValue() > 100.0f) {
                    this.mFontPointValue = Float.valueOf(100.0f);
                }
            } else {
                this.mFontSize = ObjectData.FontSize.Large;
            }
        }
        Boolean isItalic = (Boolean)objectInfo.get("TepraFontItalic");
        if (isItalic != null) {
            this.mIsItalic = isItalic;
        }
        if ((isBold = (Boolean)objectInfo.get("TepraFontBold")) != null) {
            this.mIsBold = isBold;
        }
        String textAlignmentStr = (String)objectInfo.get("TepraTextAlignment");
        this.mTextAlignment = Utils.getEnumValue(ObjectData.TextAlignment.class, textAlignmentStr);
        if (this.mTextAlignment == null) {
            this.mTextAlignment = ObjectData.TextAlignment.Left;
        }
        String lineBreakStr = (String)objectInfo.get("TepraLineBreakMode");
        this.mLineBreakMode = Utils.getEnumValue(ObjectData.LineBreakMode.class, lineBreakStr);
        if (this.mLineBreakMode == null) {
            this.mLineBreakMode = ObjectData.LineBreakMode.Reduction;
        }
        if (this.mFontSize == ObjectData.FontSize.Point && this.mLineBreakMode == ObjectData.LineBreakMode.Reduction) {
            this.mLineBreakMode = ObjectData.LineBreakMode.Clip;
        }
        if ((typeFace = Utils.getEnumValue(ObjectData.TypeFace.class, typeFaceStr = (String)objectInfo.get("TepraTypeFace"))) == null) {
            typeFace = ObjectData.TypeFace.DEFAULT;
        }
        switch (typeFace) {
            case DEFAULT: {
                this.mTypeface = Typeface.DEFAULT;
                break;
            }
            case DEFAULTBOLD: {
                this.mTypeface = Typeface.DEFAULT_BOLD;
                break;
            }
            case MONOSPACE: {
                this.mTypeface = Typeface.MONOSPACE;
                break;
            }
            case SANSSERIF: {
                this.mTypeface = Typeface.SANS_SERIF;
                break;
            }
            case SERIF: {
                this.mTypeface = Typeface.SERIF;
            }
        }
    }

    @Override
    public void drawContent(Canvas canvas) {
        super.drawContent(canvas);
        RectF bounds = this.getContentBounds();
        if (bounds.width() < this.getMinTextSize() || bounds.height() < this.getMinTextSize()) {
            return;
        }
        String text = this.getStringContent();
        if (text == null) {
            return;
        }
        List<String> textLines = Arrays.asList(text.split(NewLineExpression));
        switch (this.mLineBreakMode) {
            case Clip: 
            case Stretch: {
                this.drawSimpleText(canvas, textLines);
                break;
            }
            case Paragraph: {
                this.drawParagraphText(canvas, textLines);
                break;
            }
            case Reduction: {
                this.drawReductionText(canvas, textLines);
            }
        }
    }

    protected final ObjectData.TextAlignment getTextAlignment() {
        return this.mTextAlignment;
    }

    protected final ObjectData.LineBreakMode getLineBreakMode() {
        return this.mLineBreakMode;
    }

    protected void setLineBreakMode(ObjectData.LineBreakMode lineBreakMode) {
        this.mLineBreakMode = lineBreakMode;
    }

    @Override
    protected RectF getContentBounds() {
        RectF contentBounds = this.getBounds();
        float border = this.getBorderArea(this.getTapeWidth());
        float dx = Math.min(border, contentBounds.width());
        float dy = Math.min(border, contentBounds.height());
        contentBounds.inset(dx / 2.0f, dy / 2.0f);
        return contentBounds;
    }

    @Override
    protected ObjectData.SizeF determineContentSize() {
        String text;
        ObjectData.SizeF size = this.getContentSize();
        if (this.mLineBreakMode == ObjectData.LineBreakMode.Stretch && (text = this.getStringContent()) != null) {
            Paint paint = this.getTextPaint();
            String[] lines = text.split(NewLineExpression);
            float textSize = paint.getTextSize() / (float)lines.length;
            textSize = Math.max(textSize, this.getMinTextSize());
            paint.setTextSize(textSize);
            float inset = this.getBorderArea(this.getTapeWidth());
            float actualTextHeight = paint.descent() - paint.ascent();
            float skewOffset = actualTextHeight * this.getSkewOffsetRate();
            float boldOffset = actualTextHeight * this.getBoldOffsetRate() * 2.0f;
            for (String line : lines) {
                float lineWidth = paint.measureText(line) + inset * 2.0f + skewOffset + boldOffset;
                size.width = Math.max(size.width, lineWidth);
            }
        }
        return size;
    }

    protected Paint getTextPaint() {
        float inset = this.getBorderArea(this.getTapeWidth());
        ObjectData.SizeF size = this.getContentSize();
        float fontSize = size.height - inset * 2.0f;
        switch (this.mFontSize) {
            case Large: {
                break;
            }
            case Medium: {
                fontSize /= 1.4142135f;
                break;
            }
            case Small: {
                fontSize /= 2.0f;
                break;
            }
            case Point: {
                if (this.mFontPointValue == null) break;
                fontSize = this.mFontPointValue.floatValue() * 1.3333334f * (float)this.getResolution() / 72.0f;
                break;
            }
        }
        float textSize = fontSize > 0.0f ? this.getTextSize(fontSize, this.mIsBold, this.mTypeface) : this.getMinTextSize();
        Paint paint = new Paint();
        paint.setTextSize(textSize);
        paint.setTextSkewX(this.mIsItalic ? -0.25f : 0.0f);
        paint.setFakeBoldText(this.mIsBold);
        paint.setTypeface(this.mTypeface);
        return paint;
    }

    private float getTextSize(float height, boolean isFakeBold, Typeface typeface) {
        Paint paint = new Paint();
        paint.setFakeBoldText(isFakeBold);
        paint.setTypeface(typeface);
        float textSize = height;
        paint.setTextSize(textSize);
        float actualHeight = paint.descent() - paint.ascent();
        while (actualHeight > height) {
            paint.setTextSize(textSize *= 0.975f);
            actualHeight = paint.descent() - paint.ascent();
        }
        return textSize;
    }

    private void drawSimpleText(Canvas canvas, List<String> textLines) {
        Paint paint = this.getTextPaint();
        float textSize = paint.getTextSize() / (float)textLines.size();
        textSize = Math.max(textSize, this.getMinTextSize());
        paint.setTextSize(textSize);
        this.drawTextLines(canvas, textLines, paint);
    }

    private void drawParagraphText(Canvas canvas, List<String> textLines) {
        Paint paint = this.getTextPaint();
        int lineCount = textLines.size();
        float textSize = paint.getTextSize() / (float)lineCount;
        paint.setTextSize(textSize);
        float paragraphHeight = this.getParagraphTextHeight(textLines, paint);
        RectF bounds = this.getTextBounds(paint);
        float minTextSize = this.getMinTextSize();
        while (paragraphHeight > bounds.height() && textSize >= minTextSize) {
            paint.setTextSize(textSize *= 0.975f);
            paragraphHeight = this.getParagraphTextHeight(textLines, paint);
        }
        textSize = Math.max(textSize, minTextSize);
        paint.setTextSize(textSize);
        List<String> paragraphTexts = this.splitParagraphText(textLines, paint);
        this.drawTextLines(canvas, paragraphTexts, paint);
    }

    private void drawReductionText(Canvas canvas, List<String> textLines) {
        Paint paint = this.getTextPaint();
        int lineCount = textLines.size();
        float textSize = paint.getTextSize() / (float)lineCount;
        paint.setTextSize(textSize);
        ObjectData.SizeF size = this.getReductionTextSize(textLines, paint);
        float minTextSize = this.getMinTextSize();
        RectF bounds = this.getTextBounds(paint);
        while ((size.height > bounds.height() || size.width > bounds.width()) && textSize >= minTextSize) {
            paint.setTextSize(textSize *= 0.975f);
            size = this.getReductionTextSize(textLines, paint);
        }
        textSize = Math.max(textSize, minTextSize);
        paint.setTextSize(textSize);
        this.drawTextLines(canvas, textLines, paint);
    }

    private float getMinTextSize() {
        return 1.0f;
    }

    private float getParagraphTextHeight(List<String> textLines, Paint paint) {
        float wholeHeight = 0.0f;
        RectF bounds = this.getTextBounds(paint);
        for (String line : textLines) {
            int offsetPos;
            wholeHeight += paint.getTextSize();
            for (int currentPos = paint.breakText(line, true, bounds.width(), null); currentPos < line.length(); currentPos += offsetPos) {
                String nextLine = line.substring(currentPos);
                offsetPos = paint.breakText(nextLine, true, bounds.width(), null);
                wholeHeight += paint.getTextSize();
            }
        }
        return wholeHeight;
    }

    private List<String> splitParagraphText(List<String> textLines, Paint paint) {
        ArrayList<String> splitLines = new ArrayList<String>();
        RectF bounds = this.getTextBounds(paint);
        Iterator<String> iterator = textLines.iterator();
        while (iterator.hasNext()) {
            String line;
            String remainderText = line = iterator.next();
            while (remainderText.length() > 0) {
                int offsetPos = paint.breakText(remainderText, true, bounds.width(), null);
                String splitText = remainderText.substring(0, offsetPos);
                splitLines.add(splitText);
                remainderText = remainderText.substring(offsetPos);
            }
        }
        return splitLines;
    }

    protected void drawTextLines(Canvas canvas, List<String> textLines, Paint paint) {
        float startY;
        RectF bounds = this.getTextBounds(paint);
        canvas.save();
        RectF rect = this.getContentBounds();
        canvas.clipRect(rect);
        float lineHeight = Math.max(bounds.height() / (float)textLines.size(), paint.getTextSize());
        float gapY = (paint.ascent() + paint.descent()) / 2.0f;
        float currentY = startY = bounds.top + lineHeight / 2.0f - gapY;
        float maxTapeLength = this.getMaxTapeLength();
        ObjectData.SizeF contentSize = this.determineContentSize();
        if ((float)contentSize.degree != 0.0f) {
            float degree = contentSize.degree;
            float centerX = (bounds.right + bounds.left) / 2.0f;
            float centerY = (bounds.top + bounds.bottom) / 2.0f;
            canvas.rotate(degree, centerX, centerY);
        }
        for (String line : textLines) {
            float offsetX = 0.0f;
            if (this.mTextAlignment == ObjectData.TextAlignment.Center) {
                offsetX = (bounds.width() - this.getTextWidth(line, paint)) / 2.0f;
            } else if (this.mTextAlignment == ObjectData.TextAlignment.Right) {
                offsetX = bounds.width() - this.getTextWidth(line, paint);
            }
            int endPos = paint.breakText(line, true, maxTapeLength, null) + 1;
            if (endPos > line.length()) {
                endPos = line.length();
            }
            canvas.drawText(line, 0, endPos, bounds.left + offsetX, currentY, paint);
            currentY += lineHeight;
        }
        canvas.restore();
    }

    protected RectF getTextBounds(Paint textPaint) {
        RectF textBounds = this.getContentBounds();
        if (textPaint != null) {
            float skewRate = this.getSkewOffsetRate();
            float leftOffset = textPaint.descent() * skewRate;
            textBounds.left += leftOffset;
            float rightOffset = -textPaint.ascent() * skewRate;
            textBounds.right -= rightOffset;
            float boldOffsetX = (textPaint.descent() - textPaint.ascent()) * this.getBoldOffsetRate();
            textBounds.inset(boldOffsetX, 0.0f);
        }
        return textBounds;
    }

    private ObjectData.SizeF getReductionTextSize(List<String> textLines, Paint paint) {
        ObjectData.SizeF size = new ObjectData.SizeF();
        size.height = paint.getTextSize() * (float)textLines.size();
        for (String line : textLines) {
            float lineWidth = this.getTextWidth(line, paint);
            size.width = Math.max(size.width, lineWidth);
        }
        return size;
    }

    protected float getTextWidth(String text, Paint paint) {
        float textHeight = paint.descent() - paint.ascent();
        float skewOffset = textHeight * this.getSkewOffsetRate();
        float boldOffset = textHeight * this.getBoldOffsetRate();
        float textWidth = paint.measureText(text) + skewOffset + boldOffset;
        return textWidth;
    }

    private float getSkewOffsetRate() {
        float rate = Math.abs(-0.25f);
        return this.mIsItalic ? rate : 0.0f;
    }

    protected float getBoldOffsetRate() {
        return this.mIsBold ? 0.04f : 0.0f;
    }
}

