/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.formdata;

import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.RectF;
import java.util.Map;
import jp.co.kingjim.tepraprint.sdk.formdata.ObjectData;
import jp.co.kingjim.tepraprint.sdk.formdata.ObjectDataFactory;
import jp.co.kingjim.tepraprint.sdk.formdata.ObjectDataFrame;

public class ObjectDataSecondFrame
extends ObjectDataFrame {
    private boolean mTapeLengthAuto = false;

    public ObjectDataSecondFrame(Map<String, Object> objectInfo, Map<String, Object> contextInfo, ObjectDataFactory factory) {
        super(objectInfo, contextInfo, factory);
        ObjectData childObj;
        Boolean tapeLengthAuto = (Boolean)objectInfo.get("TepraTapeLengthAuto");
        if (tapeLengthAuto != null) {
            this.mTapeLengthAuto = tapeLengthAuto;
        }
        if (this.mChildren.size() == 1 && !(childObj = (ObjectData)this.mChildren.get(0)).getClass().equals(ObjectDataFrame.class)) {
            childObj.isSingleContent = true;
        }
    }

    @Override
    public void drawContent(Canvas canvas) {
        super.drawContent(canvas);
        ObjectData.BorderType borderType = this.getBorderType();
        if (borderType == ObjectData.BorderType.None) {
            return;
        }
        RectF bounds = this.getBounds();
        if (bounds.width() == 0.0f || bounds.height() == 0.0f) {
            return;
        }
        float width = this.getBorderWidth(this.getLineThickness(), this.getTapeWidth());
        Paint paint = new Paint();
        if (this.getLineStyle() == ObjectData.LineStyle.Dotted) {
            float[] dash = new float[]{5.0f * bounds.height() * 0.02f, 5.0f * bounds.height() * 0.04f};
            DashPathEffect effect = new DashPathEffect(dash, 0.0f);
            paint.setPathEffect((PathEffect)effect);
        }
        paint.setStrokeWidth(width);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeCap(Paint.Cap.SQUARE);
        Paint whitePaint = new Paint();
        whitePaint.setStrokeWidth(width);
        whitePaint.setColor(-1);
        whitePaint.setStyle(Paint.Style.FILL);
        whitePaint.setStrokeCap(Paint.Cap.SQUARE);
        canvas.drawLine(bounds.left, bounds.top, bounds.left, bounds.bottom, whitePaint);
        canvas.drawLine(bounds.right, bounds.top, bounds.right, bounds.bottom, whitePaint);
        canvas.drawLine(bounds.left, bounds.top, bounds.right, bounds.top, whitePaint);
        canvas.drawLine(bounds.left, bounds.bottom, bounds.right, bounds.bottom, whitePaint);
        switch (borderType) {
            case Square: {
                canvas.drawLine(bounds.left, bounds.top, bounds.left, bounds.bottom, paint);
                canvas.drawLine(bounds.right, bounds.top, bounds.right, bounds.bottom, paint);
                canvas.drawLine(bounds.left, bounds.top, bounds.right, bounds.top, paint);
                canvas.drawLine(bounds.left, bounds.bottom, bounds.right, bounds.bottom, paint);
                break;
            }
            case LeftRight: {
                canvas.drawLine(bounds.left, bounds.top, bounds.left, bounds.bottom, paint);
                canvas.drawLine(bounds.right, bounds.top, bounds.right, bounds.bottom, paint);
                break;
            }
            case TopBottom: {
                canvas.drawLine(bounds.left, bounds.top, bounds.right, bounds.top, paint);
                canvas.drawLine(bounds.left, bounds.bottom, bounds.right, bounds.bottom, paint);
                break;
            }
            case Top: {
                canvas.drawLine(bounds.left, bounds.top, bounds.right, bounds.top, paint);
                break;
            }
            case Bottom: {
                canvas.drawLine(bounds.left, bounds.bottom, bounds.right, bounds.bottom, paint);
                break;
            }
            case Left: {
                canvas.drawLine(bounds.left, bounds.top, bounds.left, bounds.bottom, paint);
                break;
            }
            case Right: {
                canvas.drawLine(bounds.right, bounds.top, bounds.right, bounds.bottom, paint);
                break;
            }
            case Round: {
                float radius = bounds.height() * 0.1f;
                canvas.drawRoundRect(bounds, radius, radius, paint);
                break;
            }
        }
    }

    @Override
    protected ObjectData.SizeF determineContentSize() {
        ObjectData.SizeF determinedSize = super.determineContentSize();
        ObjectData.SizeF contentSize = this.getContentSize();
        if (!this.mTapeLengthAuto) {
            determinedSize.width = contentSize.width;
        }
        determinedSize.height = Math.max(determinedSize.height, contentSize.height);
        return determinedSize;
    }

    @Override
    protected boolean adjustsBoundsOfLastChild() {
        return false;
    }
}

