/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.formdata;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.text.TextUtils;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import jp.co.kingjim.tepraprint.sdk.TepraPrintQRCode;
import jp.co.kingjim.tepraprint.sdk.formdata.ObjectData;
import jp.co.kingjim.tepraprint.sdk.formdata.Utils;

public class ObjectDataQRCode
extends ObjectData {
    private ObjectData.QRCorrectQualityType mQualityType;
    private ObjectData.QREncodeType mEncodeType;
    private String mQRCodeSize;

    public ObjectDataQRCode(Map<String, Object> objectInfo, Map<String, Object> contextInfo) {
        super(objectInfo, contextInfo);
        String typeStr = (String)objectInfo.get("TepraQRCorrectQualityType");
        this.mQualityType = Utils.getEnumValue(ObjectData.QRCorrectQualityType.class, typeStr);
        if (this.mQualityType == null) {
            this.mQualityType = ObjectData.QRCorrectQualityType.Middle;
        }
        String encodeStr = (String)objectInfo.get("TepraQREncodeType");
        this.mEncodeType = Utils.getEnumValue(ObjectData.QREncodeType.class, encodeStr);
        if (this.mEncodeType == null) {
            this.mEncodeType = ObjectData.QREncodeType.ShiftJIS;
        }
        this.mQRCodeSize = (String)objectInfo.get("TepraQRCodeSize");
        if (this.mQRCodeSize == null) {
            this.mQRCodeSize = "TepraQRCodeSizeStandard";
        }
    }

    @Override
    public void drawContent(Canvas canvas) {
        super.drawContent(canvas);
        canvas.save();
        RectF contentRect = this.getContentBounds();
        String encode = null;
        switch (this.mEncodeType) {
            case ShiftJIS: {
                encode = "Shift_JIS";
                break;
            }
            case Windows1252: {
                encode = "Windows-1252";
                break;
            }
            case UTF8: {
                encode = "UTF-8";
            }
        }
        String content = this.getStringContent();
        if (content != null) {
            try {
                int contentHeight;
                Bitmap bitmap;
                byte[] code = content.getBytes(encode);
                String codeStr = new String(code, encode);
                if (TextUtils.equals((CharSequence)content, (CharSequence)codeStr) && (bitmap = TepraPrintQRCode.makeCodePrivate(code, contentHeight = (int)Math.min(contentRect.width(), contentRect.height()), TepraPrintQRCode.DataCorrectQuality.valueOf(this.mQualityType.name()), false, !this.mQRCodeSize.equals("TepraQRCodeSizeLarge"))) != null) {
                    int bitmapWidth = bitmap.getWidth();
                    int bitmapHeight = bitmap.getHeight();
                    Rect srcRect = new Rect(0, 0, bitmapWidth, bitmapHeight);
                    float left = contentRect.left + (contentRect.width() - (float)bitmapWidth) / 2.0f;
                    float top = contentRect.top + (contentRect.height() - (float)bitmapHeight) / 2.0f;
                    RectF destRect = new RectF(left, top, left + (float)bitmapWidth, top + (float)bitmapHeight);
                    Paint paint = new Paint();
                    ObjectData.SizeF contentSize = this.determineContentSize();
                    if (contentSize.degree != 0 && contentSize.degree % 90 == 0) {
                        float degree = contentSize.degree;
                        float centerX = (destRect.right + destRect.left) / 2.0f;
                        float centerY = (destRect.top + destRect.bottom) / 2.0f;
                        canvas.rotate(degree, centerX, centerY);
                    }
                    canvas.drawBitmap(bitmap, srcRect, destRect, paint);
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        canvas.restore();
    }

    @Override
    protected ObjectData.SizeF determineContentSize() {
        return this.getContentSize();
    }

    @Override
    protected float getBorderArea(int tapeWidth) {
        float borderArea = this.getBorderWidth(ObjectData.LineThickness.Bold, tapeWidth);
        if (this.drawAreaType == ObjectData.DrawAreaType.Expand) {
            borderArea = this.isSingleContent ? (1 == tapeWidth ? -(borderArea / 2.5f) : -(borderArea / 2.0f)) : (borderArea /= 2.0f);
        }
        return borderArea;
    }
}

