/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.formdata;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import java.util.Map;
import jp.co.kingjim.tepraprint.sdk.TepraPrintBitmapBinarizer;
import jp.co.kingjim.tepraprint.sdk.formdata.ObjectData;
import jp.co.kingjim.tepraprint.sdk.formdata.Utils;

public class ObjectDataImage
extends ObjectData {
    private ObjectData.BinarizationMode mBinarizationMode = ObjectData.BinarizationMode.Threshold;
    private ObjectData.ImageAlignment mAlignment = ObjectData.ImageAlignment.Left;
    private int mThreshold = 128;

    public ObjectDataImage(Map<String, Object> objectInfo, Map<String, Object> contextInfo) {
        super(objectInfo, contextInfo);
        String imageAlignmentStr;
        Float threshold;
        String binarizationModeStr = (String)objectInfo.get("TepraBinarizationMode");
        if (binarizationModeStr != null) {
            this.mBinarizationMode = Utils.getEnumValue(ObjectData.BinarizationMode.class, binarizationModeStr);
        }
        if (this.mBinarizationMode == ObjectData.BinarizationMode.Threshold && (threshold = (Float)objectInfo.get("TepraBinarizationThreshold")) != null) {
            this.mThreshold = threshold.intValue();
        }
        if ((imageAlignmentStr = (String)objectInfo.get("TepraImageAlignment")) != null) {
            this.mAlignment = Utils.getEnumValue(ObjectData.ImageAlignment.class, imageAlignmentStr);
        }
    }

    @Override
    public void drawContent(Canvas canvas) {
        super.drawContent(canvas);
        canvas.save();
        RectF rect = this.getContentBounds();
        canvas.clipRect(rect);
        float inset = this.getBounds().height() * 0.05f;
        rect.inset(inset, inset);
        Bitmap bitmap = this.getBitmapContent();
        if (bitmap != null) {
            Matrix matrix = new Matrix();
            RectF binarizedRect = new RectF(0.0f, 0.0f, (float)bitmap.getWidth(), (float)bitmap.getHeight());
            matrix.setRectToRect(binarizedRect, rect, Matrix.ScaleToFit.CENTER);
            matrix.mapRect(binarizedRect);
            int bitmapWidth = (int)(binarizedRect.width() + 0.5f);
            int bitmapHeight = (int)(binarizedRect.height() + 0.5f);
            Bitmap binarizedBitmap = null;
            switch (this.mBinarizationMode) {
                case Threshold: {
                    binarizedBitmap = TepraPrintBitmapBinarizer.convertByThreshold(bitmap, bitmapWidth, bitmapHeight, -16777216, this.mThreshold);
                    break;
                }
                case Dither: {
                    binarizedBitmap = TepraPrintBitmapBinarizer.convertByDither(bitmap, bitmapWidth, bitmapHeight, -16777216);
                    break;
                }
                case Halftone: {
                    binarizedBitmap = TepraPrintBitmapBinarizer.convertByScreen(bitmap, bitmapWidth, bitmapHeight, -16777216);
                }
            }
            if (binarizedBitmap != null) {
                RectF imageRect = new RectF();
                imageRect.left = rect.left;
                imageRect.top = rect.top + (rect.height() - (float)binarizedBitmap.getHeight()) / 2.0f;
                imageRect.right = imageRect.left + (float)binarizedBitmap.getWidth();
                imageRect.bottom = imageRect.top + (float)binarizedBitmap.getHeight();
                switch (this.mAlignment) {
                    case Left: {
                        break;
                    }
                    case Center: {
                        imageRect.offset((rect.width() - (float)binarizedBitmap.getWidth()) / 2.0f, 0.0f);
                        break;
                    }
                    case Right: {
                        imageRect.offset(rect.width() - (float)binarizedBitmap.getWidth(), 0.0f);
                        break;
                    }
                }
                Rect srcRect = new Rect(0, 0, binarizedBitmap.getWidth(), binarizedBitmap.getHeight());
                Paint paint = new Paint();
                paint.setAntiAlias(false);
                ObjectData.SizeF contentSize = this.determineContentSize();
                if ((float)contentSize.degree != 0.0f) {
                    float degree = contentSize.degree;
                    float centerX = (imageRect.right + imageRect.left) / 2.0f;
                    float centerY = (imageRect.top + imageRect.bottom) / 2.0f;
                    canvas.rotate(degree, centerX, centerY);
                }
                canvas.drawBitmap(binarizedBitmap, srcRect, imageRect, paint);
            }
        }
        canvas.restore();
    }

    @Override
    protected ObjectData.SizeF determineContentSize() {
        return this.getContentSize();
    }
}

