/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.formdata;

import android.graphics.Canvas;
import android.graphics.RectF;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.kingjim.tepraprint.sdk.formdata.ObjectData;
import jp.co.kingjim.tepraprint.sdk.formdata.ObjectDataFactory;
import jp.co.kingjim.tepraprint.sdk.formdata.Utils;

public class ObjectDataFrame
extends ObjectData {
    private ObjectData.LayoutDirection mLayoutDirection;
    protected List<ObjectData> mChildren;

    public ObjectDataFrame(Map<String, Object> objectInfo, Map<String, Object> contextInfo, ObjectDataFactory factory) {
        super(objectInfo, contextInfo);
        String directionStr = (String)objectInfo.get("TepraLayoutDirection");
        this.mLayoutDirection = Utils.getEnumValue(ObjectData.LayoutDirection.class, directionStr);
        if (this.mLayoutDirection == null) {
            this.mLayoutDirection = ObjectData.LayoutDirection.Horizontal;
        }
        List childFrames = (List)objectInfo.get("TepraFrames");
        ArrayList<ObjectData> childObjects = new ArrayList<ObjectData>();
        if (childFrames != null) {
            HashMap<String, Object> contextForChild = new HashMap<String, Object>(contextInfo);
            ObjectData.SizeF size = this.getContentSize();
            contextForChild.put("ObjectParameterBaseWidth", Float.valueOf(size.width));
            contextForChild.put("ObjectParameterBaseHeight", Float.valueOf(size.height));
            contextForChild.put("ObjectParameterSizeMode", (Object)this.getFrameSizeMode());
            contextForChild.put("ObjectParameterResolution", this.getResolution());
            contextForChild.put("ObjectParameterShowFrame", this.shouldShowFrame());
            contextForChild.put("ObjectParameterTapeWidth", this.getTapeWidth());
            for (Object childFrame : childFrames) {
                Map childFrameMap = (Map)childFrame;
                ObjectData childObj = factory.create(childFrameMap, contextForChild);
                if (childObj == null) continue;
                childObj.setParentDrawAreaType(this.drawAreaType);
                childObjects.add(childObj);
            }
        }
        this.mChildren = childObjects;
    }

    @Override
    public void drawContent(Canvas canvas) {
        for (ObjectData child : this.mChildren) {
            child.drawContent(canvas);
        }
        super.drawContent(canvas);
    }

    @Override
    protected ObjectData.SizeF determineContentSize() {
        ObjectData.SizeF determinedSize = new ObjectData.SizeF();
        if (this.mLayoutDirection == ObjectData.LayoutDirection.Horizontal) {
            for (ObjectData objData : this.mChildren) {
                ObjectData.SizeF objSize = objData.getDeterminedContentSize();
                determinedSize.width += objSize.width;
                determinedSize.height = Math.max(determinedSize.height, objSize.height);
            }
        } else if (this.mLayoutDirection == ObjectData.LayoutDirection.Vertical) {
            for (ObjectData objData : this.mChildren) {
                ObjectData.SizeF objSize = objData.getDeterminedContentSize();
                determinedSize.width = Math.max(determinedSize.width, objSize.width);
                determinedSize.height += objSize.height;
            }
        }
        if (this.mChildren == null || this.mChildren.size() < 1) {
            determinedSize.width = Math.max(determinedSize.width, this.mContentSize.width);
            determinedSize.height = Math.max(determinedSize.height, this.mContentSize.height);
        }
        return determinedSize;
    }

    @Override
    public void setBounds(RectF bounds) {
        super.setBounds(bounds);
        float currentX = bounds.left;
        float currentY = bounds.top;
        for (ObjectData child : this.mChildren) {
            ObjectData.SizeF size = child.getDeterminedContentSize();
            RectF childBounds = null;
            if (this.mLayoutDirection == ObjectData.LayoutDirection.Horizontal) {
                childBounds = new RectF(currentX, currentY, currentX + size.width, currentY + bounds.height());
                currentX += size.width;
            } else {
                childBounds = new RectF(currentX, currentY, currentX + bounds.width(), currentY + size.height);
                currentY += size.height;
            }
            child.setBounds(childBounds);
        }
        if (this.mChildren.size() > 0 && this.adjustsBoundsOfLastChild()) {
            ObjectData lastChild = this.mChildren.get(this.mChildren.size() - 1);
            RectF lastBounds = lastChild.getBounds();
            if (this.mLayoutDirection == ObjectData.LayoutDirection.Horizontal) {
                lastBounds.right = bounds.right;
            } else {
                lastBounds.bottom = bounds.bottom;
            }
            lastChild.setBounds(lastBounds);
        }
    }

    @Override
    public void setPage(int pageIndex) {
        for (ObjectData child : this.mChildren) {
            child.setPage(pageIndex);
        }
        super.setPage(pageIndex);
    }

    protected boolean adjustsBoundsOfLastChild() {
        return true;
    }
}

