/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.formdata;

import java.util.Map;
import jp.co.kingjim.tepraprint.sdk.TepraPrintDataProvider;
import jp.co.kingjim.tepraprint.sdk.formdata.ObjectData;
import jp.co.kingjim.tepraprint.sdk.formdata.ObjectDataBarcode;
import jp.co.kingjim.tepraprint.sdk.formdata.ObjectDataDataMatrix;
import jp.co.kingjim.tepraprint.sdk.formdata.ObjectDataFrame;
import jp.co.kingjim.tepraprint.sdk.formdata.ObjectDataImage;
import jp.co.kingjim.tepraprint.sdk.formdata.ObjectDataQRCode;
import jp.co.kingjim.tepraprint.sdk.formdata.ObjectDataString;
import jp.co.kingjim.tepraprint.sdk.formdata.ObjectDataVerticalString;
import jp.co.kingjim.tepraprint.sdk.formdata.Utils;

public class ObjectDataFactory {
    private TepraPrintDataProvider mDataProvider;

    public ObjectDataFactory(TepraPrintDataProvider dataProvider) {
        this.mDataProvider = dataProvider;
    }

    public ObjectData create(Map<String, Object> objectInfo, Map<String, Object> contextInfo) {
        ObjectData objectData = null;
        String contentTypeStr = (String)objectInfo.get("TepraContentType");
        ObjectData.ContentType contentType = Utils.getEnumValue(ObjectData.ContentType.class, contentTypeStr);
        switch (contentType) {
            case Frame: {
                objectData = new ObjectDataFrame(objectInfo, contextInfo, this);
                break;
            }
            case String: {
                objectData = new ObjectDataString(objectInfo, contextInfo);
                break;
            }
            case VerticalString: {
                objectData = new ObjectDataVerticalString(objectInfo, contextInfo);
                break;
            }
            case Image: {
                objectData = new ObjectDataImage(objectInfo, contextInfo);
                break;
            }
            case Barcode: {
                objectData = new ObjectDataBarcode(objectInfo, contextInfo);
                break;
            }
            case QRCode: {
                objectData = new ObjectDataQRCode(objectInfo, contextInfo);
                break;
            }
            case DataMatrix: {
                objectData = new ObjectDataDataMatrix(objectInfo, contextInfo);
                break;
            }
        }
        if (objectData != null) {
            objectData.setDataProvider(this.mDataProvider);
        }
        return objectData;
    }
}

