/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.formdata;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import java.util.Map;
import jp.co.kingjim.tepraprint.sdk.TepraPrintDataMatrix;
import jp.co.kingjim.tepraprint.sdk.TepraPrintLogger;
import jp.co.kingjim.tepraprint.sdk.formdata.ObjectData;
import jp.co.kingjim.tepraprint.sdk.formdata.Utils;

public class ObjectDataDataMatrix
extends ObjectData {
    private ObjectData.DataMatrixShape mShape;
    private ObjectData.DataMatrixPrefix mPrefix;

    public ObjectDataDataMatrix(Map<String, Object> objectInfo, Map<String, Object> contextInfo) {
        super(objectInfo, contextInfo);
        String shapeStr = (String)objectInfo.get("TepraDataMatrixShape");
        this.mShape = Utils.getEnumValue(ObjectData.DataMatrixShape.class, shapeStr);
        if (this.mShape == null) {
            this.mShape = ObjectData.DataMatrixShape.Square;
        }
        String prefixStr = (String)objectInfo.get("TepraDataMatrixPrefix");
        this.mPrefix = Utils.getEnumValue(ObjectData.DataMatrixPrefix.class, prefixStr);
        if (this.mPrefix == null) {
            this.mPrefix = ObjectData.DataMatrixPrefix.None;
        }
    }

    @Override
    public void drawContent(Canvas canvas) {
        Bitmap bitmap;
        super.drawContent(canvas);
        canvas.save();
        RectF contentRect = this.getContentBounds();
        canvas.clipRect(contentRect);
        String content = this.getStringContent();
        if (content != null && (bitmap = TepraPrintDataMatrix.makeCode(content.getBytes(), TepraPrintDataMatrix.ShapeType.valueOf(this.mShape.name()), TepraPrintDataMatrix.PrefixType.valueOf(this.mPrefix.name()), 1)) != null) {
            TepraPrintLogger.d("<DataMatrix> Bitmap.width:" + bitmap.getWidth() + " Bitmap.height:" + bitmap.getHeight());
            float scale = 1.0f;
            float scalew = 1.0f;
            float printableAreaHeight = contentRect.height();
            float printableAreaWidth = contentRect.width();
            if (bitmap.getHeight() < (int)printableAreaHeight) {
                scale = printableAreaHeight / (float)bitmap.getHeight();
            }
            if (bitmap.getWidth() < (int)printableAreaWidth) {
                scalew = printableAreaWidth / (float)bitmap.getWidth();
            }
            scale = Math.min(scale, scalew);
            TepraPrintLogger.d("<DataMatrix> contentRect.top:" + contentRect.top + " contentRect.bottom:" + contentRect.bottom + " getBorderArea:" + this.getBorderArea(this.getTapeWidth()));
            TepraPrintLogger.d("<DataMatrix> scale:" + scale + " printableAreaHeight:" + printableAreaHeight);
            Bitmap scaledBitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)((int)((float)bitmap.getWidth() * scale)), (int)((int)((float)bitmap.getHeight() * scale)), (boolean)false);
            bitmap.recycle();
            bitmap = null;
            int bitmapWidth = scaledBitmap.getWidth();
            int bitmapHeight = scaledBitmap.getHeight();
            TepraPrintLogger.d("<DataMatrix> scaledBitmap.width:" + bitmapWidth + " scaledBitmap.height:" + bitmapHeight);
            Rect srcRect = new Rect(0, 0, bitmapWidth, bitmapHeight);
            int left = (int)(contentRect.left + (contentRect.width() - (float)bitmapWidth) / 2.0f);
            int top = (int)(contentRect.top + (contentRect.height() - (float)bitmapHeight) / 2.0f);
            RectF destRect = new RectF((float)left, (float)top, (float)(left + bitmapWidth), (float)(top + bitmapHeight));
            Paint paint = new Paint();
            TepraPrintLogger.d("<DataMatrix> destRect.left:" + left + " destRect.top:" + top + " destRect.width:" + (left + bitmapWidth) + " destRect.height:" + (top + bitmapHeight));
            ObjectData.SizeF contentSize = this.determineContentSize();
            if (contentSize.degree != 0 && contentSize.degree % 90 == 0) {
                float degree = contentSize.degree;
                float centerX = (destRect.right + destRect.left) / 2.0f;
                float centerY = (destRect.top + destRect.bottom) / 2.0f;
                canvas.rotate(degree, centerX, centerY);
            }
            canvas.drawBitmap(scaledBitmap, srcRect, destRect, paint);
        }
        canvas.restore();
    }

    @Override
    protected ObjectData.SizeF determineContentSize() {
        return this.getContentSize();
    }
}

