/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.formdata;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import java.util.Map;
import jp.co.kingjim.tepraprint.sdk.TepraPrintBarcode;
import jp.co.kingjim.tepraprint.sdk.formdata.ObjectData;
import jp.co.kingjim.tepraprint.sdk.formdata.Utils;

public class ObjectDataBarcode
extends ObjectData {
    private ObjectData.BarcodeType mBarcodeType = ObjectData.BarcodeType.JAN13;
    private ObjectData.BarcodeWidth mBarcodeWidth = ObjectData.BarcodeWidth.Standard;
    private ObjectData.BarcodeRatio mBarcodeRatio = ObjectData.BarcodeRatio.Medium;
    private boolean mShowText = false;
    private boolean mCheckDigit = false;
    private boolean mStretch = false;

    public ObjectDataBarcode(Map<String, Object> objectInfo, Map<String, Object> contextInfo) {
        super(objectInfo, contextInfo);
        Boolean stretch;
        Boolean checkDigit;
        Boolean showText;
        String barcodeTypeStr = (String)objectInfo.get("TepraBarcodeType");
        this.mBarcodeType = Utils.getEnumValue(ObjectData.BarcodeType.class, barcodeTypeStr);
        if (this.mBarcodeType == null) {
            this.mBarcodeType = ObjectData.BarcodeType.JAN13;
        } else if (this.mBarcodeType == ObjectData.BarcodeType.EAN13) {
            this.mBarcodeType = ObjectData.BarcodeType.JAN13;
        } else if (this.mBarcodeType == ObjectData.BarcodeType.EAN8) {
            this.mBarcodeType = ObjectData.BarcodeType.JAN8;
        }
        String barcodeWidthStr = (String)objectInfo.get("TepraBarcodeWidth");
        this.mBarcodeWidth = Utils.getEnumValue(ObjectData.BarcodeWidth.class, barcodeWidthStr);
        if (this.mBarcodeWidth == null) {
            this.mBarcodeWidth = ObjectData.BarcodeWidth.Standard;
        }
        String barcodeRatioStr = (String)objectInfo.get("TepraBarcodeRatio");
        this.mBarcodeRatio = Utils.getEnumValue(ObjectData.BarcodeRatio.class, barcodeRatioStr);
        if (this.mBarcodeRatio == null) {
            this.mBarcodeRatio = ObjectData.BarcodeRatio.Medium;
        }
        if ((showText = (Boolean)objectInfo.get("TepraBarcodeShowText")) != null) {
            this.mShowText = showText;
        }
        if ((checkDigit = (Boolean)objectInfo.get("TepraBarcodeCheckDigit")) != null) {
            this.mCheckDigit = checkDigit;
        }
        if ((stretch = (Boolean)objectInfo.get("TepraBarcodeStretch")) != null) {
            this.mStretch = stretch;
        }
    }

    @Override
    public void drawContent(Canvas canvas) {
        Bitmap bitmap;
        super.drawContent(canvas);
        canvas.save();
        RectF bounds = this.getBounds();
        RectF barcodeRect = this.getContentBounds();
        canvas.clipRect(barcodeRect);
        barcodeRect.inset(bounds.height() * 0.05f, bounds.height() * 0.1f);
        String codeStr = this.getStringContent();
        if (codeStr != null && (bitmap = TepraPrintBarcode.makeCode(codeStr.getBytes(), TepraPrintBarcode.Type.valueOf(this.mBarcodeType.name()), TepraPrintBarcode.Width.valueOf(this.mBarcodeWidth.name()), TepraPrintBarcode.Ratio.valueOf(this.mBarcodeRatio.name()), this.mShowText, this.mCheckDigit, (int)(barcodeRect.height() + 0.5f), this.getResolution())) != null) {
            int bitmapWidth = bitmap.getWidth();
            int bitmapHeight = bitmap.getHeight();
            Rect srcRect = new Rect(0, 0, bitmapWidth, bitmapHeight);
            float left = bounds.left + (bounds.width() - (float)bitmapWidth) / 2.0f;
            float top = bounds.top + (bounds.height() - (float)bitmapHeight) / 2.0f;
            RectF destRect = new RectF(left, top, left + (float)bitmapWidth, top + (float)bitmapHeight);
            Paint paint = new Paint();
            canvas.drawBitmap(bitmap, srcRect, destRect, paint);
        }
        canvas.restore();
    }

    @Override
    protected ObjectData.SizeF determineContentSize() {
        String codeStr;
        ObjectData.SizeF size = this.getContentSize();
        if (this.mStretch && (codeStr = this.getStringContent()) != null) {
            Bitmap bitmap = TepraPrintBarcode.makeCode(codeStr.getBytes(), TepraPrintBarcode.Type.valueOf(this.mBarcodeType.name()), TepraPrintBarcode.Width.valueOf(this.mBarcodeWidth.name()), TepraPrintBarcode.Ratio.valueOf(this.mBarcodeRatio.name()), this.mShowText, this.mCheckDigit, (int)(size.height + 0.5f), this.getResolution());
            size.width = bitmap != null ? (float)bitmap.getWidth() * 1.1f : 0.0f;
        }
        return size;
    }
}

