/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.formdata;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import java.util.Map;
import jp.co.kingjim.tepraprint.sdk.TepraPrintDataProvider;
import jp.co.kingjim.tepraprint.sdk.TepraPrintProductInformation;
import jp.co.kingjim.tepraprint.sdk.formdata.Utils;

public abstract class ObjectData {
    private TepraPrintDataProvider mDataProvider;
    private String mContentID;
    private FrameSizeMode mFrameSizeMode;
    private BorderType mBorderType;
    private LineStyle mLineStyle;
    protected LineThickness mLineThickness;
    private Content mContent;
    protected int mTapeWidth;
    private int mResolution;
    private boolean mShowFrame = true;
    private float mMaxX;
    private RectF mBounds;
    protected SizeF mContentSize;
    private SizeF mDeterminedSize;
    private int mCurrentPage;
    protected DrawAreaType drawAreaType;
    protected boolean isSingleContent;
    private int mModelNumber;

    public ObjectData(Map<String, Object> objectInfo, Map<String, Object> contextInfo) {
        this.mResolution = (Integer)contextInfo.get("ObjectParameterResolution");
        this.mTapeWidth = (Integer)contextInfo.get("ObjectParameterTapeWidth");
        this.mModelNumber = (Integer)contextInfo.get("ObjectParameterModelNumber");
        Boolean showFrame = (Boolean)objectInfo.get("ObjectParameterShowFrame");
        if (showFrame != null) {
            this.mShowFrame = showFrame;
        }
        this.mContentID = (String)objectInfo.get("TepraContentID");
        FrameSizeMode contextSizeMode = (FrameSizeMode)((Object)contextInfo.get("ObjectParameterSizeMode"));
        if (contextSizeMode != null) {
            this.mFrameSizeMode = contextSizeMode;
        } else {
            String sizeModeStr = (String)objectInfo.get("TepraFrameSizeMode");
            this.mFrameSizeMode = Utils.getEnumValue(FrameSizeMode.class, sizeModeStr);
            if (this.mFrameSizeMode == null) {
                this.mFrameSizeMode = FrameSizeMode.MM;
            }
        }
        String borderTypeStr = (String)objectInfo.get("TepraBorderType");
        this.mBorderType = Utils.getEnumValue(BorderType.class, borderTypeStr);
        if (this.mBorderType == null) {
            this.mBorderType = BorderType.None;
        }
        this.drawAreaType = this.mBorderType == BorderType.None ? DrawAreaType.Expand : DrawAreaType.Normal;
        this.isSingleContent = false;
        String lineStyleStr = (String)objectInfo.get("TepraLineStyle");
        this.mLineStyle = Utils.getEnumValue(LineStyle.class, lineStyleStr);
        if (this.mLineStyle == null) {
            this.mLineStyle = LineStyle.Solid;
        }
        String thicknessStr = (String)objectInfo.get("TepraLineThickness");
        this.mLineThickness = Utils.getEnumValue(LineThickness.class, thicknessStr);
        if (this.mLineThickness == null) {
            this.mLineThickness = LineThickness.Standard;
        }
        this.mContentSize = new SizeF();
        Float contentWidth = (Float)objectInfo.get("TepraContentWidth");
        Float parentWidth = (Float)contextInfo.get("ObjectParameterBaseWidth");
        if (parentWidth == null) {
            parentWidth = Float.valueOf(0.0f);
        }
        this.mContentSize.width = contentWidth == null ? parentWidth.floatValue() : this.calcDeviceUnit(contentWidth.floatValue(), parentWidth.floatValue());
        Float contentHeight = (Float)objectInfo.get("TepraContentHeight");
        Float parentHeight = (Float)contextInfo.get("ObjectParameterBaseHeight");
        if (parentHeight == null) {
            parentHeight = Float.valueOf(0.0f);
        }
        this.mContentSize.height = contentHeight == null ? parentHeight.floatValue() : this.calcDeviceUnit(contentHeight.floatValue(), parentHeight.floatValue());
        String rotateStr = (String)objectInfo.get("TepraContentRotate");
        Float degree = (Float)objectInfo.get("TepraContentRotateDegreeValue");
        int degree_int = 0;
        if (degree != null) {
            degree_int = degree.intValue();
        }
        this.mContent = Utils.getEnumValue(Content.class, rotateStr);
        if (this.mContent == null) {
            this.mContent = Content.Rotate0;
        }
        switch (this.mContent) {
            case Rotate0: {
                this.mContentSize.degree = 0;
                break;
            }
            case Rotate90: {
                this.mContentSize.degree = 90;
                break;
            }
            case Rotate180: {
                this.mContentSize.degree = 180;
                break;
            }
            case Rotate270: {
                this.mContentSize.degree = 270;
                break;
            }
            case RotateDegree: {
                if (degree_int >= 0 && degree_int < 360) {
                    this.mContentSize.degree = degree_int;
                    break;
                }
                this.mContentSize.degree = 0;
                break;
            }
            default: {
                this.mContentSize.degree = 0;
            }
        }
    }

    public void drawContent(Canvas canvas) {
        if (!this.mShowFrame || this.mBorderType == BorderType.None || this.mBorderType == BorderType.Round) {
            return;
        }
        RectF bounds = this.mBounds;
        if (bounds.width() == 0.0f || bounds.height() == 0.0f) {
            return;
        }
        float width = this.getBorderWidth(this.mLineThickness, this.mTapeWidth);
        Paint paint = new Paint();
        paint.setStrokeWidth(width);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeCap(Paint.Cap.SQUARE);
        Paint whitePaint = new Paint();
        whitePaint.setStrokeWidth(width);
        whitePaint.setColor(-1);
        whitePaint.setStyle(Paint.Style.FILL);
        whitePaint.setStrokeCap(Paint.Cap.SQUARE);
        switch (this.mBorderType) {
            case Square: {
                canvas.drawLine(bounds.left, bounds.top, bounds.left, bounds.bottom, paint);
                canvas.drawLine(bounds.right, bounds.top, bounds.right, bounds.bottom, paint);
                canvas.drawLine(bounds.left, bounds.top, bounds.right, bounds.top, paint);
                canvas.drawLine(bounds.left, bounds.bottom, bounds.right, bounds.bottom, paint);
                break;
            }
            case LeftRight: {
                canvas.drawLine(bounds.left, bounds.top, bounds.left, bounds.bottom, paint);
                canvas.drawLine(bounds.right, bounds.top, bounds.right, bounds.bottom, paint);
                break;
            }
            case TopBottom: {
                canvas.drawLine(bounds.left, bounds.top, bounds.right, bounds.top, paint);
                canvas.drawLine(bounds.left, bounds.bottom, bounds.right, bounds.bottom, paint);
                break;
            }
            case Top: {
                canvas.drawLine(bounds.left, bounds.top, bounds.right, bounds.top, paint);
                break;
            }
            case Bottom: {
                canvas.drawLine(bounds.left, bounds.bottom, bounds.right, bounds.bottom, paint);
                break;
            }
            case Left: {
                canvas.drawLine(bounds.left, bounds.top, bounds.left, bounds.bottom, paint);
                break;
            }
            case Right: {
                canvas.drawLine(bounds.right, bounds.top, bounds.right, bounds.bottom, paint);
                break;
            }
            case Round: {
                break;
            }
        }
    }

    protected void setBounds(RectF bounds) {
        this.mBounds = new RectF(bounds);
    }

    protected abstract SizeF determineContentSize();

    public void setPage(int pageIndex) {
        this.mCurrentPage = pageIndex;
        this.mDeterminedSize = this.determineContentSize();
    }

    public final void setDataProvider(TepraPrintDataProvider dataProvider) {
        this.mDataProvider = dataProvider;
    }

    protected final String getContentID() {
        return this.mContentID;
    }

    protected final RectF getBounds() {
        return new RectF(this.mBounds);
    }

    protected final FrameSizeMode getFrameSizeMode() {
        return this.mFrameSizeMode;
    }

    protected final BorderType getBorderType() {
        return this.mBorderType;
    }

    protected final LineStyle getLineStyle() {
        return this.mLineStyle;
    }

    protected final LineThickness getLineThickness() {
        return this.mLineThickness;
    }

    protected final Content getContentRotate() {
        return this.mContent;
    }

    protected final int getTapeWidth() {
        return this.mTapeWidth;
    }

    protected final int getResolution() {
        return this.mResolution;
    }

    protected final SizeF getContentSize() {
        return new SizeF(this.mContentSize);
    }

    protected final SizeF getDeterminedContentSize() {
        return new SizeF(this.mDeterminedSize);
    }

    protected final boolean shouldShowFrame() {
        return this.mShowFrame;
    }

    protected float getMaxX() {
        return this.mMaxX;
    }

    protected final int getModelNumber() {
        return this.mModelNumber;
    }

    protected final String getStringContent() {
        String content = null;
        if (this.mDataProvider != null) {
            content = this.mDataProvider.getStringContentData(this.getContentID(), this.getPage());
        }
        return content;
    }

    protected final Bitmap getBitmapContent() {
        Bitmap content = null;
        if (this.mDataProvider != null) {
            content = this.mDataProvider.getBitmapContentData(this.getContentID(), this.getPage());
        }
        return content;
    }

    protected final int getPage() {
        return this.mCurrentPage;
    }

    private final float calcDeviceUnit(float original, float base) {
        float size = original;
        if (this.mFrameSizeMode == FrameSizeMode.MM) {
            size = original / 25.4f * (float)this.mResolution;
        } else if (this.mFrameSizeMode == FrameSizeMode.Inch) {
            size = original * (float)this.mResolution;
        } else if (this.mFrameSizeMode == FrameSizeMode.Percent) {
            if (original > 100.0f) {
                size = base;
            }
            if ((double)base == 0.0) {
                size = original / 25.4f * (float)this.mResolution;
                size = 0.0f;
            } else {
                size = original == 0.0f ? base : base / 100.0f * original;
            }
        }
        return size;
    }

    protected final float getBorderWidth(LineThickness thickness, int tapeWidth) {
        float printable = TepraPrintProductInformation.getPrintableSize(tapeWidth, this.mResolution, this.mModelNumber);
        float borderWidth = Math.max(printable / 38.0f, 2.0f);
        switch (thickness) {
            case Bold: {
                borderWidth = Math.round(borderWidth * 1.4142135f);
                break;
            }
            case Standard: {
                borderWidth = Math.round(borderWidth);
                break;
            }
            case Thin: {
                borderWidth = Math.round(borderWidth / 1.4142135f);
                break;
            }
        }
        return borderWidth;
    }

    protected float getBorderArea(int tapeWidth) {
        float borderArea = this.getBorderWidth(LineThickness.Bold, tapeWidth);
        if (this.drawAreaType == DrawAreaType.Expand) {
            borderArea = this.isSingleContent ? -(borderArea / 2.0f) : (borderArea /= 2.0f);
        }
        return borderArea;
    }

    protected void setParentDrawAreaType(DrawAreaType parentDrawAreaType) {
        if (parentDrawAreaType != this.drawAreaType && this.drawAreaType != DrawAreaType.Normal) {
            this.drawAreaType = parentDrawAreaType;
        }
    }

    protected final float getMaxTapeLength() {
        return 39.37008f * (float)this.getResolution();
    }

    protected final float getMinTapeLength() {
        return 0.39370078f * (float)this.getResolution();
    }

    protected RectF getContentBounds() {
        RectF contentBounds = this.getBounds();
        float border = this.getBorderArea(this.getTapeWidth());
        float dx = Math.min(border, contentBounds.width());
        float dy = Math.min(border, contentBounds.height());
        contentBounds.inset(dx, dy);
        return contentBounds;
    }

    public final class Consts {
        public static final String ContentType = "TepraContentType";
        public static final String ContentID = "TepraContentID";
        public static final String Margins = "TepraMargins";
        public static final String MarginsValue = "TepraMarginsValue";
        public static final String LayoutDirection = "TepraLayoutDirection";
        public static final String FrameSizeMode = "TepraFrameSizeMode";
        public static final String LengthMM = "TepraLengthMM";
        public static final String LengthInch = "TepraLengthInch";
        public static final String TapeLengthAuto = "TepraTapeLengthAuto";
        public static final String BorderType = "TepraBorderType";
        public static final String LineStyle = "TepraLineStyle";
        public static final String LineThickness = "TepraLineThickness";
        public static final String Frames = "TepraFrames";
        public static final String ContentWidth = "TepraContentWidth";
        public static final String ContentHeight = "TepraContentHeight";
        public static final String Font = "TepraFont";
        public static final String TypeFace = "TepraTypeFace";
        public static final String FontSize = "TepraFontSize";
        public static final String FontBold = "TepraFontBold";
        public static final String FontItalic = "TepraFontItalic";
        public static final String TextAlignment = "TepraTextAlignment";
        public static final String LineBreakMode = "TepraLineBreakMode";
        public static final String ImageAlignment = "TepraImageAlignment";
        public static final String BinarizationMode = "TepraBinarizationMode";
        public static final String BinarizationThreshold = "TepraBinarizationThreshold";
        public static final String BarcodeType = "TepraBarcodeType";
        public static final String BarcodeCheckDigit = "TepraBarcodeCheckDigit";
        public static final String BarcodeShowText = "TepraBarcodeShowText";
        public static final String BarcodeWidth = "TepraBarcodeWidth";
        public static final String BarcodeRatio = "TepraBarcodeRatio";
        public static final String BarcodeStretch = "TepraBarcodeStretch";
        public static final String QRCorrectQualityType = "TepraQRCorrectQualityType";
        public static final String QREncodeType = "TepraQREncodeType";
        public static final String QRCodeSize = "TepraQRCodeSize";
        public static final String QRCodeSizeStandard = "TepraQRCodeSizeStandard";
        public static final String QRCodeSizeLarge = "TepraQRCodeSizeLarge";
        public static final String ContentRotate = "TepraContentRotate";
        public static final String ContentRotateDegreeValue = "TepraContentRotateDegreeValue";
        public static final String FontPointValue = "TepraFontPointValue";
        public static final String DataMatrixShape = "TepraDataMatrixShape";
        public static final String DataMatrixPrefix = "TepraDataMatrixPrefix";
        public static final String ObjectParameterResolution = "ObjectParameterResolution";
        public static final String ObjectParameterTapeWidth = "ObjectParameterTapeWidth";
        public static final String ObjectParameterBaseWidth = "ObjectParameterBaseWidth";
        public static final String ObjectParameterBaseHeight = "ObjectParameterBaseHeight";
        public static final String ObjectParameterSizeMode = "ObjectParameterSizeMode";
        public static final String ObjectParameterShowFrame = "ObjectParameterShowFrame";
        public static final String ObjectParameterMaxX = "ObjectParameterMaxX";
        public static final String ObjectParameterTapeLengthAuto = "ObjectParameterTapeLengthAuto";
        public static final String ObjectParameterModelNumber = "ObjectParameterModelNumber";

        private Consts() {
        }
    }

    public static enum FrameSizeMode {
        MM,
        Inch,
        Percent;

    }

    public static enum BorderType {
        None,
        Square,
        Round,
        LeftRight,
        TopBottom,
        Top,
        Bottom,
        Left,
        Right;

    }

    public static enum DrawAreaType {
        Normal,
        Expand;

    }

    public static enum LineStyle {
        Solid,
        Dotted;

    }

    public static enum LineThickness {
        Bold,
        Standard,
        Thin;

    }

    protected class SizeF {
        public float width = 0.0f;
        public float height = 0.0f;
        public int degree = 0;

        public SizeF() {
        }

        public SizeF(SizeF size) {
            this.width = size.width;
            this.height = size.height;
            this.degree = size.degree;
        }
    }

    public static enum Content {
        Rotate0,
        Rotate90,
        Rotate180,
        Rotate270,
        RotateDegree;

    }

    public static enum DataMatrixPrefix {
        None,
        FNC1,
        ReaderProgramming,
        Macro05,
        Macro06;

    }

    public static enum DataMatrixShape {
        Square,
        Rectangle;

    }

    public static enum QREncodeType {
        ShiftJIS,
        Windows1252,
        UTF8;

    }

    public static enum QRCorrectQualityType {
        Low,
        Middle,
        Quality,
        High;

    }

    public static enum BarcodeRatio {
        Small,
        Medium,
        Large;

    }

    public static enum BarcodeWidth {
        Small,
        Standard,
        Large;

    }

    public static enum BarcodeType {
        JAN13,
        JAN8,
        EAN13,
        EAN8,
        NW7,
        ITF,
        UPCA,
        UPCE,
        CODE39,
        CODE128;

    }

    public static enum BinarizationMode {
        Threshold,
        Dither,
        Halftone;

    }

    public static enum ImageAlignment {
        Left,
        Center,
        Right;

    }

    public static enum LineBreakMode {
        Clip,
        Stretch,
        Reduction,
        Paragraph;

    }

    public static enum TextAlignment {
        Left,
        Center,
        Right;

    }

    public static enum FontSize {
        Large,
        Medium,
        Small,
        Point;

    }

    public static enum TypeFace {
        DEFAULT,
        DEFAULTBOLD,
        MONOSPACE,
        SANSSERIF,
        SERIF;

    }

    public static enum LayoutDirection {
        Horizontal,
        Vertical;

    }

    public static enum Margins {
        Standard,
        Minimum,
        Large,
        NumberMM,
        NumberInch;

    }

    public static enum ContentType {
        Base,
        Frame,
        String,
        VerticalString,
        Image,
        QRCode,
        Barcode,
        DataMatrix;

    }
}

