/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.core.command;

import java.util.Map;
import jp.co.kingjim.tepraprint.sdk.core.command.DemandOperation;
import jp.co.kingjim.tepraprint.sdk.core.command.DevicePhase;
import jp.co.kingjim.tepraprint.sdk.core.command.OperationMode;
import jp.co.kingjim.tepraprint.sdk.core.command.PrintCoreDeviceStatus;
import jp.co.kingjim.tepraprint.sdk.core.command.PrintCoreModelNumber;
import jp.co.kingjim.tepraprint.sdk.core.command.PrintCoreStatus;
import jp.co.kingjim.tepraprint.sdk.core.command.PrintCoreTapeWidth;

public class CommandFilter {
    public static final int CMD_GET_LW_STATUS = 1;
    public static final int CMD_ENGAGE_LW = 2;
    public static final int CMD_DISENGAGE_LW = 3;
    public static final int CMD_CHECK_ENGAGE_LW = 4;
    public static final int CMD_GET_LW_INFO = 5;
    public static final int CMD_GET_PORT_STATUS = 256;
    public static final int CMD_SORT_RESET = 257;
    public static final int HEADER_VERSION = 1;
    public static final String ParameterKeyCopies = "ParameterKeyCopies";
    public static final String ParameterKeyTapeCut = "ParameterKeyTapeCut";
    public static final String ParameterKeyHalfCut = "ParameterKeyHalfCut";
    public static final String ParameterKeyLowSpeed = "ParameterKeyPrintSpeed";
    public static final String ParameterKeyDensity = "ParameterKeyDensity";
    public static final String ParameterKeyTapeWidth = "ParameterKeyTapeWidth";
    public static final String CommandFilterParameterKeyTapeWidthConfirmRequired = "ParameterKeyTapeWidthConfirmationRequired";
    public static final String StatusKeyStatus = "ST";
    public static final String StatusKeyError = "ER";
    public static final String StatusKeyTapeWidth = "TW";
    public static final String StatusKeyTapeKind = "TR";
    public static final String StatusKeyErrorDetail = "EI";
    public static final String StatusKeyTapeOption = "TO";
    public static final String StatusKeyInkRibbon = "IR";
    public static final String StatusKeyRibbonRest = "RR";
    public static final String StatusKeyErrorDetail2 = "EJ";
    public static final String StatusKeyPrintPage = "PP";
    public static final String StatusKeyErrorRemain = "ER2";
    public static final String StatusKeyErrorDetailRemain = "EI2";
    public static final String StatusKeyErrorDetail2Remain = "EJ2";
    public static final String StatusKeyOperationStatus = "Operation";
    public static final String StatusKeyTapeColor = "TC";
    public static final String StatusKeyRibbonColor = "RC";
    public static final String StatusKeyJobID = "JI";
    public static final String StatusKeyTapeSw = "TS";
    public static final String StatusKeyT8Sw = "T8S";
    public static final String StatusKeyT8Option = "T8O";
    public static final String StatusKeyT8IsTape = "T8T";
    public static final String StatusKeyTape8bit = "T8B";
    public static final String StatusKeyReceiveBuffer = "RB";
    public static final String StatusKeyWarning = "WA";
    public static final String StatusKeyPrintingPage = "PPN";
    public static final String StatusKeyTapeWinder = "TWS";
    public static final String StatusKeyBigroll = "BR";
    public static final String StatusKeyBrTapeLength_mm = "BTLM";
    public static final String StatusKeyBrTapeLength_inch = "BTLI";
    public static final String StatusKeyBrTapeUsageLength_mm = "BTUL";
    public static final String StatusKeyBrLabelTotal = "BLT";
    public static final String StatusKeyBrLabelCount = "BLC";
    public static final String StatusKeyBrTapeRGBA = "BTR";
    public static final String StatusKeyBrRibbonRGBA = "BRR";
    public static final String StatusKeyBrTapeWidth = "BTW";
    public static final String StatusKeyBrTapeKind = "BTK";
    public static final String StatusKeyBrPrintSpeed = "BPS";
    public static final String StatusKeyBrOption = "BO";
    public static final String StatusKeyBrPrintDensity = "BPD";
    public static final String StatusKeyBrHcutDepth = "BHD";
    public static final String StatusKeyReserved = "RES";
    public static final String StatusKeyReserved3 = "RES3";
    public static final String StatusKeyVersion = "VER";
    public static final String StatusKeyBrSerialNumber = "BSN";
    private long mNativeObject;

    private native void nativeInit();

    private native void nativeTerm();

    private native int nativeOperationFromStatus(int var1, int var2, int var3, int var4, int var5);

    private native void nativeSetLWStatus(Map<String, Integer> var1);

    private native int nativeMakeJobEnvironmentCommand(byte[] var1);

    private native int nativeMakePageEnvironmentCommand(byte[] var1, int var2, int var3, int var4, int var5);

    private native void nativeSetPrintParameter(Map<String, Integer> var1);

    private native int nativeBitmapToRaster(int var1, int var2, byte[] var3, byte[] var4);

    private native int nativeTapeWidthFromLWStatusTWCode(int var1);

    private native int nativeMakePacket(int var1, byte[] var2, byte[] var3, byte[] var4, boolean var5, byte[] var6);

    public CommandFilter() {
        this.nativeInit();
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            this.nativeTerm();
        }
    }

    public OperationMode getOperationFromStatus(DemandOperation operation, DevicePhase phase, PrintCoreStatus status, PrintCoreDeviceStatus deviceStatus, PrintCoreModelNumber model) {
        int mode = this.nativeOperationFromStatus(operation.getIntValue(), phase.getIntValue(), status.getIntValue(), deviceStatus.getIntValue(), model.getIntValue());
        return OperationMode.valueOf(mode);
    }

    public void setLwStatus(Map<String, Integer> status) {
        this.nativeSetLWStatus(status);
    }

    public int createJobEnvironmentCommand(byte[] control) {
        return this.nativeMakeJobEnvironmentCommand(control);
    }

    public int createPageEnvironmentCommand(byte[] control, int length, int width, int margin, int level) {
        return this.nativeMakePageEnvironmentCommand(control, length, width, margin, level);
    }

    public void setPrintParameters(Map<String, Integer> parameter) {
        this.nativeSetPrintParameter(parameter);
    }

    public int convertBitmapToRaster(int width, int height, byte[] bitmap, byte[] raster) {
        return this.nativeBitmapToRaster(width, height, bitmap, raster);
    }

    public PrintCoreTapeWidth getTapeWidthFromLWStatusTWCode(int code) {
        int width = this.nativeTapeWidthFromLWStatusTWCode(code);
        return PrintCoreTapeWidth.valueOf(width);
    }

    public int createPacket(int command, byte[] packet, byte[] data, byte[] infoID, boolean isEngage, byte[] ipaddress) {
        return this.nativeMakePacket(command, packet, data, infoID, isEngage, ipaddress);
    }

    static {
        System.loadLibrary("TepraPrint");
    }
}

