/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.barcode;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import jp.co.kingjim.tepraprint.sdk.TepraPrintBarcode;
import jp.co.kingjim.tepraprint.sdk.barcode.BarcodeGenerator;

public class BarcodeGeneratorUPCE
extends BarcodeGenerator {
    private byte mCheckDigit;

    @Override
    protected boolean checkParameters(byte[] code, TepraPrintBarcode.Width width, TepraPrintBarcode.Ratio ratio, boolean showHRIText, boolean useCheckDegit, int height, int resolution) {
        if (code.length != 6) {
            return false;
        }
        return this.checkCompositionOfCode(code, "1234567890");
    }

    @Override
    protected TepraPrintBarcode.Type getType() {
        return TepraPrintBarcode.Type.UPCE;
    }

    @Override
    protected float getLeftMargin(float moduleWidth) {
        return Math.max(moduleWidth * 8.0f, this.getTextSize());
    }

    @Override
    protected byte[] fillCheckDigit(byte[] code, boolean useCheckDigit) {
        this.mCheckDigit = this.getCheckDigit(code, this.getTypeIndex(this.getType()));
        return code;
    }

    @Override
    protected void drawHRIText(Canvas canvas, String HRIText, float textSize, float barcodeWidth, float moduleWidth) {
        float margin = this.getLeftMargin(moduleWidth);
        float textHeight = this.getActualTextHeight(textSize);
        RectF eraseRect = new RectF(margin, (float)this.mHeight - textHeight / 2.0f, margin + barcodeWidth, (float)this.mHeight);
        Paint erasePaint = new Paint();
        erasePaint.setColor(-1);
        canvas.drawRect(eraseRect, erasePaint);
        String partStr1 = "0";
        float left1 = margin - textSize;
        float top = (float)this.mHeight - textHeight;
        RectF strRect1 = new RectF(left1, top, left1 + textSize, (float)this.mHeight);
        this.drawTextAtEqualSpaces(canvas, partStr1, textSize, strRect1);
        String partStr2 = HRIText;
        float left2 = margin + 3.0f * moduleWidth;
        float partWidth = 42.0f * moduleWidth;
        RectF strRect2 = new RectF(left2, top, left2 + partWidth, (float)this.mHeight);
        this.drawTextAtEqualSpaces(canvas, partStr2, textSize, strRect2);
        String partStr3 = "" + this.mCheckDigit;
        float left3 = margin + barcodeWidth;
        RectF strRect3 = new RectF(left3, top, left3 + textSize, (float)this.mHeight);
        this.drawTextAtEqualSpaces(canvas, partStr3, textSize, strRect3);
    }
}

