/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.barcode;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import java.util.Arrays;
import jp.co.kingjim.tepraprint.sdk.TepraPrintBarcode;
import jp.co.kingjim.tepraprint.sdk.barcode.BarcodeGenerator;

public class BarcodeGeneratorUPCA
extends BarcodeGenerator {
    @Override
    protected boolean checkParameters(byte[] code, TepraPrintBarcode.Width width, TepraPrintBarcode.Ratio ratio, boolean showHRIText, boolean useCheckDegit, int height, int resolution) {
        if (code.length != 11) {
            return false;
        }
        return this.checkCompositionOfCode(code, "1234567890");
    }

    @Override
    protected TepraPrintBarcode.Type getType() {
        return TepraPrintBarcode.Type.UPCA;
    }

    @Override
    protected byte[] fillCheckDigit(byte[] code, boolean useCheckDigit) {
        byte[] filledCode = Arrays.copyOf(code, 12);
        filledCode[11] = 32;
        filledCode[11] = this.getCheckDigit(filledCode, this.getTypeIndex(this.getType()));
        return filledCode;
    }

    @Override
    protected float getLeftMargin(float moduleWidth) {
        return moduleWidth * 11.0f;
    }

    @Override
    protected void drawHRIText(Canvas canvas, String HRIText, float textSize, float barcodeWidth, float moduleWidth) {
        float margin = this.getLeftMargin(moduleWidth);
        float textHeight = this.getActualTextHeight(textSize);
        RectF eraseRect = new RectF(margin, (float)this.mHeight - textHeight / 2.0f, margin + barcodeWidth, (float)this.mHeight);
        Paint erasePaint = new Paint();
        erasePaint.setColor(-1);
        canvas.drawRect(eraseRect, erasePaint);
        String partStr1 = HRIText.substring(0, 1);
        float left1 = margin - textSize;
        float top = (float)this.mHeight - textHeight;
        RectF strRect1 = new RectF(left1, top, left1 + textSize, (float)this.mHeight);
        this.drawTextAtEqualSpaces(canvas, partStr1, textSize, strRect1);
        String partStr2 = HRIText.substring(1, 6);
        float left2 = margin + 10.0f * moduleWidth;
        float partWidth = 35.0f * moduleWidth;
        RectF strRect2 = new RectF(left2, top, left2 + partWidth, (float)this.mHeight);
        this.drawTextAtEqualSpaces(canvas, partStr2, textSize, strRect2);
        String partStr3 = HRIText.substring(6, 11);
        float left3 = strRect2.right + 5.0f * moduleWidth;
        RectF strRect3 = new RectF(left3, top, left3 + partWidth, (float)this.mHeight);
        this.drawTextAtEqualSpaces(canvas, partStr3, textSize, strRect3);
        String partStr4 = HRIText.substring(11);
        float left4 = margin + barcodeWidth;
        RectF strRect4 = new RectF(left4, top, left4 + textSize, (float)this.mHeight);
        this.drawTextAtEqualSpaces(canvas, partStr4, textSize, strRect4);
    }
}

