/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.barcode;

import java.util.Arrays;
import jp.co.kingjim.tepraprint.sdk.TepraPrintBarcode;
import jp.co.kingjim.tepraprint.sdk.barcode.BarcodeGenerator;

public class BarcodeGeneratorNW7
extends BarcodeGenerator {
    @Override
    protected boolean checkParameters(byte[] code, TepraPrintBarcode.Width width, TepraPrintBarcode.Ratio ratio, boolean showHRIText, boolean useCheckDegit, int height, int resolution) {
        if (code.length > 128) {
            return false;
        }
        if (code.length < 2) {
            return false;
        }
        byte[] body = new byte[code.length - 2];
        System.arraycopy(code, 1, body, 0, body.length);
        if (!this.checkCompositionOfCode(body, "0123456789-.$/+:")) {
            return false;
        }
        byte[] startCode = new byte[]{code[0]};
        if (!this.checkCompositionOfCode(startCode, "ABCD")) {
            return false;
        }
        byte[] stopCode = new byte[]{code[code.length - 1]};
        return this.checkCompositionOfCode(stopCode, "ABCD");
    }

    @Override
    protected TepraPrintBarcode.Type getType() {
        return TepraPrintBarcode.Type.NW7;
    }

    @Override
    protected byte[] fillCheckDigit(byte[] code, boolean useCheckDigit) {
        byte[] filledCode = code;
        if (useCheckDigit) {
            byte checkDigit;
            filledCode = Arrays.copyOf(code, code.length + 1);
            filledCode[filledCode.length - 1] = filledCode[filledCode.length - 2];
            filledCode[filledCode.length - 2] = 32;
            filledCode[filledCode.length - 2] = checkDigit = this.getCheckDigit(filledCode, this.getTypeIndex(this.getType()));
        }
        return filledCode;
    }
}

