/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.barcode;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import java.util.Arrays;
import jp.co.kingjim.tepraprint.sdk.TepraPrintBarcode;
import jp.co.kingjim.tepraprint.sdk.barcode.BarcodeGenerator;

public class BarcodeGeneratorJAN
extends BarcodeGenerator {
    TepraPrintBarcode.Type mType;

    public BarcodeGeneratorJAN(JANType type) {
        this.mType = type == JANType.JAN13 ? TepraPrintBarcode.Type.JAN13 : TepraPrintBarcode.Type.JAN8;
    }

    @Override
    protected boolean checkParameters(byte[] code, TepraPrintBarcode.Width width, TepraPrintBarcode.Ratio ratio, boolean showHRIText, boolean useCheckDegit, int height, int resolution) {
        boolean ret = false;
        if (this.mType == TepraPrintBarcode.Type.JAN13) {
            ret = code.length == 12;
        } else {
            boolean bl = ret = code.length == 7;
        }
        if (ret) {
            ret = this.checkCompositionOfCode(code, "1234567890");
        }
        return ret;
    }

    @Override
    protected TepraPrintBarcode.Type getType() {
        return this.mType;
    }

    @Override
    protected byte[] fillCheckDigit(byte[] code, boolean useCheckDigit) {
        byte[] filledCode = null;
        if (this.mType == TepraPrintBarcode.Type.JAN13) {
            byte checkDigit;
            filledCode = Arrays.copyOf(code, 13);
            filledCode[12] = 32;
            filledCode[12] = checkDigit = this.getCheckDigit(filledCode, this.getTypeIndex(this.mType));
        } else {
            byte checkDigit;
            filledCode = Arrays.copyOf(code, 8);
            filledCode[7] = 32;
            filledCode[7] = checkDigit = this.getCheckDigit(filledCode, this.getTypeIndex(this.mType));
        }
        return filledCode;
    }

    @Override
    protected float getLeftMargin(float moduleWidth) {
        float margin = 0.0f;
        margin = this.mType == TepraPrintBarcode.Type.JAN13 ? moduleWidth * 11.0f : moduleWidth * 7.0f;
        return margin;
    }

    @Override
    protected void drawHRIText(Canvas canvas, String HRIText, float textSize, float barcodeWidth, float moduleWidth) {
        float margin = this.getLeftMargin(moduleWidth);
        float textHeight = this.getActualTextHeight(textSize);
        RectF eraseRect = new RectF(margin, (float)this.mHeight - textHeight / 2.0f, margin + barcodeWidth, (float)this.mHeight);
        Paint erasePaint = new Paint();
        erasePaint.setColor(-1);
        canvas.drawRect(eraseRect, erasePaint);
        String remainingText = HRIText;
        float left1 = margin - textSize;
        float top = (float)this.mHeight - textHeight;
        RectF strRect1 = new RectF(left1, top, left1 + textSize, (float)this.mHeight);
        if (this.mType == TepraPrintBarcode.Type.JAN13) {
            String firstStr = remainingText.substring(0, 1);
            this.drawTextAtEqualSpaces(canvas, firstStr, textSize, strRect1);
            remainingText = remainingText.substring(1);
        }
        int charsPerPart = remainingText.length() / 2;
        float partWidth = (float)(charsPerPart * 7) * moduleWidth;
        float left2 = margin + moduleWidth * 3.0f;
        RectF strRect2 = new RectF(left2, top, left2 + partWidth, (float)this.mHeight);
        String leftStr = remainingText.substring(0, charsPerPart);
        this.drawTextAtEqualSpaces(canvas, leftStr, textSize, strRect2);
        float left3 = strRect2.right + 5.0f * moduleWidth;
        RectF strRect3 = new RectF(left3, top, left3 + partWidth, (float)this.mHeight);
        String rightStr = remainingText.substring(charsPerPart);
        this.drawTextAtEqualSpaces(canvas, rightStr, textSize, strRect3);
    }

    public static enum JANType {
        JAN8,
        JAN13;

    }
}

