/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.barcode;

import java.util.Arrays;
import jp.co.kingjim.tepraprint.sdk.TepraPrintBarcode;
import jp.co.kingjim.tepraprint.sdk.barcode.BarcodeGenerator;

public class BarcodeGeneratorITF
extends BarcodeGenerator {
    @Override
    protected boolean checkParameters(byte[] code, TepraPrintBarcode.Width width, TepraPrintBarcode.Ratio ratio, boolean showHRIText, boolean useCheckDegit, int height, int resolution) {
        if (code.length > 128 || code.length == 0) {
            return false;
        }
        return this.checkCompositionOfCode(code, "1234567890");
    }

    @Override
    protected TepraPrintBarcode.Type getType() {
        return TepraPrintBarcode.Type.ITF;
    }

    @Override
    protected byte[] fillCheckDigit(byte[] code, boolean useCheckDigit) {
        byte[] filledCode = code;
        if (useCheckDigit && code.length % 2 == 0 || !useCheckDigit && code.length % 2 == 1) {
            filledCode = new byte[code.length + 1];
            System.arraycopy(code, 0, filledCode, 1, code.length);
            filledCode[0] = 48;
        }
        if (useCheckDigit) {
            byte checkDigit;
            filledCode = Arrays.copyOf(filledCode, filledCode.length + 1);
            filledCode[filledCode.length - 1] = 32;
            filledCode[filledCode.length - 1] = checkDigit = this.getCheckDigit(filledCode, this.getTypeIndex(this.getType()));
        }
        return filledCode;
    }
}

