/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.barcode;

import jp.co.kingjim.tepraprint.sdk.TepraPrintBarcode;
import jp.co.kingjim.tepraprint.sdk.barcode.BarcodeGenerator;

public class BarcodeGeneratorCODE39
extends BarcodeGenerator {
    @Override
    protected boolean checkParameters(byte[] code, TepraPrintBarcode.Width width, TepraPrintBarcode.Ratio ratio, boolean showHRIText, boolean useCheckDegit, int height, int resolution) {
        if (code.length > 128 || code.length == 0) {
            return false;
        }
        return this.checkCompositionOfCode(code, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%");
    }

    @Override
    protected TepraPrintBarcode.Type getType() {
        return TepraPrintBarcode.Type.CODE39;
    }

    @Override
    protected byte[] fillCheckDigit(byte[] code, boolean useCheckDigit) {
        int filledLength = code.length + (useCheckDigit ? 3 : 2);
        byte[] filledCode = new byte[filledLength];
        System.arraycopy(code, 0, filledCode, 1, code.length);
        filledCode[0] = 42;
        filledCode[filledLength - 1] = 42;
        if (useCheckDigit) {
            byte checkDigit;
            filledCode[filledLength - 2] = 32;
            filledCode[filledLength - 2] = checkDigit = this.getCheckDigit(filledCode, this.getTypeIndex(this.getType()));
        }
        return filledCode;
    }
}

