/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kingjim.tepraprint.sdk.barcode;

import android.graphics.Canvas;
import java.util.Arrays;
import jp.co.kingjim.tepraprint.sdk.TepraPrintBarcode;
import jp.co.kingjim.tepraprint.sdk.TepraPrintLogger;
import jp.co.kingjim.tepraprint.sdk.barcode.BarcodeGenerator;

public class BarcodeGeneratorCODE128
extends BarcodeGenerator {
    @Override
    protected boolean checkParameters(byte[] code, TepraPrintBarcode.Width width, TepraPrintBarcode.Ratio ratio, boolean showHRIText, boolean useCheckDegit, int height, int resolution) {
        if (code.length > 128 || code.length == 0) {
            return false;
        }
        String allowedChars = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_abcdefghijklmnopqrstuvwxyz{|}~\uc280\uc281\uc282\uc285\uc287\uc28b";
        return this.checkCompositionOfCode(code, allowedChars);
    }

    @Override
    protected TepraPrintBarcode.Type getType() {
        return TepraPrintBarcode.Type.CODE128;
    }

    @Override
    protected byte[] fillCheckDigit(byte[] code, boolean useCheckDigit) {
        byte checkDigit = this.nativeGetCheckDigitCode128(code);
        byte[] filledCode = Arrays.copyOf(code, code.length + 1);
        filledCode[filledCode.length - 1] = checkDigit;
        return filledCode;
    }

    @Override
    protected byte getCheckDigit(byte[] code, int type) {
        return this.nativeGetCheckDigitCode128(code);
    }

    @Override
    protected byte[] getBarcodeData(byte[] code, int type, int ratio, boolean useCheckDigit) {
        int dot = 0;
        dot = this.mBarcodeWidth == 0 ? (this.mResolution <= 180 ? 1 : 2) : 4;
        TepraPrintLogger.d("BarcodeGeneratorCODE128.getBarcodeData", "mBarcodeWidth=" + this.mBarcodeWidth + ", mResolution=" + this.mResolution + ", dot=" + dot);
        return this.nativeGetBarcodeDataCode128(code, ratio, dot);
    }

    @Override
    protected void drawHRIText(Canvas canvas, String HRIText, float textSize, float barcodeWidth, float moduleWidth) {
        String code128HRI = HRIText.substring(0, HRIText.length() - 1);
        super.drawHRIText(canvas, code128HRI, textSize, barcodeWidth, moduleWidth);
    }

    private native byte nativeGetCheckDigitCode128(byte[] var1);

    private native byte[] nativeGetBarcodeDataCode128(byte[] var1, int var2, int var3);
}

